/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfTable;

public class DxfSTYLE
extends DxfTable {
    public static final short STYLE_VERTICAL = 4;
    public static final short STYLE_USED = 64;
    public static final String STANDARD = "STANDARD";
    public static final String DEFAULT_FONT = "TXT8";
    protected float height;
    protected float aspect = 1.0f;
    protected float slant;
    protected float lastHeight;
    protected short direction;
    protected String fontName;
    protected String bigFontName;

    public DxfSTYLE() {
        this.name = STANDARD;
        this.fontName = DEFAULT_FONT;
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 71: {
                this.direction = (short)ival;
                return true;
            }
        }
        return super.setGroup(grpNr, ival);
    }

    public boolean setGroup(short grpNr, String str) {
        switch (grpNr) {
            case 3: {
                this.fontName = str.toUpperCase();
                int dot = this.fontName.lastIndexOf(46);
                if (dot != -1) {
                    this.fontName = this.fontName.substring(0, dot);
                }
                return true;
            }
            case 4: {
                this.bigFontName = str;
                return true;
            }
        }
        return super.setGroup(grpNr, str);
    }

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 40: {
                this.height = fval;
                return true;
            }
            case 41: {
                this.aspect = fval;
                return true;
            }
            case 50: {
                this.slant = (float)((double)fval / 180.0 * Math.PI);
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean finishRead(DxfFile file) {
        return true;
    }

    public final String getFontName() {
        return this.fontName;
    }
}

