/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.server.model.Session;

public class NativeTradeSession
extends Session {
    private static final Logger logger = Logger.getLogger(NativeTradeSession.class.getName());
    private final int movesLeft;
    private NativeTrade nt;

    private NativeTradeSession(NativeTrade nt) {
        super(NativeTradeSession.makeSessionKey(NativeTradeSession.class, nt.getUnit(), nt.getIndianSettlement()));
        this.movesLeft = nt.getUnit().getMovesLeft();
        this.nt = nt;
    }

    public NativeTrade getNativeTrade() {
        return this.nt;
    }

    public static NativeTrade openSession(NativeTrade nt) {
        nt = new NativeTrade(nt.getUnit(), nt.getIndianSettlement());
        new NativeTradeSession(nt).register();
        nt.initialize();
        return nt;
    }

    @Override
    public boolean complete(ChangeSet cs) {
        boolean ret = super.complete(cs);
        if (this.nt.hasNotTraded()) {
            Unit unit = this.nt.getUnit();
            unit.setMovesLeft(this.movesLeft);
            cs.addPartial(ChangeSet.See.only(unit.getOwner()), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        }
        this.nt.setDone();
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getClass()).append(" moves=").append(this.movesLeft).append(' ').append(this.nt).append(']');
        return sb.toString();
    }
}

