/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;

public class HitpointsCombatModel
extends SimpleCombatModel {
    private static final Logger logger = Logger.getLogger(HitpointsCombatModel.class.getName());

    @Override
    public CombatModel.CombatResult generateAttackResult(Random random, FreeColGameObject attacker, FreeColGameObject defender) {
        LogBuilder lb = new LogBuilder(256);
        lb.add("Combat");
        ArrayList<CombatModel.CombatEffectType> crs = new ArrayList<CombatModel.CombatEffectType>();
        CombatModel.CombatOdds odds = this.calculateCombatOdds(attacker, defender, lb);
        double r = RandomUtils.randomDouble(logger, "AttackResult", random);
        lb.add(" random(1.0)=", r);
        if (this.combatIsAttack(attacker, defender)) {
            Unit attackerUnit = (Unit)attacker;
            Unit defenderUnit = (Unit)defender;
            int defenderDamage = random.nextInt((int)Math.ceil(this.getOffencePower(attacker, defender)) + 1);
            int newDefenderHitpoints = defenderUnit.getHitPoints() - defenderDamage;
            if (newDefenderHitpoints > 0) {
                int newAttackerHitpoints = -1;
                if (attackerUnit.getType().getAttackRange() <= defenderUnit.getType().getAttackRange() || defenderUnit.getTile().getDistanceTo(attackerUnit.getTile()) <= defenderUnit.getType().getAttackRange()) {
                    int attackerDamage = random.nextInt((int)Math.ceil(this.getDefencePower(attacker, defender)) + 1);
                    newAttackerHitpoints = attackerUnit.getHitPoints() - attackerDamage;
                    if (newAttackerHitpoints <= 0) {
                        crs.add(CombatModel.CombatEffectType.LOSE);
                        this.resolveAttack(defenderUnit, attackerUnit, true, (1.25 * r - 0.25 - odds.win) / (1.0 - odds.win), crs);
                        return new CombatModel.CombatResult(crs, 1, newDefenderHitpoints);
                    }
                }
                crs.add(CombatModel.CombatEffectType.WIN);
                return new CombatModel.CombatResult(crs, newAttackerHitpoints, newDefenderHitpoints);
            }
            crs.add(CombatModel.CombatEffectType.WIN);
            this.resolveAttack(attackerUnit, defenderUnit, true, r / (0.1 * odds.win), crs);
            return new CombatModel.CombatResult(crs, -1, 1);
        }
        if (this.combatIsBombard(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            if (!defenderUnit.isNaval()) {
                throw new RuntimeException("Bombard of non-naval: " + attacker + " v " + defender);
            }
            int defenderDamage = random.nextInt((int)Math.ceil(this.getOffencePower(attacker, defender)) + 1);
            if (defenderDamage == 0) {
                crs.add(CombatModel.CombatEffectType.NO_RESULT);
                crs.add(CombatModel.CombatEffectType.EVADE_BOMBARD);
                return new CombatModel.CombatResult(crs, -1, -1);
            }
            int newDefenderHitpoints = defenderUnit.getHitPoints() - defenderDamage;
            if (newDefenderHitpoints > 0) {
                crs.add(CombatModel.CombatEffectType.WIN);
                return new CombatModel.CombatResult(crs, -1, newDefenderHitpoints);
            }
            crs.add(CombatModel.CombatEffectType.WIN);
            crs.add(CombatModel.CombatEffectType.SINK_SHIP_BOMBARD);
            return new CombatModel.CombatResult(crs, -1, -1);
        }
        throw new RuntimeException("Bogus combat: " + attacker + " v " + defender);
    }
}

