/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.layout;

import ca.sqlpower.architect.layout.AbstractLayout;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArchitectGridLayout
extends AbstractLayout {
    private boolean hasBeenCalled = false;
    private static final int LINE_SEPERATOR = 100;
    private static final int SEPERATOR = 20;
    private List<? extends LayoutNode> nodes;

    @Override
    public void setup(Collection<? extends LayoutNode> nodes, Collection<? extends LayoutEdge> edges, Rectangle rect) {
        super.setup(nodes, edges, rect);
        this.nodes = new ArrayList<LayoutNode>(nodes);
    }

    @Override
    public void done() {
        this.nextFrame();
    }

    @Override
    public boolean isDone() {
        return !this.hasBeenCalled;
    }

    @Override
    public void nextFrame() {
        this.hasBeenCalled = true;
        Dimension d = new Dimension(this.frame.x, this.frame.y);
        int maxHeight = 0;
        for (LayoutNode layoutNode : this.nodes) {
            if (d.width + layoutNode.getWidth() > this.frame.x + this.frame.width && d.width != this.frame.x) {
                d.width = this.frame.x;
                d.height = d.height + maxHeight + 100;
                maxHeight = 0;
            }
            layoutNode.setLocation(d.width, d.height);
            d.width += layoutNode.getWidth() + 20;
            maxHeight = Math.max(maxHeight, layoutNode.getHeight());
        }
    }
}

