%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/quoting-another-voice.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
@code{quotedEventTypes} プロパティは、引用される音楽イベントのタイプを@c
指定します。デフォルト値は @code{(note-event rest-event tie-event beam-event
tuplet-span-event)} であり、これは音符、休符、タイ、連桁、連符のみが
@code{\\quoteDuring} によって引用されることを示しています。次の例では、@c
@code{rest-event} がリストに含まれていないため、16 分休符が引用されていません。

イベントのタイプのリストは、内部リファレンスの @qq{Music classes} を@c
参照してください。
"
  doctitleja = "他のボイスを引用する"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Les types d'événements pris en charge pour la citation sont déterminés
par la propriété @code{quotedEventTypes}. Par défaut, sa valeur est
fixée à @code{(note-event rest-event tie-event beam-event
tuplet-span-event)}, ce qui signifie que seuls les notes, silences,
liaisons, ligatures et n-olets seront mentionnés par
@code{\\quoteDuring}.

Dans l'exemple suivant, le quart de soupir n'est pas reproduit puisque
@code{rest-event} n'est pas mentionné parmi les @code{quotedEventTypes}.

Pour connaître la liste des types d'événements, reportez-vous à la
rubrique @emph{Music classes} de la référence des propriétés internes.
"

  doctitlefr = "Citation d'une autre voix"

%% Translation of GIT committish: 0c00cd98e81b27325bed5891b950fe7f0f0ebe5d
  texidoces = "
La propiedad @code{quotedEventTypes} determina los tipos de eventos
musicales que resultan citados.  El valor predeterminado es
@code{(note-event rest-event tie-event beam-event tuplet-span-event)},
que significa que sólo aparecen en la expresión @code{\\quoteDuring}
las notas, silencios, ligaduras, barras y grupos especiales.  En el
ejemplo siguiente, el silencio de semicorchea no aparece en el
fragmento citado porque @code{rest-event} no está dentro de los
@code{quotedEventTypes}.

Para ver una lista de los tipos de evento, consulte la sección
@qq{Music classes} de la Referencia de funcionamiento interno.

"
  doctitlees = "Citar otra voz"

%% Translation of GIT committish: 0a868be38a775ecb1ef935b079000cebbc64de40
  texidocde = "
Die @code{quotedEventTypes}-Eigenschaft bestimmt die
Typen an Musikereignissen, die zitiert werden.  Die
Standardeinstellung ist @code{(note-event rest-event)}, womit
nur Noten und Pausen der zitierten Stimme für den
@code{\\quoteDuring}-Ausdruck übernommen werden.  Im
Beispiel hier wird die 16-Pause nicht übernommen, weil
sich @code{rest-event} nicht in @code{quotedEventTypes} befindet.

"

  doctitlede = "Eine andere Stimme zitieren"

%% Translation of GIT committish: 3f57efa0cde39bf0642fb6fb3672a19262ceda83
  texidocca = "
La propietat @code{quotedEventTypes} determina els tipus
d'esdeveniments musicals que resulten citats.  El valor predeterminat
és @code{(note-event rest-event tie-event beam-event
  tuplet-span-event)}, que significa que sols apareixen en l'expressió
@code{\\quoteDuring} les notes, silencis, lligadures, barres i grups
especials.  A l'exemple següent, el silenci de semicorxera no apareix
en el fragment citat perquè @code{rest-event} no està dins
@code{quotedEventTypes}. 

Per veure una llista dels tipus d'esdeveniment, consulteu la secció
@qq{Music classes} de la Referència de funcionament intern.

"
  doctitleca = "Citació d'una altra veu"

  lsrtags = "staff-notation"

  texidoc = "
The @code{quotedEventTypes} property determines the music event types
which should be quoted.  The default value is
@code{(note-event rest-event tie-event beam-event tuplet-span-event)},
which means that only the notes, rests, ties, beams and tuplets of the
quoted voice will appear in the @code{\\quoteDuring} expression.

In the following example, a 16th rest is not quoted since
@code{rest-event} is not in @code{quotedEventTypes}.

For a list of event types, consult the @qq{Music classes} section of the
Internals Reference.
"

  doctitle = "Quoting another voice"
} % begin verbatim


quoteMe = \relative c' {
  fis4 r16 a8.-> b4\ff c
}
\addQuote quoteMe \quoteMe

original = \relative c'' {
  c8 d s2
  \once \override NoteColumn.ignore-collision = ##t
  es8 gis8
}

<<
  \new Staff \with { instrumentName = "quoteMe" }
  \quoteMe

  \new Staff \with { instrumentName = "orig" }
  \original

  \new Staff \with {
    instrumentName = "orig+quote"
    quotedEventTypes = #'(note-event articulation-event)
  }
  \relative c''
  <<
    \original
    \new Voice {
      s4
      \set fontSize = #-4
      \override Stem.length-fraction = #(magstep -4)
      \quoteDuring "quoteMe" { \skip 2. }
    }
  >>
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
