/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;

public interface ContentDecoder {

    public static class Factories
    extends ContainerLifeCycle
    implements Iterable<Factory>,
    Dumpable {
        private final Map<String, Factory> factories = new LinkedHashMap<String, Factory>();
        private HttpField acceptEncodingField;

        public HttpField getAcceptEncodingField() {
            return this.acceptEncodingField;
        }

        @Override
        public Iterator<Factory> iterator() {
            return this.factories.values().iterator();
        }

        public boolean isEmpty() {
            return this.factories.isEmpty();
        }

        public void clear() {
            this.factories.clear();
            this.acceptEncodingField = null;
        }

        public Factory put(Factory factory) {
            Factory result = this.factories.put(factory.getEncoding(), factory);
            this.updateBean((Object)result, (Object)factory, true);
            StringBuilder header = new StringBuilder();
            this.factories.forEach((? super K encoding, ? super V value) -> {
                if (!header.isEmpty()) {
                    header.append(", ");
                }
                header.append((String)encoding);
                float weight = value.getWeight();
                if (weight != -1.0f) {
                    header.append(";q=").append(new DecimalFormat("#.###").format(weight));
                }
            });
            this.acceptEncodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, header.toString());
            return result;
        }

        public String dump() {
            return Dumpable.dump((Dumpable)this);
        }

        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.factories});
        }
    }

    public static abstract class Factory
    extends ContainerLifeCycle {
        private final String encoding;
        private final float weight;

        protected Factory(String encoding) {
            this(encoding, -1.0f);
        }

        protected Factory(String encoding, float weight) {
            this.encoding = Objects.requireNonNull(encoding);
            if (!(weight == -1.0f || weight >= 0.0f && weight <= 1.0f)) {
                throw new IllegalArgumentException("Invalid weight: " + weight);
            }
            this.weight = weight;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public float getWeight() {
            return this.weight;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Factory)) {
                return false;
            }
            Factory that = (Factory)((Object)obj);
            return Objects.equals(this.encoding, that.encoding);
        }

        public int hashCode() {
            return this.encoding == null ? 0 : this.encoding.hashCode();
        }

        public abstract Content.Source newDecoderContentSource(Content.Source var1);
    }
}

