/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import org.traccar.geofence.GeofenceCircle;
import org.traccar.geofence.GeofenceGeometry;
import org.traccar.geofence.GeofencePolygon;
import org.traccar.geofence.GeofencePolyline;
import org.traccar.model.ExtendedModel;
import org.traccar.model.Position;
import org.traccar.model.Schedulable;
import org.traccar.storage.QueryIgnore;
import org.traccar.storage.StorageName;

@StorageName(value="tc_geofences")
public class Geofence
extends ExtendedModel
implements Schedulable {
    private long calendarId;
    private String name;
    private String description;
    private String area;
    private GeofenceGeometry geometry;

    @Override
    public long getCalendarId() {
        return this.calendarId;
    }

    @Override
    public void setCalendarId(long calendarId) {
        this.calendarId = calendarId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
        this.geometry = null;
    }

    @QueryIgnore
    @JsonIgnore
    public GeofenceGeometry getGeometry() {
        block6: {
            if (this.geometry == null) {
                try {
                    if (this.area.startsWith("CIRCLE")) {
                        this.geometry = new GeofenceCircle(this.area);
                        break block6;
                    }
                    if (this.area.startsWith("POLYGON")) {
                        this.geometry = new GeofencePolygon(this.area);
                        break block6;
                    }
                    if (this.area.startsWith("LINESTRING")) {
                        this.geometry = new GeofencePolyline(this.area, this.getDouble("polylineDistance", 25.0));
                        break block6;
                    }
                    throw new IllegalArgumentException("Unknown geometry type");
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.geometry;
    }

    @QueryIgnore
    @JsonIgnore
    public void setGeometry(GeofenceGeometry geometry) {
        this.setArea(geometry.toWkt());
    }

    public boolean containsPosition(Position position) {
        return this.getGeometry().containsPoint(position.getLatitude(), position.getLongitude());
    }
}

