/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptRecord;

public class ScriptList {
    private int scriptCount = 0;
    private ScriptRecord[] scriptRecords;
    private Script[] scripts;

    protected ScriptList(RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.seek(n);
        this.scriptCount = randomAccessFile.readUnsignedShort();
        this.scriptRecords = new ScriptRecord[this.scriptCount];
        this.scripts = new Script[this.scriptCount];
        int n2 = 0;
        while (n2 < this.scriptCount) {
            this.scriptRecords[n2] = new ScriptRecord(randomAccessFile);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.scriptCount) {
            this.scripts[n3] = new Script(randomAccessFile, n + this.scriptRecords[n3].getOffset());
            ++n3;
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int n) {
        return this.scriptRecords[n];
    }

    public Script findScript(String string) {
        if (string.length() != 4) {
            return null;
        }
        int n = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        int n2 = 0;
        while (n2 < this.scriptCount) {
            if (this.scriptRecords[n2].getTag() == n) {
                return this.scripts[n2];
            }
            ++n2;
        }
        return null;
    }
}

