/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.option.StringOptionUI;
import net.sf.freecol.client.gui.option.UnitTypeOptionUI;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitTypeOption;

public final class AbstractUnitOptionUI
extends OptionUI<AbstractUnitOption>
implements ItemListener {
    private final JPanel panel = new MigPanel(new MigLayout());
    private final IntegerOptionUI numberUI;
    private final UnitTypeOptionUI typeUI;
    private final StringOptionUI roleUI;
    private final boolean roleEditable;

    public AbstractUnitOptionUI(AbstractUnitOption option, boolean editable) {
        super(option, editable);
        IntegerOption numberOption = option.getNumber();
        UnitTypeOption typeOption = option.getUnitType();
        StringOption roleOption = option.getRole();
        boolean numberEditable = editable && numberOption.getMaximumValue() > numberOption.getMinimumValue();
        this.numberUI = new IntegerOptionUI(numberOption, numberEditable);
        Utility.localizeToolTip(this.numberUI.getComponent(), "number");
        this.panel.add((Component)this.numberUI.getComponent(), "width 30%");
        boolean typeEditable = editable && typeOption.getChoices().size() > 1;
        this.typeUI = new UnitTypeOptionUI(typeOption, typeEditable);
        Utility.localizeToolTip((JComponent)this.typeUI.getComponent(), "unitType");
        this.typeUI.getComponent().addItemListener(this);
        this.panel.add((Component)this.typeUI.getComponent(), "width 35%");
        this.roleEditable = editable && roleOption.getChoices().size() > 1;
        this.roleUI = new StringOptionUI(roleOption, this.roleEditable);
        Utility.localizeToolTip(this.roleUI.getComponent(), "model.role.name");
        ((JComboBox)this.roleUI.getComponent()).setRenderer(new RoleRenderer());
        this.panel.add((Component)this.roleUI.getComponent(), "width 35%");
        this.initialize();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        DefaultComboBoxModel<String> model;
        JComponent box = this.roleUI.getComponent();
        boolean enable = false;
        UnitType type = (UnitType)this.typeUI.getComponent().getSelectedItem();
        if (type != null && type.hasAbility("model.ability.canBeEquipped")) {
            Specification spec = type.getSpecification();
            NationType nt = ((AbstractUnitOption)this.getOption()).getNationType();
            int n = 0;
            model = new DefaultComboBoxModel();
            for (String ri : ((AbstractUnitOption)this.getOption()).getRole().getChoices()) {
                Role role = spec.getRole(ri);
                if (!role.isAvailableTo(type, nt)) continue;
                model.addElement(ri);
                ++n;
            }
            enable = n > 1 && this.isEditable();
        } else {
            model = new DefaultComboBoxModel<String>(new String[]{"model.role.default"});
        }
        ((JComboBox)box).setModel(model);
        ((JComboBox)box).setEnabled(enable);
    }

    @Override
    public ListCellRenderer getListCellRenderer() {
        return new AbstractUnitRenderer();
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        this.typeUI.updateOption();
        this.roleUI.updateOption();
        this.numberUI.updateOption();
        UnitType type = ((UnitTypeOption)this.typeUI.getOption()).getValue();
        String roleId = ((StringOption)this.roleUI.getOption()).getValue();
        int number = ((IntegerOption)this.numberUI.getOption()).getValue();
        ((AbstractUnitOption)this.getOption()).setValue(new AbstractUnit(type, roleId, number));
    }

    @Override
    public void reset() {
        this.typeUI.reset();
        this.roleUI.reset();
        this.numberUI.reset();
    }

    private static class RoleRenderer
    extends FreeColComboBoxRenderer<String> {
        private RoleRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, String value) {
            label.setText(value == null ? "" : Messages.getName(value));
        }
    }

    private static class AbstractUnitRenderer
    extends FreeColComboBoxRenderer<AbstractUnitOption> {
        private AbstractUnitRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, AbstractUnitOption value) {
            label.setText(Messages.message(value.getValue().getLabel()));
        }
    }
}

