/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class XPTabbedPaneUI
extends WindowsTabbedPaneUI {
    private Color color1 = new Color(252, 252, 254);
    private Color color2 = new Color(244, 243, 238);
    PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("TabbedPane.backgroundGradientStart")) {
                XPTabbedPaneUI.this.color1 = (Color)event.getNewValue();
            } else if (event.getPropertyName().equals("TabbedPane.backgroundGradientEnd")) {
                XPTabbedPaneUI.this.color2 = (Color)event.getNewValue();
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new XPTabbedPaneUI();
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.color1, 0.0f, h, this.color2, false);
        g2.setPaint(gradient);
        g2.fillRect(x, y, w, h);
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        UIManager.put("TabbedPane.opaque", Boolean.TRUE);
        UIManager.put("TabbedPane.backgroundGradientStart", this.color1);
        UIManager.put("TabbedPane.backgroundGradientEnd", this.color2);
        this.lightHighlight = this.shadow;
        this.darkShadow = new Color(Math.max(0, SystemColor.control.getRed() - 20), Math.max(0, SystemColor.control.getGreen() - 20), Math.max(0, SystemColor.control.getBlue() - 20));
        UIManager.getDefaults().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("TabbedPane.opaque", UIManager.getLookAndFeelDefaults().get("TabbedPane.opaque"));
        UIManager.getDefaults().remove("TabbedPane.backgroundGradientStart");
        UIManager.getDefaults().remove("TabbedPane.backgroundGradientEnd");
        UIManager.getDefaults().removePropertyChangeListener(this.propertyChangeListener);
    }
}

