/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.zaproxy.zap.extension.ext.ExtensionParam;
import org.zaproxy.zap.extension.ext.OptionsExtensionPanel;

public class ExtensionExtension
extends ExtensionAdaptor
implements CommandLineListener {
    public static final String NAME = "ExtensionExtension";
    private OptionsExtensionPanel optionsExceptionsPanel = null;
    private Logger logger = LogManager.getLogger(ExtensionExtension.class);

    public ExtensionExtension() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("ext.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsExtensionPanel());
        }
    }

    private OptionsExtensionPanel getOptionsExtensionPanel() {
        if (this.optionsExceptionsPanel == null) {
            this.optionsExceptionsPanel = new OptionsExtensionPanel(this);
        }
        return this.optionsExceptionsPanel;
    }

    public void enableExtension(String name, boolean enable) {
        ExtensionParam extParam = this.getModel().getOptionsParam().getExtensionParam();
        Map<String, Boolean> extensionsState = extParam.getExtensionsState();
        extensionsState.put(name, enable);
        extParam.setExtensionsState(extensionsState);
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("ext.desc");
    }

    @Override
    public void execute(CommandLineArgument[] args) {
    }

    @Override
    public boolean handleFile(File file) {
        Control.getSingleton().openSession(file, null);
        return true;
    }

    @Override
    public List<String> getHandledExtensions() {
        ArrayList<String> exts = new ArrayList<String>();
        exts.add("session");
        return exts;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

