/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.classfile;

import dotty.tools.dotc.core.classfile.DataReader;
import dotty.tools.io.AbstractFile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import scala.Predef$;
import scala.collection.ArrayOps$;

public final class AbstractFileReader
implements DataReader {
    private final byte[] buf;
    private int bp;

    public AbstractFileReader(byte[] buf) {
        this.buf = buf;
        this.bp = 0;
    }

    @Override
    public byte[] buf() {
        return this.buf;
    }

    public AbstractFileReader(AbstractFile file) {
        this(file.toByteArray());
    }

    @Override
    public int bp() {
        return this.bp;
    }

    @Override
    public void bp_$eq(int x$1) {
        this.bp = x$1;
    }

    @Override
    public byte getByte(int mybp) {
        return this.buf()[mybp];
    }

    @Override
    public void getBytes(int mybp, byte[] bytes) {
        System.arraycopy(this.buf(), mybp, bytes, 0, bytes.length);
    }

    public byte byteAt(int pos) throws IndexOutOfBoundsException {
        return this.buf()[pos];
    }

    @Override
    public byte nextByte() throws IndexOutOfBoundsException {
        byte b = this.buf()[this.bp()];
        this.bp_$eq(this.bp() + 1);
        return b;
    }

    @Override
    public byte[] nextBytes(int len) {
        this.bp_$eq(this.bp() + len);
        Object object = Predef$.MODULE$.byteArrayOps(this.buf());
        return (byte[])ArrayOps$.MODULE$.slice$extension(object, this.bp() - len, this.bp());
    }

    @Override
    public char nextChar() {
        return (char)(((this.nextByte() & 0xFF) << 8) + (this.nextByte() & 0xFF));
    }

    @Override
    public int nextInt() {
        return ((this.nextByte() & 0xFF) << 24) + ((this.nextByte() & 0xFF) << 16) + ((this.nextByte() & 0xFF) << 8) + (this.nextByte() & 0xFF);
    }

    @Override
    public char getChar(int mybp) {
        return (char)(((this.getByte(mybp) & 0xFF) << 8) + (this.getByte(mybp + 1) & 0xFF));
    }

    @Override
    public int getInt(int mybp) {
        return ((this.getByte(mybp) & 0xFF) << 24) + ((this.getByte(mybp + 1) & 0xFF) << 16) + ((this.getByte(mybp + 2) & 0xFF) << 8) + (this.getByte(mybp + 3) & 0xFF);
    }

    @Override
    public long getLong(int mybp) {
        return ((long)this.getInt(mybp) << 32) + ((long)this.getInt(mybp + 4) & 0xFFFFFFFFL);
    }

    @Override
    public float getFloat(int mybp) {
        return Float.intBitsToFloat(this.getInt(mybp));
    }

    @Override
    public double getDouble(int mybp) {
        return Double.longBitsToDouble(this.getLong(mybp));
    }

    @Override
    public String getUTF(int mybp, int len) {
        return new DataInputStream(new ByteArrayInputStream(this.buf(), mybp, len)).readUTF();
    }

    @Override
    public void skip(int n) {
        this.bp_$eq(this.bp() + n);
    }
}

