<?php

namespace {

	/**
	 * <p>This attribute is used to indicate that a method is intended to override a method of a parent class or that it implements a method defined in an interface.</p>
	 * <p>If no method with the same name exists in a parent class or in an implemented interface a compile-time error will be emitted.</p>
	 * @link https://php.net/manual/en/class.override.php
	 * @since PHP 8 >= 8.3.0
	 */
	final class Override {

		/**
		 * Construct a new Override attribute instance
		 * <p>Constructs a new <code>Override</code> instance.</p>
		 * @return self
		 * @link https://php.net/manual/en/override.construct.php
		 * @since PHP 8 >= 8.3.0
		 */
		public function __construct() {}
	}

}
