/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateBackupDestinationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vpcUsers")
    private final List<String> vpcUsers;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="localMountPointPath")
    private final String localMountPointPath;
    @JsonProperty(value="nfsMountType")
    private final NfsMountType nfsMountType;
    @JsonProperty(value="nfsServer")
    private final List<String> nfsServer;
    @JsonProperty(value="nfsServerExport")
    private final String nfsServerExport;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"vpcUsers", "connectionString", "localMountPointPath", "nfsMountType", "nfsServer", "nfsServerExport", "freeformTags", "definedTags"})
    public UpdateBackupDestinationDetails(List<String> vpcUsers, String connectionString, String localMountPointPath, NfsMountType nfsMountType, List<String> nfsServer, String nfsServerExport, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.vpcUsers = vpcUsers;
        this.connectionString = connectionString;
        this.localMountPointPath = localMountPointPath;
        this.nfsMountType = nfsMountType;
        this.nfsServer = nfsServer;
        this.nfsServerExport = nfsServerExport;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getVpcUsers() {
        return this.vpcUsers;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getLocalMountPointPath() {
        return this.localMountPointPath;
    }

    public NfsMountType getNfsMountType() {
        return this.nfsMountType;
    }

    public List<String> getNfsServer() {
        return this.nfsServer;
    }

    public String getNfsServerExport() {
        return this.nfsServerExport;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateBackupDestinationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("vpcUsers=").append(String.valueOf(this.vpcUsers));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", localMountPointPath=").append(String.valueOf(this.localMountPointPath));
        sb.append(", nfsMountType=").append(String.valueOf((Object)this.nfsMountType));
        sb.append(", nfsServer=").append(String.valueOf(this.nfsServer));
        sb.append(", nfsServerExport=").append(String.valueOf(this.nfsServerExport));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBackupDestinationDetails)) {
            return false;
        }
        UpdateBackupDestinationDetails other = (UpdateBackupDestinationDetails)((Object)o);
        return Objects.equals(this.vpcUsers, other.vpcUsers) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals(this.localMountPointPath, other.localMountPointPath) && Objects.equals((Object)this.nfsMountType, (Object)other.nfsMountType) && Objects.equals(this.nfsServer, other.nfsServer) && Objects.equals(this.nfsServerExport, other.nfsServerExport) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vpcUsers == null ? 43 : this.vpcUsers.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.localMountPointPath == null ? 43 : this.localMountPointPath.hashCode());
        result = result * 59 + (this.nfsMountType == null ? 43 : this.nfsMountType.hashCode());
        result = result * 59 + (this.nfsServer == null ? 43 : this.nfsServer.hashCode());
        result = result * 59 + (this.nfsServerExport == null ? 43 : this.nfsServerExport.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NfsMountType implements BmcEnum
    {
        SelfMount("SELF_MOUNT"),
        AutomatedMount("AUTOMATED_MOUNT");

        private final String value;
        private static Map<String, NfsMountType> map;

        private NfsMountType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NfsMountType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid NfsMountType: " + key);
        }

        static {
            map = new HashMap<String, NfsMountType>();
            for (NfsMountType v : NfsMountType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vpcUsers")
        private List<String> vpcUsers;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="localMountPointPath")
        private String localMountPointPath;
        @JsonProperty(value="nfsMountType")
        private NfsMountType nfsMountType;
        @JsonProperty(value="nfsServer")
        private List<String> nfsServer;
        @JsonProperty(value="nfsServerExport")
        private String nfsServerExport;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vpcUsers(List<String> vpcUsers) {
            this.vpcUsers = vpcUsers;
            this.__explicitlySet__.add("vpcUsers");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder localMountPointPath(String localMountPointPath) {
            this.localMountPointPath = localMountPointPath;
            this.__explicitlySet__.add("localMountPointPath");
            return this;
        }

        public Builder nfsMountType(NfsMountType nfsMountType) {
            this.nfsMountType = nfsMountType;
            this.__explicitlySet__.add("nfsMountType");
            return this;
        }

        public Builder nfsServer(List<String> nfsServer) {
            this.nfsServer = nfsServer;
            this.__explicitlySet__.add("nfsServer");
            return this;
        }

        public Builder nfsServerExport(String nfsServerExport) {
            this.nfsServerExport = nfsServerExport;
            this.__explicitlySet__.add("nfsServerExport");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateBackupDestinationDetails build() {
            UpdateBackupDestinationDetails model = new UpdateBackupDestinationDetails(this.vpcUsers, this.connectionString, this.localMountPointPath, this.nfsMountType, this.nfsServer, this.nfsServerExport, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateBackupDestinationDetails model) {
            if (model.wasPropertyExplicitlySet("vpcUsers")) {
                this.vpcUsers(model.getVpcUsers());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("localMountPointPath")) {
                this.localMountPointPath(model.getLocalMountPointPath());
            }
            if (model.wasPropertyExplicitlySet("nfsMountType")) {
                this.nfsMountType(model.getNfsMountType());
            }
            if (model.wasPropertyExplicitlySet("nfsServer")) {
                this.nfsServer(model.getNfsServer());
            }
            if (model.wasPropertyExplicitlySet("nfsServerExport")) {
                this.nfsServerExport(model.getNfsServerExport());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

