/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.ExadataDbSystemMigrationSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadataDbSystemMigration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="cloudVmClusterId")
    private final String cloudVmClusterId;
    @JsonProperty(value="cloudExadataInfrastructureId")
    private final String cloudExadataInfrastructureId;
    @JsonProperty(value="additionalMigrations")
    private final List<ExadataDbSystemMigrationSummary> additionalMigrations;

    @Deprecated
    @ConstructorProperties(value={"dbSystemId", "cloudVmClusterId", "cloudExadataInfrastructureId", "additionalMigrations"})
    public ExadataDbSystemMigration(String dbSystemId, String cloudVmClusterId, String cloudExadataInfrastructureId, List<ExadataDbSystemMigrationSummary> additionalMigrations) {
        this.dbSystemId = dbSystemId;
        this.cloudVmClusterId = cloudVmClusterId;
        this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        this.additionalMigrations = additionalMigrations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getCloudVmClusterId() {
        return this.cloudVmClusterId;
    }

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public List<ExadataDbSystemMigrationSummary> getAdditionalMigrations() {
        return this.additionalMigrations;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataDbSystemMigration(");
        sb.append("super=").append(super.toString());
        sb.append("dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", cloudVmClusterId=").append(String.valueOf(this.cloudVmClusterId));
        sb.append(", cloudExadataInfrastructureId=").append(String.valueOf(this.cloudExadataInfrastructureId));
        sb.append(", additionalMigrations=").append(String.valueOf(this.additionalMigrations));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataDbSystemMigration)) {
            return false;
        }
        ExadataDbSystemMigration other = (ExadataDbSystemMigration)((Object)o);
        return Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.cloudVmClusterId, other.cloudVmClusterId) && Objects.equals(this.cloudExadataInfrastructureId, other.cloudExadataInfrastructureId) && Objects.equals(this.additionalMigrations, other.additionalMigrations) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.cloudVmClusterId == null ? 43 : this.cloudVmClusterId.hashCode());
        result = result * 59 + (this.cloudExadataInfrastructureId == null ? 43 : this.cloudExadataInfrastructureId.hashCode());
        result = result * 59 + (this.additionalMigrations == null ? 43 : this.additionalMigrations.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="cloudVmClusterId")
        private String cloudVmClusterId;
        @JsonProperty(value="cloudExadataInfrastructureId")
        private String cloudExadataInfrastructureId;
        @JsonProperty(value="additionalMigrations")
        private List<ExadataDbSystemMigrationSummary> additionalMigrations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            this.__explicitlySet__.add("cloudVmClusterId");
            return this;
        }

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            this.__explicitlySet__.add("cloudExadataInfrastructureId");
            return this;
        }

        public Builder additionalMigrations(List<ExadataDbSystemMigrationSummary> additionalMigrations) {
            this.additionalMigrations = additionalMigrations;
            this.__explicitlySet__.add("additionalMigrations");
            return this;
        }

        public ExadataDbSystemMigration build() {
            ExadataDbSystemMigration model = new ExadataDbSystemMigration(this.dbSystemId, this.cloudVmClusterId, this.cloudExadataInfrastructureId, this.additionalMigrations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataDbSystemMigration model) {
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("cloudVmClusterId")) {
                this.cloudVmClusterId(model.getCloudVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("cloudExadataInfrastructureId")) {
                this.cloudExadataInfrastructureId(model.getCloudExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("additionalMigrations")) {
                this.additionalMigrations(model.getAdditionalMigrations());
            }
            return this;
        }
    }
}

