/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbServerPatchingDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="estimatedPatchDuration")
    private final Integer estimatedPatchDuration;
    @JsonProperty(value="patchingStatus")
    private final PatchingStatus patchingStatus;
    @JsonProperty(value="timePatchingStarted")
    private final Date timePatchingStarted;
    @JsonProperty(value="timePatchingEnded")
    private final Date timePatchingEnded;

    @Deprecated
    @ConstructorProperties(value={"estimatedPatchDuration", "patchingStatus", "timePatchingStarted", "timePatchingEnded"})
    public DbServerPatchingDetails(Integer estimatedPatchDuration, PatchingStatus patchingStatus, Date timePatchingStarted, Date timePatchingEnded) {
        this.estimatedPatchDuration = estimatedPatchDuration;
        this.patchingStatus = patchingStatus;
        this.timePatchingStarted = timePatchingStarted;
        this.timePatchingEnded = timePatchingEnded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getEstimatedPatchDuration() {
        return this.estimatedPatchDuration;
    }

    public PatchingStatus getPatchingStatus() {
        return this.patchingStatus;
    }

    public Date getTimePatchingStarted() {
        return this.timePatchingStarted;
    }

    public Date getTimePatchingEnded() {
        return this.timePatchingEnded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbServerPatchingDetails(");
        sb.append("super=").append(super.toString());
        sb.append("estimatedPatchDuration=").append(String.valueOf(this.estimatedPatchDuration));
        sb.append(", patchingStatus=").append(String.valueOf((Object)this.patchingStatus));
        sb.append(", timePatchingStarted=").append(String.valueOf(this.timePatchingStarted));
        sb.append(", timePatchingEnded=").append(String.valueOf(this.timePatchingEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbServerPatchingDetails)) {
            return false;
        }
        DbServerPatchingDetails other = (DbServerPatchingDetails)((Object)o);
        return Objects.equals(this.estimatedPatchDuration, other.estimatedPatchDuration) && Objects.equals((Object)this.patchingStatus, (Object)other.patchingStatus) && Objects.equals(this.timePatchingStarted, other.timePatchingStarted) && Objects.equals(this.timePatchingEnded, other.timePatchingEnded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.estimatedPatchDuration == null ? 43 : this.estimatedPatchDuration.hashCode());
        result = result * 59 + (this.patchingStatus == null ? 43 : this.patchingStatus.hashCode());
        result = result * 59 + (this.timePatchingStarted == null ? 43 : this.timePatchingStarted.hashCode());
        result = result * 59 + (this.timePatchingEnded == null ? 43 : this.timePatchingEnded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchingStatus implements BmcEnum
    {
        Scheduled("SCHEDULED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        Failed("FAILED"),
        Complete("COMPLETE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchingStatus> map;

        private PatchingStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchingStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchingStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchingStatus.class);
            map = new HashMap<String, PatchingStatus>();
            for (PatchingStatus v : PatchingStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="estimatedPatchDuration")
        private Integer estimatedPatchDuration;
        @JsonProperty(value="patchingStatus")
        private PatchingStatus patchingStatus;
        @JsonProperty(value="timePatchingStarted")
        private Date timePatchingStarted;
        @JsonProperty(value="timePatchingEnded")
        private Date timePatchingEnded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder estimatedPatchDuration(Integer estimatedPatchDuration) {
            this.estimatedPatchDuration = estimatedPatchDuration;
            this.__explicitlySet__.add("estimatedPatchDuration");
            return this;
        }

        public Builder patchingStatus(PatchingStatus patchingStatus) {
            this.patchingStatus = patchingStatus;
            this.__explicitlySet__.add("patchingStatus");
            return this;
        }

        public Builder timePatchingStarted(Date timePatchingStarted) {
            this.timePatchingStarted = timePatchingStarted;
            this.__explicitlySet__.add("timePatchingStarted");
            return this;
        }

        public Builder timePatchingEnded(Date timePatchingEnded) {
            this.timePatchingEnded = timePatchingEnded;
            this.__explicitlySet__.add("timePatchingEnded");
            return this;
        }

        public DbServerPatchingDetails build() {
            DbServerPatchingDetails model = new DbServerPatchingDetails(this.estimatedPatchDuration, this.patchingStatus, this.timePatchingStarted, this.timePatchingEnded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbServerPatchingDetails model) {
            if (model.wasPropertyExplicitlySet("estimatedPatchDuration")) {
                this.estimatedPatchDuration(model.getEstimatedPatchDuration());
            }
            if (model.wasPropertyExplicitlySet("patchingStatus")) {
                this.patchingStatus(model.getPatchingStatus());
            }
            if (model.wasPropertyExplicitlySet("timePatchingStarted")) {
                this.timePatchingStarted(model.getTimePatchingStarted());
            }
            if (model.wasPropertyExplicitlySet("timePatchingEnded")) {
                this.timePatchingEnded(model.getTimePatchingEnded());
            }
            return this;
        }
    }
}

