/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.problems;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.problems.PropertiesEditor;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;

public class GradlePropertiesEditor {
    private static final Logger LOG = Logger.getLogger(GradlePropertiesEditor.class.getName());
    private final Project project;
    private CachedProperties loadedProperties = new CachedProperties(Collections.emptyMap());

    public GradlePropertiesEditor(Project project) {
        this.project = project;
    }

    public FileObject getPropertyOrigin(String propName) {
        return this.ensureGetProperties().origins.get(propName);
    }

    public PropertiesEditor getEditorFor(String property) {
        FileObject fo = this.getPropertyOrigin(property);
        if (fo == null) {
            return null;
        }
        return this.getEditor(fo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesEditor getEditor(FileObject origin, GradleFiles.Kind kind) {
        PropertiesEditor ed;
        File f;
        GradleFiles gf = NbGradleProject.get(this.project).getGradleFiles();
        if (origin != null && (f = FileUtil.toFile((FileObject)origin)) != null) {
            GradlePropertiesEditor gradlePropertiesEditor = this;
            synchronized (gradlePropertiesEditor) {
                PropertiesEditor ep = this.ensureGetProperties().editables.get(f.toPath());
                if (ep != null) {
                    return ep;
                }
            }
        }
        if (kind == null) {
            return null;
        }
        f = gf.getFile(kind);
        if (f == null) {
            return null;
        }
        Map<Path, PropertiesEditor> editables = this.ensureGetProperties().editables;
        GradlePropertiesEditor gradlePropertiesEditor = this;
        synchronized (gradlePropertiesEditor) {
            ed = editables.get(f.toPath());
            if (ed != null) {
                return ed;
            }
            ed = new PropertiesEditor(f.toPath());
            editables.put(f.toPath(), ed);
        }
        return ed;
    }

    public Properties loadGradleProperties() {
        return this.loadGradleProperties0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedProperties loadGradleProperties0() {
        CachedProperties cached;
        GradleFiles gf = NbGradleProject.get(this.project).getGradleFiles();
        List<File> files = gf.getPropertyFiles();
        GradlePropertiesEditor gradlePropertiesEditor = this;
        synchronized (gradlePropertiesEditor) {
            cached = this.loadedProperties;
            if (cached.valid(files)) {
                return cached;
            }
        }
        return this.doLoadProperties(cached, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedProperties ensureGetProperties() {
        GradlePropertiesEditor gradlePropertiesEditor = this;
        synchronized (gradlePropertiesEditor) {
            if (this.loadedProperties != null) {
                return this.loadedProperties;
            }
        }
        return this.loadGradleProperties0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedProperties doLoadProperties(CachedProperties cached, List<File> files) {
        HashMap<File, Long> stamps = new HashMap<File, Long>();
        for (File f : files) {
            stamps.put(f, f.lastModified());
        }
        CachedProperties merged = new CachedProperties((Map<File, Long>)stamps);
        HashMap<Path, PropertiesEditor> propertyMap = new HashMap<Path, PropertiesEditor>();
        for (int i = files.size() - 1; i >= 0; --i) {
            File f = files.get(i);
            Path path = f.toPath();
            if (propertyMap.containsKey(path)) continue;
            FileObject fo = FileUtil.toFileObject((File)f);
            try {
                PropertiesEditor pe = fo == null ? new PropertiesEditor(path) : new PropertiesEditor(fo);
                propertyMap.put(path, pe);
                EditableProperties p = pe.open();
                for (Object k : p.keySet()) {
                    String ks = k.toString();
                    if (merged.containsKey(ks)) continue;
                    merged.put(ks, p.getProperty(ks));
                    merged.origins.put(ks, fo);
                }
                merged.editables.put(path, pe);
                continue;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Could not read properties file {0}", f);
            }
        }
        GradlePropertiesEditor gradlePropertiesEditor = this;
        synchronized (gradlePropertiesEditor) {
            if (this.loadedProperties == cached) {
                this.loadedProperties = merged;
            }
        }
        return merged;
    }

    static class CachedProperties
    extends Properties {
        private final Map<File, Long> timestamps;
        private final Map<String, FileObject> origins = new HashMap<String, FileObject>();
        private final Map<Path, PropertiesEditor> editables = new HashMap<Path, PropertiesEditor>();

        public CachedProperties(Map<File, Long> timestamps) {
            this.timestamps = timestamps;
        }

        boolean valid(Collection<File> files) {
            if (!this.timestamps.keySet().containsAll(files) || this.timestamps.size() != files.size()) {
                return false;
            }
            for (File k : files) {
                Long l = this.timestamps.get(k);
                if (l != null && l.longValue() == k.lastModified()) continue;
                return false;
            }
            return true;
        }
    }
}

