/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.bindings_v2_2.AssertionStatusItem;
import com.sun.xml.registry.uddi.bindings_v2_2.AssertionStatusReport;
import com.sun.xml.registry.uddi.bindings_v2_2.AuthToken;
import com.sun.xml.registry.uddi.bindings_v2_2.BindingDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.BindingTemplate;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessEntity;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessInfos;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessList;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessService;
import com.sun.xml.registry.uddi.bindings_v2_2.DispositionReport;
import com.sun.xml.registry.uddi.bindings_v2_2.PublisherAssertion;
import com.sun.xml.registry.uddi.bindings_v2_2.PublisherAssertions;
import com.sun.xml.registry.uddi.bindings_v2_2.RegisteredInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.RelatedBusinessInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.RelatedBusinessInfos;
import com.sun.xml.registry.uddi.bindings_v2_2.RelatedBusinessesList;
import com.sun.xml.registry.uddi.bindings_v2_2.Result;
import com.sun.xml.registry.uddi.bindings_v2_2.ServiceDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.ServiceInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.ServiceInfos;
import com.sun.xml.registry.uddi.bindings_v2_2.ServiceList;
import com.sun.xml.registry.uddi.bindings_v2_2.TModel;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelInfos;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelList;
import com.sun.xml.registry.uddi.bindings_v2_2.Truncated;
import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;

public class ResponseTransformer {
    private UDDIMapper mapper;

    public ResponseTransformer(UDDIMapper mapper) {
        this.mapper = mapper;
    }

    BulkResponse transformResponse(Object obj, Collection keys, String type) throws JAXRException {
        if ((obj = ((JAXBElement)obj).getValue()) instanceof BusinessList) {
            return this.transformResponse((BusinessList)obj, keys, type);
        }
        if (obj instanceof AuthToken) {
            return this.transformResponse((AuthToken)obj, keys, type);
        }
        if (obj instanceof AssertionStatusReport) {
            return this.transformResponse((AssertionStatusReport)obj, keys, type);
        }
        if (obj instanceof RelatedBusinessesList) {
            return this.transformResponse((RelatedBusinessesList)obj, keys, type);
        }
        if (obj instanceof ServiceList) {
            return this.transformResponse((ServiceList)obj, keys, type);
        }
        if (obj instanceof TModelList) {
            return this.transformResponse((TModelList)obj, keys, type);
        }
        if (obj instanceof BusinessDetail) {
            return this.transformResponse((BusinessDetail)obj, keys, type);
        }
        if (obj instanceof ServiceDetail) {
            return this.transformResponse((ServiceDetail)obj, keys, type);
        }
        if (obj instanceof BindingDetail) {
            return this.transformResponse((BindingDetail)obj, keys, type);
        }
        if (obj instanceof TModelDetail) {
            return this.transformResponse((TModelDetail)obj, keys, type);
        }
        if (obj instanceof RegisteredInfo) {
            return this.transformResponse((RegisteredInfo)obj, keys, type);
        }
        if (obj instanceof DispositionReport) {
            return this.transformResponse((DispositionReport)obj, keys, type);
        }
        if (obj instanceof PublisherAssertions) {
            return this.transformResponse((PublisherAssertions)obj, keys, type);
        }
        return null;
    }

    BulkResponse transformResponse(AuthToken token, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bulkResponse = new BulkResponseImpl();
        ArrayList<String> tokens = new ArrayList<String>();
        String authInfo = token.getAuthInfo();
        tokens.add(authInfo);
        bulkResponse.setCollection(tokens);
        return bulkResponse;
    }

    BulkResponse transformResponse(BusinessList list, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (list != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Organization> fbResponse = new ArrayList<Organization>();
            BusinessInfos infos = list.getBusinessInfos();
            Organization org = null;
            if (infos != null) {
                List<BusinessInfo> binfos = infos.getBusinessInfo();
                Iterator iter = binfos.iterator();
                while (iter.hasNext()) {
                    org = this.mapper.businessInfo2Organization((BusinessInfo)iter.next());
                    fbResponse.add(org);
                }
            }
            bResponse.setCollection(fbResponse);
        }
        return bResponse;
    }

    BulkResponse transformResponse(AssertionStatusReport report, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = new BulkResponseImpl();
        if (report != null) {
            String generic = report.getGeneric();
            String operator = report.getOperator();
            List<AssertionStatusItem> assertionStatusItems = report.getAssertionStatusItem();
            Collection associations = this.mapper.assertionStatusItems2Associations(assertionStatusItems);
            if (associations != null) {
                bResponse.setCollection(associations);
            }
        }
        return bResponse;
    }

    BulkResponse transformResponse(RelatedBusinessesList list, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        ArrayList fbResponse = new ArrayList();
        if (list != null) {
            bResponse = new BulkResponseImpl();
            RelatedBusinessInfos infos = list.getRelatedBusinessInfos();
            Collection associations = null;
            List<RelatedBusinessInfo> rinfos = infos.getRelatedBusinessInfo();
            Iterator iter = rinfos.iterator();
            while (iter.hasNext()) {
                associations = this.mapper.relatedBusinessInfo2Associations((RelatedBusinessInfo)iter.next(), keys);
                if (associations == null) continue;
                fbResponse.addAll(associations);
            }
            bResponse.setCollection(fbResponse);
        }
        return bResponse;
    }

    BulkResponse transformResponse(ServiceList list, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (list != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Service> fServiceResponse = new ArrayList<Service>();
            ServiceInfos infos = list.getServiceInfos();
            List<ServiceInfo> sinfos = infos.getServiceInfo();
            Iterator iter = sinfos.iterator();
            Service service = null;
            while (iter.hasNext()) {
                service = this.mapper.serviceInfo2Service((ServiceInfo)iter.next());
                fServiceResponse.add(service);
            }
            bResponse.setCollection(fServiceResponse);
        }
        return bResponse;
    }

    BulkResponse transformResponse(TModelList list, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = new BulkResponseImpl();
        if (list != null) {
            BulkResponse response;
            bResponse = new BulkResponseImpl();
            ArrayList fTModelResponse = new ArrayList();
            TModelInfos infos = list.getTModelInfos();
            Object concept = null;
            ArrayList<KeyImpl> tkeys = new ArrayList<KeyImpl>();
            List<TModelInfo> tinfos = infos.getTModelInfo();
            Iterator iter = tinfos.iterator();
            while (iter.hasNext()) {
                String id = ((TModelInfo)iter.next()).getTModelKey();
                KeyImpl key = new KeyImpl(id);
                tkeys.add(key);
            }
            ArrayList<RegistryObject> schemes = new ArrayList<RegistryObject>();
            if (tkeys.size() > 0 && (response = this.mapper.getConcepts(tkeys)).getExceptions() == null) {
                Collection rokeys = response.getCollection();
                for (RegistryObject ro : rokeys) {
                    schemes.add(ro);
                }
            }
            bResponse.setCollection(schemes);
        }
        return bResponse;
    }

    BulkResponse transformResponse(BusinessDetail detail, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (detail != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Object> fbResponse = new ArrayList<Object>();
            List<BusinessEntity> entities = detail.getBusinessEntity();
            if (entities != null) {
                Iterator iter = entities.iterator();
                while (iter.hasNext()) {
                    Organization org = this.mapper.businessEntity2Organization((BusinessEntity)iter.next());
                    if (type.equalsIgnoreCase("find")) {
                        fbResponse.add(org);
                        continue;
                    }
                    fbResponse.add(org.getKey());
                }
                bResponse.setCollection(fbResponse);
            }
        }
        return bResponse;
    }

    BulkResponse transformResponse(ServiceDetail detail, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (detail != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Object> fbResponse = new ArrayList<Object>();
            List<BusinessService> services = detail.getBusinessService();
            if (services != null) {
                Iterator iter = services.iterator();
                while (iter.hasNext()) {
                    Service service = this.mapper.businessService2Service((BusinessService)iter.next());
                    if (type.equals("find")) {
                        fbResponse.add(service);
                        continue;
                    }
                    fbResponse.add(service.getKey());
                }
                bResponse.setCollection(fbResponse);
            }
        }
        return bResponse;
    }

    BulkResponse transformResponse(BindingDetail detail, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (detail != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Object> fbResponse = new ArrayList<Object>();
            List<BindingTemplate> templates = detail.getBindingTemplate();
            Iterator iter = templates.iterator();
            while (iter.hasNext()) {
                ServiceBinding binding = this.mapper.bindingTemplate2ServiceBinding((BindingTemplate)iter.next());
                if (type.equals("find")) {
                    fbResponse.add(binding);
                    continue;
                }
                fbResponse.add(binding.getKey());
            }
            bResponse.setCollection(fbResponse);
        }
        return bResponse;
    }

    BulkResponse transformResponse(TModelDetail detail, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (detail != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Object> fbResponse = new ArrayList<Object>();
            List<TModel> tModels = detail.getTModel();
            Iterator iter = tModels.iterator();
            while (iter.hasNext()) {
                RegistryObject registryObject = this.mapper.tModel2ConceptOrClassificationScheme((TModel)iter.next());
                if (type.equals("find")) {
                    fbResponse.add(registryObject);
                    continue;
                }
                fbResponse.add(registryObject.getKey());
            }
            bResponse.setCollection(fbResponse);
        }
        return bResponse;
    }

    BulkResponse transformResponse(RegisteredInfo info, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (info != null) {
            bResponse = new BulkResponseImpl();
            ArrayList<Object> fbResponse = new ArrayList<Object>();
            BusinessInfos infos = info.getBusinessInfos();
            List<BusinessInfo> binfos = infos.getBusinessInfo();
            Organization org = null;
            Iterator iter = binfos.iterator();
            while (iter.hasNext()) {
                org = this.mapper.businessInfo2Organization((BusinessInfo)iter.next());
                fbResponse.add(org);
            }
            TModelInfos tminfos = info.getTModelInfos();
            List<TModelInfo> tinfos = tminfos.getTModelInfo();
            ConceptImpl concept = null;
            Iterator titer = tinfos.iterator();
            while (titer.hasNext()) {
                concept = (ConceptImpl)this.mapper.tModel2Concept((TModelInfo)titer.next());
                fbResponse.add(concept);
            }
            bResponse.setCollection(fbResponse);
        }
        return bResponse;
    }

    BulkResponse transformResponse(DispositionReport report, Collection keys, String type) throws JAXRException {
        BulkResponse bResponse = null;
        if (report != null) {
            String generic = report.getGeneric();
            String operator = report.getOperator();
            Truncated truncated = report.getTruncated();
            List<Result> results = report.getResult();
            bResponse = this.mapper.results2BulkResponse(results, keys, type);
        }
        return bResponse;
    }

    BulkResponse transformResponse(PublisherAssertions assertions, Collection keys, String type) throws JAXRException {
        BulkResponseImpl bResponse = null;
        if (assertions != null) {
            bResponse = new BulkResponseImpl();
            String generic = assertions.getGeneric();
            String operator = assertions.getOperator();
            String authorizedName = assertions.getAuthorizedName();
            List<PublisherAssertion> publisherAssertions = assertions.getPublisherAssertion();
            Collection associations = this.mapper.publisherAssertions2Associations(publisherAssertions);
            if (type.equalsIgnoreCase("save")) {
                bResponse.setCollection(keys);
            } else {
                bResponse.setCollection(associations);
            }
        }
        return bResponse;
    }
}

