/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CaptureScanner
extends TreeScanner {
    private final JCTree tree;
    private final Set<Symbol.VarSymbol> seenVars = new HashSet<Symbol.VarSymbol>();
    private final LinkedHashSet<Symbol.VarSymbol> fvs = new LinkedHashSet();

    public CaptureScanner(JCTree ownerTree) {
        this.tree = ownerTree;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Symbol.VarSymbol vsym;
        Symbol sym = tree.sym;
        if (sym.kind == Kinds.Kind.VAR && sym.owner.kind == Kinds.Kind.MTH && (vsym = (Symbol.VarSymbol)sym).getConstValue() == null && !this.seenVars.contains(vsym)) {
            this.addFreeVar(vsym);
        }
    }

    protected void addFreeVar(Symbol.VarSymbol v) {
        this.fvs.add(v);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        if (tree.sym.owner.kind == Kinds.Kind.MTH) {
            this.seenVars.add(tree.sym);
        }
        super.visitVarDef(tree);
    }

    List<Symbol.VarSymbol> analyzeCaptures() {
        this.scan(this.tree);
        return List.from(this.fvs);
    }
}

