/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.mx.project.Compliance;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

final class Jdks {
    private final SuiteProject prj;

    Jdks(SuiteProject prj) {
        this.prj = prj;
    }

    final JavaPlatform find(Compliance compliance) {
        for (File f : this.jdks()) {
            Compliance platformVersion;
            SpecificationVersion version;
            Specification spec;
            FileObject fo = FileUtil.toFileObject((File)f);
            if (fo == null) continue;
            JavaPlatform platform = ProjectPlatform.forProject((Project)this.prj, (FileObject)fo, (String)fo.getName(), (String)"j2se");
            if (platform == null) {
                if (fo.getName().equals("jre")) {
                    fo = fo.getParent();
                    platform = ProjectPlatform.forProject((Project)this.prj, (FileObject)fo, (String)fo.getName(), (String)"j2se");
                }
                if (platform == null) continue;
            }
            if ((spec = platform.getSpecification()) == null || (version = spec.getVersion()) == null || !compliance.matches(platformVersion = Compliance.parse(version.toString()))) continue;
            return platform;
        }
        return null;
    }

    final Iterable<File> jdks() {
        String javaHomeProp;
        LinkedHashSet<File> jdks = new LinkedHashSet<File>();
        this.findJdksInEnv(jdks, this.prj.getGlobalEnv());
        this.findJdksInEnv(jdks, this.prj.getSuiteEnv());
        String javaHomeEnv = System.getenv("JAVA_HOME");
        if (javaHomeEnv != null) {
            jdks.add(new File(javaHomeEnv));
        }
        if ((javaHomeProp = System.getProperty("java.home")) != null) {
            jdks.add(new File(javaHomeProp));
        }
        return jdks;
    }

    private void findJdksInEnv(Set<File> jdks, FileObject env) {
        if (env == null || !env.isValid()) {
            return;
        }
        try (InputStream is = env.getInputStream();){
            String extraJavaHomes;
            Properties p = new Properties();
            p.load(is);
            String javaHome = p.getProperty("JAVA_HOME");
            if (javaHome != null) {
                jdks.add(new File(javaHome));
            }
            if ((extraJavaHomes = p.getProperty("EXTRA_JAVA_HOMES")) != null) {
                for (String extraHome : extraJavaHomes.split(File.pathSeparator)) {
                    jdks.add(new File(extraHome));
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

