/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.node.DDLHelper;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IndexNode
extends BaseNode {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/index.gif";
    private static final String FOLDER = "Index";
    private String name = "";
    private final MetadataElementHandle<Index> indexHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static IndexNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        IndexNode node = new IndexNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private IndexNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.indexHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Index index = (Index)IndexNode.this.indexHandle.resolve(metaData);
                        if (index.getName() != null) {
                            IndexNode.this.name = index.getName();
                        }
                        IndexNode.this.updateProperties(index);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Index index) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        this.addProperty("UniqueNoMnemonic", "UniqueDescription", Boolean.class, false, index.isUnique());
    }

    public String getCatalogName() {
        return IndexNode.getCatalogName(this.connection, this.indexHandle);
    }

    public String getSchemaName() {
        return IndexNode.getSchemaName(this.connection, this.indexHandle);
    }

    public String getTableName() {
        return IndexNode.getTableName(this.connection, this.indexHandle);
    }

    public String getShortDescription() {
        return NbBundle.getMessage(IndexNode.class, (String)"ND_Index");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IndexNode.class);
    }

    @Override
    public void destroy() {
        DatabaseConnector connector = this.connection.getConnector();
        String tablename = this.getTableName();
        String schemaName = this.getSchemaName();
        String catalogName = this.getCatalogName();
        if (schemaName == null) {
            schemaName = catalogName;
        }
        try {
            Specification spec = connector.getDatabaseSpecification();
            DDLHelper.deleteIndex(spec, schemaName, tablename, this.getName());
            this.setValue("BaseFilterNode.refreshAncestorDistance", 2);
        }
        catch (DDLException e) {
            Logger.getLogger(IndexNode.class.getName()).log(Level.INFO, e + " while deleting index " + this.getName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector connector = this.connection.getConnector();
        return connector.supportsCommand("DropIndexCommand");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public static String getTableName(DatabaseConnection connection, final MetadataElementHandle<Index> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[]{null};
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Index index = (Index)handle.resolve(metaData);
                    if (index != null) {
                        array[0] = index.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            // empty catch block
        }
        return array[0];
    }

    public static String getSchemaName(DatabaseConnection connection, final MetadataElementHandle<Index> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Index index = (Index)handle.resolve(metaData);
                    if (index != null) {
                        array[0] = index.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            // empty catch block
        }
        return array[0];
    }

    public static String getCatalogName(DatabaseConnection connection, final MetadataElementHandle<Index> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Index index = (Index)handle.resolve(metaData);
                    if (index != null) {
                        array[0] = index.getParent().getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            // empty catch block
        }
        return array[0];
    }
}

