/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.web.common.api.LexerUtils;

public class PropertyUtils {
    private static final Comparator<PropertyDeclaration> DECLARATIONS_COMPARATOR = new DeclarationsComparator();
    private static final Comparator<PropertyDefinition> PROPERTY_DEFINITIONS_COMPARATOR = new Comparator<PropertyDefinition>(){

        @Override
        public int compare(PropertyDefinition pd1, PropertyDefinition pd2) {
            String pd1name = pd1.getName();
            String pd2name = pd2.getName();
            boolean d1vendor = Properties.isVendorSpecificPropertyName((String)pd1name);
            boolean d2vendor = Properties.isVendorSpecificPropertyName((String)pd2name);
            if (d1vendor && !d2vendor) {
                return 1;
            }
            if (!d1vendor && d2vendor) {
                return -1;
            }
            return pd1name.compareTo(pd2name);
        }
    };

    public static List<PropertyDeclaration> getPropertyDeclarations(Rule rule) {
        ArrayList<PropertyDeclaration> pds = new ArrayList<PropertyDeclaration>();
        Declarations declarations = rule.getDeclarations();
        if (declarations == null) {
            return Collections.emptyList();
        }
        for (Declaration d : declarations.getDeclarations()) {
            PropertyDeclaration propertyDeclaration = d.getPropertyDeclaration();
            if (propertyDeclaration == null) continue;
            pds.add(propertyDeclaration);
        }
        return pds;
    }

    public static String getDeclarationId(Rule rule, PropertyDeclaration declaration) {
        assert (rule.getModel() == declaration.getModel()) : String.format("The 'rule' and 'declaration' arguments are not elements of the same model instance! %s.getModel()=%s, %s.getModel()=%s", rule, rule.getModel(), declaration, declaration.getModel());
        CharSequence searched = declaration.getProperty().getContent();
        List<PropertyDeclaration> declarations = PropertyUtils.getPropertyDeclarations(rule);
        int identityIndex = -1;
        int index = -1;
        for (PropertyDeclaration d : declarations) {
            ++index;
            CharSequence propName = d.getProperty().getContent();
            if (LexerUtils.equals((CharSequence)searched, (CharSequence)propName, (boolean)false, (boolean)false)) {
                ++identityIndex;
            }
            if (d != declaration) continue;
            break;
        }
        assert (identityIndex >= 0);
        StringBuilder b = new StringBuilder();
        b.append(searched);
        b.append('_');
        b.append(index);
        if (identityIndex > 0) {
            b.append('_');
            b.append(identityIndex);
        }
        return b.toString();
    }

    static Comparator<PropertyDefinition> getPropertyDefinitionsComparator() {
        return PROPERTY_DEFINITIONS_COMPARATOR;
    }

    static Comparator<PropertyDeclaration> getDeclarationsComparator() {
        return DECLARATIONS_COMPARATOR;
    }

    static Comparator<PropertyDeclaration> createDeclarationsComparator(Rule rule, List<String> extraDeclarationsIds) {
        return new ExtDeclarationsComparator(rule, extraDeclarationsIds);
    }

    private static class ExtDeclarationsComparator
    extends DeclarationsComparator {
        private Rule rule;
        private List<String> extraDeclarationsIds;

        public ExtDeclarationsComparator(Rule rule, List<String> extraDeclarationsIds) {
            this.rule = rule;
            this.extraDeclarationsIds = extraDeclarationsIds;
        }

        @Override
        public int compare(PropertyDeclaration d1, PropertyDeclaration d2) {
            String d1Id = PropertyUtils.getDeclarationId(this.rule, d1);
            String d2Id = PropertyUtils.getDeclarationId(this.rule, d2);
            boolean d1Extra = this.extraDeclarationsIds.contains(d1Id);
            boolean d2Extra = this.extraDeclarationsIds.contains(d2Id);
            if (d1Extra && !d2Extra) {
                return 1;
            }
            if (!d1Extra && d2Extra) {
                return -1;
            }
            if (d1Extra && d2Extra) {
                int d1Index = this.extraDeclarationsIds.indexOf(d1Id);
                int d2Index = this.extraDeclarationsIds.indexOf(d2Id);
                return d1Index - d2Index;
            }
            return super.compare(d1, d2);
        }
    }

    private static class DeclarationsComparator
    implements Comparator<PropertyDeclaration> {
        private DeclarationsComparator() {
        }

        @Override
        public int compare(PropertyDeclaration d1, PropertyDeclaration d2) {
            String d1Name = d1.getProperty().getContent().toString();
            String d2Name = d2.getProperty().getContent().toString();
            boolean d1vendor = Properties.isVendorSpecificPropertyName((String)d1Name);
            boolean d2vendor = Properties.isVendorSpecificPropertyName((String)d2Name);
            if (d1vendor && !d2vendor) {
                return 1;
            }
            if (!d1vendor && d2vendor) {
                return -1;
            }
            return d1Name.compareTo(d2Name);
        }
    }
}

