/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ant;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class JPDAStart
extends Task
implements Runnable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.ant");
    private static final String URL_EMBEDDING = String.format("!%c", Character.valueOf(File.separatorChar));
    private static final String SOCKET_TRANSPORT = "dt_socket";
    private static final String SHMEM_TRANSPORT = "dt_shmem";
    private static final String SOCKET_CONNECTOR = "com.sun.jdi.SocketListen";
    private static final String SHMEM_CONNECTOR = "com.sun.jdi.SharedMemoryListen";
    private static final String MODULE_INFO_CLZ = "module-info.class";
    private static final Set<? extends String> MODULE_FILES;
    private String addressProperty;
    private String transport = "dt_socket";
    private String connector;
    private String name;
    private Sourcepath sourcepath = null;
    private Path plainSourcepath = null;
    private boolean isSourcePathExclusive;
    private Path classpath = null;
    private Path bootclasspath = null;
    private Path modulepath = null;
    private final Object[] lock = new Object[2];
    private String stopClassName = null;
    private String listeningCP = null;
    private boolean useLoopBackAddress = true;
    private RequestProcessor rp = new RequestProcessor("JPDAStart", 5);

    public void setAddressProperty(String propertyName) {
        this.addressProperty = propertyName;
    }

    private String getAddressProperty() {
        return this.addressProperty;
    }

    public void setTransport(String transport) {
        logger.log(Level.FINE, "Set transport: ''{0}''", transport);
        this.transport = transport;
    }

    private String getTransport() {
        return this.transport;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public String getConnector() {
        return this.connector;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String getName() {
        return this.name;
    }

    public void setStopClassName(String stopClassName) {
        this.stopClassName = stopClassName;
    }

    private String getStopClassName() {
        return this.stopClassName;
    }

    public void setListeningcp(String listeningCP) {
        this.listeningCP = listeningCP;
    }

    public void setUseLoopBackAddress(String useLoopBackAddress) {
        this.useLoopBackAddress = Boolean.parseBoolean(useLoopBackAddress);
        logger.log(Level.FINE, "setUseLoopBackAddress = ''{0}'' => {1}", new Object[]{useLoopBackAddress, this.useLoopBackAddress});
    }

    public void addClasspath(Path path) {
        logger.log(Level.FINE, "addClasspath({0})", path);
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void addBootclasspath(Path path) {
        logger.log(Level.FINE, "addBootclasspath({0})", path);
        if (this.bootclasspath != null) {
            throw new BuildException("Only one bootclasspath subelement is supported");
        }
        this.bootclasspath = path;
    }

    public void addModulepath(Path path) {
        logger.log(Level.FINE, "addModlepath({0})", path);
        if (this.modulepath != null) {
            throw new BuildException("Only one modulepath subelement is supported");
        }
        this.modulepath = path;
    }

    public void addSourcepath(Sourcepath path) {
        logger.log(Level.FINE, "addSourcepath({0})", (Object)path);
        if (this.sourcepath != null) {
            throw new BuildException("Only one sourcepath subelement is supported");
        }
        this.sourcepath = path;
    }

    static void verifyPaths(org.apache.tools.ant.Project project, Path path) {
        if (path == null) {
            return;
        }
        String[] paths = path.list();
        for (int i = 0; i < paths.length; ++i) {
            String pathName = project.replaceProperties(paths[i]);
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (file.exists()) continue;
            project.log("Non-existing path \"" + pathName + "\" provided.", 1);
        }
    }

    private static ListeningConnector findConnector(String name, Collection<ListeningConnector> connectors) {
        assert (name != null);
        for (ListeningConnector c : connectors) {
            if (!name.equals(c.name())) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        JPDAStart.verifyPaths(this.getProject(), this.classpath);
        JPDAStart.verifyPaths(this.getProject(), this.modulepath);
        if (this.sourcepath != null) {
            this.isSourcePathExclusive = this.sourcepath.isExclusive();
            this.plainSourcepath = this.sourcepath.getPlainPath();
        }
        JPDAStart.verifyPaths(this.getProject(), this.plainSourcepath);
        try {
            logger.fine("JPDAStart.execute()");
            JPDAStart.debug("Execute started");
            if (this.name == null) {
                throw new BuildException("name attribute must specify name of this debugging session", this.getLocation());
            }
            if (this.addressProperty == null) {
                throw new BuildException("addressproperty attribute must specify name of property to which address will be set", this.getLocation());
            }
            if (this.transport == null) {
                this.transport = SOCKET_TRANSPORT;
            }
            JPDAStart.debug("Entering synch lock");
            this.lock[1] = null;
            this.lock[0] = null;
            Object[] objectArray = this.lock;
            synchronized (this.lock) {
                JPDAStart.debug("Entered synch lock");
                this.rp.post((Runnable)this);
                try {
                    JPDAStart.debug("Entering wait");
                    this.lock.wait();
                    JPDAStart.debug("Wait finished");
                    if (this.lock[1] != null) {
                        if (this.lock[1] instanceof DebuggerStartException) {
                            throw new BuildException(((DebuggerStartException)((Object)this.lock[1])).getLocalizedMessage());
                        }
                        if (this.lock[1] instanceof ThreadDeath) {
                            throw (ThreadDeath)this.lock[1];
                        }
                        throw new BuildException((Throwable)this.lock[1]);
                    }
                }
                catch (InterruptedException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.fine("JPDAStart.run()");
        JPDAStart.debug("Entering synch lock");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            JPDAStart.debug("Entered synch lock");
            try {
                ListeningConnector lc = null;
                HashSet<ListeningConnector> connectors = new HashSet<ListeningConnector>();
                Lookup.Result r = Lookup.getDefault().lookupResult(Connector.class);
                for (Connector connector : r.allInstances()) {
                    if (!(connector instanceof ListeningConnector)) continue;
                    connectors.add((ListeningConnector)connector);
                }
                connectors.addAll(Bootstrap.virtualMachineManager().listeningConnectors());
                if (this.connector != null) {
                    logger.log(Level.FINE, "Looking for connector {0}", this.connector);
                    lc = JPDAStart.findConnector(this.connector, connectors);
                }
                if (lc == null) {
                    if (this.transport.equals(SOCKET_TRANSPORT)) {
                        logger.log(Level.FINE, "Looking for default connector {0}", SOCKET_CONNECTOR);
                        lc = JPDAStart.findConnector(SOCKET_CONNECTOR, connectors);
                    } else if (this.transport.equals(SHMEM_TRANSPORT)) {
                        logger.log(Level.FINE, "Looking for default connector {0}", SHMEM_CONNECTOR);
                        lc = JPDAStart.findConnector(SHMEM_CONNECTOR, connectors);
                    }
                }
                if (lc == null) {
                    logger.log(Level.FINE, "Fall back, looking for a connector with transport {0}", this.transport);
                    for (ListeningConnector listeningConnector : connectors) {
                        Transport t = listeningConnector.transport();
                        if (t == null || !t.name().equals(this.transport)) continue;
                        lc = listeningConnector;
                        break;
                    }
                }
                if (lc == null) {
                    throw new BuildException("No transports named " + this.transport + " found!");
                }
                logger.log(Level.FINE, "Listening using connector {0}, transport {1}", new Object[]{lc.name(), lc.transport().name()});
                final Map<String, Connector.Argument> args = lc.defaultArguments();
                Connector.StringArgument stringArgument = (Connector.StringArgument)args.get("localAddress");
                if (stringArgument != null) {
                    String host = null;
                    if (!this.useLoopBackAddress) {
                        try {
                            host = InetAddress.getLocalHost().getCanonicalHostName();
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                    }
                    if (host == null) {
                        host = "127.0.0.1";
                    }
                    stringArgument.setValue(host);
                }
                logger.log(Level.FINE, "Assigned host = ''{0}''", stringArgument);
                String address = null;
                try {
                    address = lc.startListening(args);
                }
                catch (IOException ioex) {
                    boolean passed = false;
                    if (SHMEM_TRANSPORT.equals(this.transport)) {
                        Connector.StringArgument argName = (Connector.StringArgument)args.get("name");
                        for (int x = 0; x < 5; ++x) {
                            String tryAddress = "javadebug" + Math.round(Math.random() * 10000.0);
                            try {
                                argName.setValue(tryAddress);
                                address = lc.startListening(args);
                                passed = true;
                                break;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                    }
                    if (!passed) {
                        this.getProject().log("Listening failed with arguments: " + args);
                        throw ioex;
                    }
                }
                catch (IllegalConnectorArgumentsException iaex) {
                    this.getProject().log("Listening failed with arguments: " + args);
                    throw iaex;
                }
                if (SOCKET_TRANSPORT.equals(this.transport)) {
                    try {
                        int port = Integer.parseInt(address.substring(address.indexOf(58) + 1));
                        Connector.IntegerArgument portArg = (Connector.IntegerArgument)args.get("port");
                        portArg.setValue(port);
                        String host = address.substring(0, address.indexOf(58));
                        logger.log(Level.FINE, "  socket listening at {0}, host = {1}, port = {2}", new Object[]{address, host, port});
                        try {
                            InetAddress.getByName(host);
                        }
                        catch (UnknownHostException uhex) {
                            logger.log(Level.FINE, "unknown host ''{0}''", host);
                            address = "localhost:" + port;
                        }
                        catch (SecurityException uhex) {}
                    }
                    catch (Exception port) {
                        // empty catch block
                    }
                }
                if (SHMEM_TRANSPORT.equals(this.transport)) {
                    try {
                        Connector.StringArgument name = (Connector.StringArgument)args.get("name");
                        name.setValue(address);
                    }
                    catch (Exception name) {
                        // empty catch block
                    }
                }
                this.getProject().setNewProperty(this.getAddressProperty(), address);
                JPDAStart.debug("Creating source path");
                ClassPath sourcePath = JPDAStart.createSourcePath(this.getProject(), this.modulepath, this.classpath, this.plainSourcepath, this.isSourcePathExclusive);
                ClassPath jdkSourcePath = JPDAStart.createJDKSourcePath(this.getProject(), this.bootclasspath);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Create sourcepath:");
                    logger.log(Level.FINE, "    modulepath : {0}", this.modulepath);
                    logger.log(Level.FINE, "    classpath : {0}", this.classpath);
                    logger.log(Level.FINE, "    sourcepath : {0}", this.plainSourcepath);
                    logger.log(Level.FINE, "    bootclasspath : {0}", this.bootclasspath);
                    logger.log(Level.FINE, "    >> sourcePath : {0}", sourcePath);
                    logger.log(Level.FINE, "    >> jdkSourcePath : {0}", jdkSourcePath);
                }
                MethodBreakpoint first = null;
                if (this.stopClassName != null && this.stopClassName.length() > 0) {
                    logger.log(Level.FINE, "create method breakpoint, class name = {0}", this.stopClassName);
                    first = this.createBreakpoint(this.stopClassName);
                }
                JPDAStart.debug("Debugger started");
                logger.log(Level.FINE, "start listening at {0}", address);
                final HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("sourcepath", sourcePath);
                properties.put("name", this.getName());
                properties.put("jdksources", jdkSourcePath);
                properties.put("listeningCP", this.listeningCP);
                String workDir = this.getProject().getProperty("work.dir");
                final File baseDir = workDir != null ? new File(workDir) : this.getProject().getBaseDir();
                properties.put("baseDir", baseDir);
                logger.log(Level.FINE, "JPDAStart: properties = {0}", properties);
                final ListeningConnector flc = lc;
                final WeakReference[] startedSessionRef = new WeakReference[]{new WeakReference<Object>(null)};
                HashMap listeners = new HashMap();
                LinkedList<ExceptionBreakpoint> artificialBreakpoints = new LinkedList<ExceptionBreakpoint>();
                if (this.listeningCP != null) {
                    ExceptionBreakpoint b = this.createCompilationErrorBreakpoint();
                    DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)b);
                    artificialBreakpoints.add(b);
                }
                DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)new Listener((Breakpoint)first, artificialBreakpoints, listeners, startedSessionRef, this.rp));
                final Thread[] listeningThreadPtr = new Thread[]{null};
                final boolean[] listeningStarted = new boolean[]{false};
                this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean[] blArray = listeningStarted;
                        synchronized (listeningStarted) {
                            listeningThreadPtr[0] = Thread.currentThread();
                            listeningStarted[0] = true;
                            listeningStarted.notifyAll();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            Object[] services = null;
                            try {
                                Project prj;
                                FileObject prjRoot = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)baseDir));
                                if (prjRoot != null && (prj = ProjectManager.getDefault().findProject(prjRoot)) != null) {
                                    services = new Object[]{properties, prj};
                                }
                            }
                            catch (IOException prjRoot) {
                                // empty catch block
                            }
                            if (services == null) {
                                services = new Object[]{properties};
                            }
                            try {
                                DebuggerEngine[] engines = JPDADebugger.startListeningAndGetEngines((ListeningConnector)flc, (Map)args, services);
                                startedSessionRef[0] = new WeakReference<Object>(engines[0].lookupFirst(null, Session.class));
                            }
                            catch (DebuggerStartException debuggerStartException) {
                                boolean[] blArray2 = listeningStarted;
                                synchronized (listeningStarted) {
                                    listeningThreadPtr[0] = null;
                                    listeningStarted.notifyAll();
                                    // ** MonitorExit[var2_6] (shouldn't be in output)
                                }
                            }
                            finally {
                                boolean[] blArray3 = listeningStarted;
                                synchronized (listeningStarted) {
                                    listeningThreadPtr[0] = null;
                                    listeningStarted.notifyAll();
                                    // ** MonitorExit[var2_3] (shouldn't be in output)
                                }
                            }
                            {
                                return;
                            }
                        }
                    }
                });
                logger.log(Level.FINE, "adding a BuildListener to project {0} in {1}", new Object[]{this.getProject().getName(), this.getProject().getBaseDir()});
                this.getProject().addBuildListener(new BuildListener(){

                    public void messageLogged(BuildEvent event) {
                    }

                    public void taskStarted(BuildEvent event) {
                    }

                    public void taskFinished(BuildEvent event) {
                    }

                    public void targetStarted(BuildEvent event) {
                    }

                    public void targetFinished(BuildEvent event) {
                    }

                    public void buildStarted(BuildEvent event) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    public void buildFinished(BuildEvent event) {
                        logger.fine("buildFinished: waiting for listening start...");
                        boolean[] blArray = listeningStarted;
                        // MONITORENTER : listeningStarted
                        if (!listeningStarted[0]) {
                            try {
                                listeningStarted.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        // MONITOREXIT : blArray
                        logger.fine("buildFinished: stopping listening...");
                        try {
                            flc.stopListening(args);
                        }
                        catch (IOException iOException) {
                        }
                        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                            // empty catch block
                        }
                        logger.fine("buildFinished: interrupting listening thread...");
                        for (int i = 0; i < 10; ++i) {
                            boolean[] blArray2 = listeningStarted;
                            // MONITORENTER : listeningStarted
                            logger.log(Level.FINE, "buildFinished: listening thread = {0}", listeningThreadPtr[0]);
                            if (listeningThreadPtr[0] != null) {
                                listeningThreadPtr[0].interrupt();
                                try {
                                    listeningStarted.wait(500L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            // MONITOREXIT : blArray2
                            break;
                        }
                        Session s = (Session)startedSessionRef[0].get();
                        logger.log(Level.FINE, "buildFinished: killing session {0}", s);
                        if (s == null) return;
                        s.kill();
                    }
                });
            }
            catch (IOException ioex) {
                this.lock[1] = ioex;
            }
            catch (IllegalConnectorArgumentsException icaex) {
                this.lock[1] = icaex;
            }
            catch (ThreadDeath td) {
                this.lock[1] = td;
            }
            finally {
                JPDAStart.debug("Notifying");
                this.lock.notify();
            }
            // ** MonitorExit[objectArray] (shouldn't be in output)
            return;
        }
    }

    private MethodBreakpoint createBreakpoint(String stopClassName) {
        MethodBreakpoint breakpoint = MethodBreakpoint.create((String)stopClassName, (String)"*");
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        return breakpoint;
    }

    private ExceptionBreakpoint createCompilationErrorBreakpoint() {
        ExceptionBreakpoint b = ExceptionBreakpoint.create((String)"java.lang.RuntimeException", (int)2);
        b.setHidden(true);
        b.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent event) {
                boolean suspend = false;
                try {
                    ObjectVariable ov;
                    JPDAClassType ct;
                    if (event.getVariable() instanceof ObjectVariable && (ct = (ov = (ObjectVariable)event.getVariable()).getClassType()) != null && (suspend = "java.lang.RuntimeException".equals(ct.getName()))) {
                        Method invokeMethodMethod = ov.getClass().getMethod("invokeMethod", JPDAThread.class, String.class, String.class, Variable[].class);
                        invokeMethodMethod.setAccessible(true);
                        Variable message = (Variable)invokeMethodMethod.invoke((Object)ov, event.getThread(), "getMessage", "()Ljava/lang/String;", new Variable[0]);
                        if (message != null) {
                            suspend = message.getValue().startsWith("\"Uncompilable source code");
                        }
                    }
                }
                catch (IllegalAccessException iaex) {
                    logger.log(Level.FINE, null, iaex);
                }
                catch (InvocationTargetException itex) {
                    logger.log(Level.FINE, null, itex);
                }
                catch (NoSuchMethodException ex) {
                    logger.log(Level.FINE, null, ex);
                }
                if (!suspend) {
                    event.resume();
                }
            }
        });
        b.setPrintText(NbBundle.getBundle((String)"org/netbeans/modules/debugger/jpda/ant/Bundle").getString("MSG_StoppedOnCompileError"));
        return b;
    }

    private static void debug(String msg) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        logger.log(Level.FINER, "{0} [{1}] - {2}", new Object[]{new Date(), Thread.currentThread().getName(), msg});
    }

    static ClassPath createSourcePath(org.apache.tools.ant.Project project, Path modulepath, Path classpath, Path sourcepath, boolean isSourcePathExclusive) {
        if (sourcepath != null && isSourcePathExclusive) {
            return JPDAStart.convertToClassPath(project, sourcepath);
        }
        ClassPath cp = JPDAStart.convertToSourcePath(project, classpath, true);
        ClassPath modulesSources = JPDAStart.convertToSourcePath(project, JPDAStart.modules(project, modulepath), true);
        ClassPath sp = JPDAStart.convertToClassPath(project, sourcepath);
        ClassPath sourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, modulesSources, sp});
        return sourcePath;
    }

    private static Path modules(org.apache.tools.ant.Project project, Path modulepath) {
        if (modulepath == null) {
            return null;
        }
        Path modules = new Path(project);
        for (String pathElement : modulepath.list()) {
            String pathName = project.replaceProperties(pathElement);
            if (pathName.lastIndexOf(URL_EMBEDDING) >= 0) {
                modules.append(new Path(project, pathElement));
                continue;
            }
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (file.isDirectory() && !new File(file, MODULE_INFO_CLZ).exists()) {
                for (File module : file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory() || MODULE_FILES.contains(JPDAStart.getExt(pathname));
                    }
                })) {
                    modules.append(new Path(project, String.format("%s%s%s", pathElement, Character.valueOf(File.separatorChar), module.getName())));
                }
                continue;
            }
            modules.append(new Path(project, pathElement));
        }
        return modules;
    }

    private static String getExt(File file) {
        String name = file.getName();
        int dot = name.indexOf(46);
        return dot <= 0 ? "" : name.substring(dot + 1).toLowerCase();
    }

    static ClassPath createJDKSourcePath(org.apache.tools.ant.Project project, Path bootclasspath) {
        if (bootclasspath == null) {
            JavaPlatform jp = JavaPlatform.getDefault();
            if (jp != null) {
                return jp.getSourceFolders();
            }
            return ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST);
        }
        return JPDAStart.convertToSourcePath(project, bootclasspath, false);
    }

    private static ClassPath convertToClassPath(org.apache.tools.ant.Project project, Path path) {
        String[] paths = path == null ? new String[]{} : path.list();
        ArrayList<URL> l = new ArrayList<URL>();
        int k = paths.length;
        for (int i = 0; i < k; ++i) {
            URL url;
            String pathName = project.replaceProperties(paths[i]);
            File f = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (!JPDAStart.isValid(f, project) || (url = JPDAStart.fileToURL(f, project, true, false)) == null) continue;
            l.add(url);
        }
        URL[] urls = l.toArray(new URL[0]);
        return ClassPathSupport.createClassPath((URL[])urls);
    }

    private static ClassPath convertToSourcePath(org.apache.tools.ant.Project project, Path path, boolean reportNonExistingFiles) {
        String[] paths = path == null ? new String[]{} : path.list();
        ArrayList<PathResourceImplementation> l = new ArrayList<PathResourceImplementation>();
        HashSet<URL> exist = new HashSet<URL>();
        int k = paths.length;
        for (int i = 0; i < k; ++i) {
            URL url;
            String pathInArchive;
            String pathName = project.replaceProperties(paths[i]);
            int index = pathName.lastIndexOf(URL_EMBEDDING);
            if (index >= 0) {
                pathInArchive = pathName.substring(index + URL_EMBEDDING.length()).replace(File.separatorChar, '/');
                pathName = pathName.substring(0, index);
            } else {
                pathInArchive = "";
            }
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (!JPDAStart.isValid(file, project) || (url = JPDAStart.fileToURL(file, project, reportNonExistingFiles, true)) == null) continue;
            if (!pathInArchive.isEmpty()) {
                url = JPDAStart.appendPathInArchive(url, pathInArchive, project);
            }
            logger.log(Level.FINE, "convertToSourcePath - class: {0}", url);
            try {
                SourceForBinaryQuery.Result srcRootsResult = SourceForBinaryQuery.findSourceRoots((URL)url);
                FileObject[] fos = srcRootsResult.getRoots();
                int jj = fos.length;
                logger.log(Level.FINE, "  source roots = {0}; jj = {1}", new Object[]{Arrays.asList(fos), jj});
                for (int j = 0; j < jj; ++j) {
                    FileObject fo = fos[j];
                    logger.log(Level.FINE, "convertToSourcePath - source : {0}", fo);
                    if (FileUtil.isArchiveFile((FileObject)fo) && (fo = FileUtil.getArchiveRoot((FileObject)fo)) == null) {
                        fo = fos[j];
                    }
                    if ((url = fo.toURL()) == null || exist.contains(url)) continue;
                    l.add(ClassPathSupport.createResource((URL)url));
                    exist.add(url);
                }
                continue;
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                logger.log(Level.FINE, "Have illegal url! {0}", ex.getLocalizedMessage());
            }
        }
        return ClassPathSupport.createClassPath(l);
    }

    private static URL appendPathInArchive(URL rootURL, String pathInArchive, org.apache.tools.ant.Project prj) {
        String embeddedURL = rootURL.toExternalForm() + pathInArchive;
        if (embeddedURL.charAt(embeddedURL.length() - 1) != '/') {
            embeddedURL = embeddedURL + '/';
        }
        try {
            return new URL(embeddedURL);
        }
        catch (MalformedURLException e) {
            prj.log("Invalid embedded URL: \"" + embeddedURL + "\".", 1);
            return rootURL;
        }
    }

    private static URL fileToURL(File file, org.apache.tools.ant.Project project, boolean reportNonExistingFiles, boolean withSlash) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            if (reportNonExistingFiles) {
                String path = file.getAbsolutePath();
                project.log("Have no file for " + path, 1);
            }
            return null;
        }
        if (FileUtil.isArchiveFile((FileObject)fileObject) && (fileObject = FileUtil.getArchiveRoot((FileObject)fileObject)) == null) {
            project.log("Bad archive " + file.getAbsolutePath(), 1);
            return null;
        }
        if (withSlash) {
            return FileUtil.urlForArchiveOrDir((File)file);
        }
        return fileObject.toURL();
    }

    private static boolean isValid(File f, org.apache.tools.ant.Project project) {
        if (f.getPath().indexOf("${") != -1 && !f.exists()) {
            project.log("Classpath item " + f + " will be ignored.", 3);
            return false;
        }
        return true;
    }

    static {
        HashSet<String> exts = new HashSet<String>();
        exts.add("jar");
        exts.add("jmod");
        MODULE_FILES = Collections.unmodifiableSet(exts);
    }

    public static class Sourcepath
    extends Path {
        private boolean isExclusive;
        private String path = null;
        private Path plainPath;

        public Sourcepath(org.apache.tools.ant.Project p) {
            super(p);
            logger.log(Level.FINE, "new Sourcepath({0})", p);
        }

        public Sourcepath(org.apache.tools.ant.Project p, String path) {
            super(p, path);
            this.path = path;
            logger.log(Level.FINE, "new Sourcepath({0}, {1})", new Object[]{p, path});
        }

        public void setExclusive(String exclusive) {
            this.isExclusive = "true".equalsIgnoreCase(exclusive);
        }

        boolean isExclusive() {
            return this.isExclusive;
        }

        public Path getPlainPath() {
            if (this.plainPath == null) {
                if (this.getRefid() != null) {
                    Path pp = this.path != null ? new Path(this.getProject(), this.path) : new Path(this.getProject());
                    pp.setLocation(this.getLocation());
                    pp.setDescription(this.getDescription());
                    pp.setRefid(this.getRefid());
                    this.plainPath = pp;
                } else {
                    this.plainPath = this;
                }
            }
            return this.plainPath;
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter {
        private final PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)((Object)this), null);
        private Set<DebuggerEngine> engines = new HashSet<DebuggerEngine>();
        private Breakpoint first;
        private final List<Breakpoint> artificalBreakpoints;
        private final Map<URL, BuildArtifactMapper.ArtifactsUpdated> listeners;
        private final WeakReference<Session>[] startedSessionRef;
        private boolean enginesCheckDone = false;
        private final RequestProcessor rp;

        private Listener(Breakpoint first, List<Breakpoint> artificalBreakpoints, Map<URL, BuildArtifactMapper.ArtifactsUpdated> listeners, WeakReference<Session>[] startedSessionRef, RequestProcessor rp) {
            this.first = first;
            this.artificalBreakpoints = artificalBreakpoints;
            this.listeners = listeners;
            this.startedSessionRef = startedSessionRef;
            this.rp = rp;
        }

        public void propertyChange(final PropertyChangeEvent e) {
            int state;
            if ("state".equals(e.getPropertyName()) && ((state = ((Integer)e.getNewValue()).intValue()) == 3 || state == 4)) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        if (first != null) {
                            DebuggerManager.getDebuggerManager().removeBreakpoint(first);
                            first = null;
                            ((JPDADebugger)e.getSource()).removePropertyChangeListener("state", pcl);
                        }
                    }
                });
            }
        }

        private void dispose() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            this.rp.post(new Runnable(){

                @Override
                public void run() {
                    if (artificalBreakpoints != null) {
                        for (Breakpoint breakpoint : artificalBreakpoints) {
                            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoint);
                        }
                    }
                    if (first != null) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint(first);
                    }
                    if (listeners != null) {
                        for (Map.Entry entry : listeners.entrySet()) {
                            BuildArtifactMapper.removeArtifactsUpdatedListener((URL)((URL)entry.getKey()), (BuildArtifactMapper.ArtifactsUpdated)((BuildArtifactMapper.ArtifactsUpdated)entry.getValue()));
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void engineAdded(DebuggerEngine engine) {
            WeakReference<Session>[] weakReferenceArray = this.startedSessionRef;
            synchronized (this.startedSessionRef) {
                JPDADebugger debugger;
                Session session = (Session)this.startedSessionRef[0].get();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (session != null) {
                    boolean hasEngine = false;
                    for (String l : session.getSupportedLanguages()) {
                        if (!engine.equals(session.getEngineForLanguage(l))) continue;
                        hasEngine = true;
                        break;
                    }
                    if (!hasEngine) {
                        return;
                    }
                }
                if ((debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class)) == null) {
                    return;
                }
                debugger.addPropertyChangeListener("state", this.pcl);
                this.engines.add(engine);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void engineRemoved(DebuggerEngine engine) {
            WeakReference<Session>[] weakReferenceArray = this.startedSessionRef;
            synchronized (this.startedSessionRef) {
                JPDADebugger debugger;
                Session session = (Session)this.startedSessionRef[0].get();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (session != null && !this.enginesCheckDone) {
                    this.enginesCheckDone = true;
                    ArrayList<DebuggerEngine> list = new ArrayList<DebuggerEngine>(this.engines);
                    for (DebuggerEngine eng : list) {
                        boolean hasEngine = false;
                        for (String l : session.getSupportedLanguages()) {
                            if (!engine.equals(session.getEngineForLanguage(l))) continue;
                            hasEngine = true;
                            break;
                        }
                        if (hasEngine) continue;
                        this.engines.remove(eng);
                    }
                }
                if ((debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class)) == null) {
                    return;
                }
                if (this.engines.remove(engine)) {
                    debugger.removePropertyChangeListener("state", this.pcl);
                }
                if (this.engines.isEmpty()) {
                    this.dispose();
                }
                return;
            }
        }
    }
}

