/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.File;
import java.util.HashMap;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public abstract class AbstractFilesListener {
    protected J2eeModuleProvider provider;
    private HashMap fileListeners = new HashMap();
    private FileChangeListener listener = new FileListener();

    public AbstractFilesListener(J2eeModuleProvider provider) {
        this.provider = provider;
        this.startListening();
    }

    protected abstract File[] getTargetFiles();

    protected abstract boolean isTarget(FileObject var1);

    protected abstract boolean isTarget(String var1);

    protected abstract void targetCreated(FileObject var1);

    protected abstract void targetDeleted(FileObject var1);

    protected abstract void targetChanged(FileObject var1);

    private synchronized void startListening() {
        File[] targets = this.getTargetFiles();
        for (int i = 0; i < targets.length; ++i) {
            this.startListening(targets[i]);
        }
    }

    public synchronized void stopListening() {
        for (FileObject fo : this.fileListeners.keySet()) {
            this.removeFileListenerFrom(fo);
        }
    }

    private void startListening(File target) {
        if (!target.isAbsolute()) {
            return;
        }
        FileObject targetFO = FileUtil.toFileObject((File)target);
        while (targetFO == null) {
            if ((target = target.getParentFile()) == null) {
                return;
            }
            targetFO = FileUtil.toFileObject((File)target);
        }
        if (!this.fileListeners.containsKey(targetFO)) {
            this.addFileListenerTo(targetFO);
        }
    }

    private void addFileListenerTo(FileObject fo) {
        FileChangeListener l = FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)fo);
        this.fileListeners.put(fo, l);
        fo.addFileChangeListener(l);
    }

    private void removeFileListenerFrom(FileObject fo) {
        FileChangeListener l = (FileChangeListener)this.fileListeners.remove(fo);
        if (l != null) {
            fo.removeFileChangeListener(l);
        }
    }

    private final class FileListener
    implements FileChangeListener {
        private FileListener() {
        }

        public void fileFolderCreated(FileEvent e) {
            AbstractFilesListener.this.startListening();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent e) {
            FileObject fo = e.getFile();
            if (AbstractFilesListener.this.isTarget(fo)) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    AbstractFilesListener.this.removeFileListenerFrom(fo);
                }
                AbstractFilesListener.this.targetDeleted(fo);
            }
            AbstractFilesListener.this.startListening();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDataCreated(FileEvent e) {
            FileObject fo = e.getFile();
            if (AbstractFilesListener.this.isTarget(fo)) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    AbstractFilesListener.this.addFileListenerTo(fo);
                }
                AbstractFilesListener.this.targetCreated(fo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileRenamed(FileRenameEvent e) {
            FileObject fo = e.getFile();
            if (AbstractFilesListener.this.isTarget(fo)) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    if (!AbstractFilesListener.this.fileListeners.containsKey(fo)) {
                        AbstractFilesListener.this.addFileListenerTo(fo);
                    }
                }
                AbstractFilesListener.this.targetCreated(fo);
            } else if (AbstractFilesListener.this.isTarget(e.getName() + "." + e.getExt())) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    AbstractFilesListener.this.removeFileListenerFrom(fo);
                }
                AbstractFilesListener.this.targetDeleted(fo);
            }
            AbstractFilesListener.this.startListening();
        }

        public void fileAttributeChanged(FileAttributeEvent e) {
        }

        public void fileChanged(FileEvent e) {
            FileObject fo = e.getFile();
            if (AbstractFilesListener.this.isTarget(fo)) {
                fo.refresh(true);
                AbstractFilesListener.this.targetChanged(fo);
            }
        }
    }
}

