/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.upgrade.systemoptions.ContentProcessor;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.Result;
import org.netbeans.upgrade.systemoptions.SerParser;
import org.netbeans.upgrade.systemoptions.SettingsRecognizer;
import org.openide.filesystems.FileObject;

public class SystemOptionsParser {
    static final String EXPECTED_INSTANCE = "org.openide.options.SystemOption";
    private String systemOptionInstanceName;
    private boolean types;

    private SystemOptionsParser(String systemOptionInstanceName, boolean types) {
        this.systemOptionInstanceName = systemOptionInstanceName;
        this.types = types;
    }

    public static DefaultResult parse(FileObject settingsFo, boolean types) throws IOException, ClassNotFoundException {
        SettingsRecognizer instance = SystemOptionsParser.getRecognizer(settingsFo);
        try (InputStream is = instance.getSerializedInstance();){
            SerParser sp = new SerParser(is);
            SerParser.Stream s = sp.parse();
            SystemOptionsParser rImpl = new SystemOptionsParser(instance.instanceName(), types);
            DefaultResult ret = (DefaultResult)rImpl.processContent(s.contents.iterator(), false);
            ret.setModuleName(instance.getCodeNameBase().replace('.', '/'));
            DefaultResult defaultResult = ret;
            return defaultResult;
        }
    }

    private Result processContent(Iterator<Object> it, boolean reachedWriteReplace) {
        while (it.hasNext()) {
            Object elem = it.next();
            if (!reachedWriteReplace && elem instanceof SerParser.ObjectWrapper) {
                SerParser.ObjectWrapper ow = (SerParser.ObjectWrapper)elem;
                String name = ow.classdesc.name;
                if (!name.endsWith("org.openide.util.SharedClassObject$WriteReplace;")) continue;
                return this.processContent(ow.data.iterator(), true);
            }
            if (!reachedWriteReplace || !(elem instanceof SerParser.NameValue)) continue;
            SerParser.NameValue nv = (SerParser.NameValue)elem;
            if (!this.systemOptionInstanceName.equals(nv.value)) continue;
            Result result = ContentProcessor.parseContent(this.systemOptionInstanceName, this.types, it);
            return result;
        }
        return null;
    }

    private static SettingsRecognizer getRecognizer(FileObject settingsFo) throws IOException {
        SettingsRecognizer recognizer = new SettingsRecognizer(false, settingsFo);
        recognizer.parse();
        Set instances = recognizer.getInstanceOf();
        String iName = recognizer.instanceName();
        if (!instances.contains(EXPECTED_INSTANCE)) {
            throw new IOException(iName);
        }
        return recognizer;
    }
}

