/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.queries.FileEncodingQueryImpl;
import org.netbeans.modules.apisupport.project.queries.OSGiSourceForBinaryImpl;
import org.netbeans.modules.apisupport.project.queries.TemplateAttributesProvider;
import org.netbeans.modules.apisupport.project.spi.PlatformJarProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteSubprojectProviderImpl;
import org.netbeans.modules.apisupport.project.suite.SuiteType;
import org.netbeans.modules.apisupport.project.ui.SuiteActions;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.SuiteOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.universe.DestDirProvider;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SuiteProject
implements Project {
    public static final String SUITE_ICON_PATH = "org/netbeans/modules/apisupport/project/suite/resources/suite.png";
    private final AntProjectHelper helper;
    private Lookup lookup;
    private final PropertyEvaluator eval;
    private final GeneratedFilesHelper genFilesHelper;

    public SuiteProject(AntProjectHelper helper) throws IOException {
        this.helper = helper;
        this.eval = this.createEvaluator();
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        Util.err.log("Loading suite project in " + this.getProjectDirectory());
        this.lookup = Lookups.fixed((Object[])new Object[]{this, new Info(), helper.createAuxiliaryConfiguration(), helper.createAuxiliaryProperties(), helper.createCacheDirectoryProvider(), new SavedHook(), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new OpenedHook()), helper.createSharabilityQuery(this.eval, new String[0], new String[]{"${suite.build.dir}", "${dist.dir}"}), new SuiteSubprojectProviderImpl(helper, this.eval), new SuiteProviderImpl(), new SuiteActions(this), new SuiteLogicalView(this), new SuiteCustomizer(this, helper, this.eval), new PrivilegedTemplatesImpl(), new SuiteOperations(this), new TemplateAttributesProvider(null, helper, false), new FileEncodingQueryImpl(), new PlatformJarProviderImpl(), new OSGiSourceForBinaryImpl(this)});
        this.lookup = LookupProviderSupport.createCompositeLookup((Lookup)this.lookup, (String)"Projects/org-netbeans-modules-apisupport-project-suite/Lookup");
    }

    public String toString() {
        return "SuiteProject[" + this.getProjectDirectory() + "]";
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getProjectDirectory());
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    @NonNull
    public File getTestUserDirLockFile() {
        String v = this.getEvaluator().evaluate("${test.user.dir}/lock");
        return this.getHelper().resolveFile(v != null ? v : "unknown");
    }

    @CheckForNull
    public NbPlatform getPlatform(boolean fallback) {
        NbPlatform p;
        String destdir = this.getEvaluator().getProperty("netbeans.dest.dir");
        if (destdir != null) {
            String harnessDir = this.getEvaluator().getProperty("harness.dir");
            p = NbPlatform.getPlatformByDestDir(this.getHelper().resolveFile(destdir), harnessDir != null ? this.getHelper().resolveFile(harnessDir) : null);
        } else {
            p = null;
        }
        if (fallback && (p == null || !p.isValid())) {
            p = NbPlatform.getDefaultPlatform();
        }
        return p;
    }

    private PropertyEvaluator createEvaluator() {
        PropertyProvider predefs = this.helper.getStockPropertyPreprovider();
        File dir = this.getProjectDirectoryFile();
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        providers.add(this.helper.getPropertyProvider("nbproject/private/platform-private.properties"));
        providers.add(this.helper.getPropertyProvider("nbproject/platform.properties"));
        PropertyEvaluator baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
        providers.add(new ApisupportAntUtils.UserPropertiesFileProvider(baseEval, dir));
        baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
        providers.add(new DestDirProvider(baseEval));
        providers.add(this.helper.getPropertyProvider("nbproject/private/private.properties"));
        providers.add(this.helper.getPropertyProvider("nbproject/project.properties"));
        HashMap<String, String> fixedProps = new HashMap<String, String>();
        fixedProps.put("enabled.clusters", "");
        fixedProps.put("disabled.clusters", "");
        fixedProps.put("disabled.modules", "");
        fixedProps.put("branding.dir", "branding");
        fixedProps.put("suite.build.dir", "build");
        fixedProps.put("cluster", "${suite.build.dir}/cluster");
        fixedProps.put("dist.dir", "dist");
        fixedProps.put("test.user.dir", "${suite.build.dir}/testuserdir");
        providers.add(PropertyUtils.fixedPropertyProvider(fixedProps));
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
    }

    public void open() {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                String path = "nbproject/private/platform-private.properties";
                EditableProperties ep = SuiteProject.this.helper.getProperties(path);
                File buildProperties = new File(System.getProperty("netbeans.user"), "build.properties");
                ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
                SuiteProject.this.helper.putProperties(path, ep);
                try {
                    ProjectManager.getDefault().saveProject((Project)SuiteProject.this);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                return null;
            }
        });
        try {
            this.refreshBuildScripts(true);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public void refreshBuildScripts(boolean checkForProjectXmlModified) throws IOException {
        NbPlatform platform = this.getPlatform(true);
        if (platform == null) {
            return;
        }
        String buildImplPath = platform.getHarnessVersion().compareTo(HarnessVersion.V65) <= 0 || this.eval.getProperty("cluster.path") == null ? "build-impl-65.xsl" : "build-impl.xsl";
        this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", SuiteProject.class.getResource("resources/" + buildImplPath), checkForProjectXmlModified);
        this.genFilesHelper.refreshBuildScript("nbproject/platform.xml", SuiteProject.class.getResource("resources/platform.xsl"), checkForProjectXmlModified);
        this.genFilesHelper.refreshBuildScript("build.xml", SuiteProject.class.getResource("resources/build.xsl"), checkForProjectXmlModified);
    }

    public SuiteType getSuiteType() {
        if (this.helper.getProperties("nbproject/platform.properties").getProperty("branding.token") != null) {
            return SuiteType.APPLICATION;
        }
        return SuiteType.SUITE;
    }

    private final class Info
    implements ProjectInformation,
    AntProjectListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
            SuiteProject.this.helper.addAntProjectListener((AntProjectListener)this);
        }

        private String getSimpleName() {
            Element nameEl = XMLUtil.findElement((Element)SuiteProject.this.helper.getPrimaryConfigurationData(true), (String)"name", (String)"http://www.netbeans.org/ns/nb-module-suite-project/1");
            String text = nameEl != null ? XMLUtil.findText((Node)nameEl) : null;
            return text != null ? text : "???";
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getSimpleName());
        }

        public String getDisplayName() {
            String appTitle = SuiteProject.this.getEvaluator().getProperty("app.title");
            if (appTitle != null) {
                return appTitle;
            }
            return this.getSimpleName();
        }

        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)SuiteProject.SUITE_ICON_PATH, (boolean)false);
        }

        public Project getProject() {
            return SuiteProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.fireNameChange();
        }

        public void propertiesChanged(AntProjectEvent ev) {
            this.fireNameChange();
        }

        private void fireNameChange() {
            this.pcs.firePropertyChange("name", null, this.getName());
            this.pcs.firePropertyChange("displayName", null, this.getDisplayName());
        }
    }

    private final class SavedHook
    extends ProjectXmlSavedHook {
        SavedHook() {
        }

        protected void projectXmlSaved() throws IOException {
            SuiteProject.this.refreshBuildScripts(false);
        }
    }

    private final class OpenedHook
    extends ProjectOpenedHook {
        OpenedHook() {
        }

        public void projectOpened() {
            SuiteProject.this.open();
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)SuiteProject.this);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
    }

    private final class SuiteProviderImpl
    implements SuiteProvider {
        private SuiteProviderImpl() {
        }

        @Override
        public File getSuiteDirectory() {
            return SuiteProject.this.getProjectDirectoryFile();
        }

        @Override
        public File getClusterDirectory() {
            String clusterName = SuiteProject.this.getEvaluator().evaluate("${cluster}");
            return SuiteProject.this.getHelper().resolveFile(clusterName).getAbsoluteFile();
        }
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Ant/Project.xml", "Templates/Other/properties.properties"};
        private static final String[] RECOMMENDED_TYPES = new String[]{"oasis-XML-catalogs", "XML", "ant-script", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }
    }

    private class PlatformJarProviderImpl
    implements PlatformJarProvider {
        private PlatformJarProviderImpl() {
        }

        public Set<File> getPlatformJars() throws IOException {
            HashSet<File> jars = new HashSet<File>();
            for (ModuleEntry entry : ModuleList.findOrCreateModuleListFromSuite(SuiteProject.this.getProjectDirectoryFile(), null).getAllEntries()) {
                jars.add(entry.getJarLocation());
            }
            return jars;
        }
    }
}

