/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media.player;

import java.util.HashMap;
import java.util.Map;
import org.primefaces.component.media.player.FlashPlayer;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.PDFPlayer;
import org.primefaces.component.media.player.QuickTimePlayer;
import org.primefaces.component.media.player.RealPlayer;
import org.primefaces.component.media.player.WindowsPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaPlayerFactory {
    private static Map<String, MediaPlayer> players;

    public static Map<String, MediaPlayer> getPlayers() {
        if (players == null) {
            players = new HashMap<String, MediaPlayer>();
            players.put("quicktime", new QuickTimePlayer());
            players.put("flash", new FlashPlayer());
            players.put("windows", new WindowsPlayer());
            players.put("real", new RealPlayer());
            players.put("pdf", new PDFPlayer());
        }
        return players;
    }

    public static MediaPlayer getPlayer(String type) {
        if (type == null) {
            throw new IllegalArgumentException("A media player type must be provided");
        }
        MediaPlayer player = MediaPlayerFactory.getPlayers().get(type);
        if (player != null) {
            return player;
        }
        throw new IllegalArgumentException(type + " is not a valid media player type");
    }
}

