/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.DefaultScannerListener;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MavenArchetypeArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MavenPluginArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.ArtifactDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.ClassDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.CustomArtifactContextProducer;
import org.netbeans.modules.maven.indexer.FastScanner;
import org.netbeans.modules.maven.indexer.MinimalArtifactInfoRemoteIndexCreator;
import org.netbeans.modules.maven.indexer.NexusRepositoryQueries;
import org.netbeans.modules.maven.indexer.NotifyingIndexCreator;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexQueryProvider;
import org.netbeans.modules.maven.indexer.spi.impl.IndexingNotificationProvider;
import org.netbeans.modules.maven.indexer.spi.impl.RepositoryIndexerImplementation;
import org.openide.modules.Places;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;

public final class NexusRepositoryIndexManager
implements RepositoryIndexerImplementation,
RepositoryIndexQueryProvider {
    private static final Logger LOGGER = Logger.getLogger(NexusRepositoryIndexManager.class.getName());
    private static final String GROUP_CACHE_ALL_PREFIX = "nb-groupcache-all-v1";
    private static final String GROUP_CACHE_ALL_SUFFIX = "txt";
    private static final String GROUP_CACHE_ROOT_PREFIX = "nb-groupcache-root-v1";
    private static final String GROUP_CACHE_ROOT_SUFFIX = "txt";
    private PlexusContainer embedder;
    private Indexer indexer;
    private Scanner scanner;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private final Map<String, IndexingContext> indexingContexts = new ConcurrentHashMap<String, IndexingContext>();
    private boolean inited = false;
    private static final HashMap<String, Mutex> repoMutexMap = new HashMap(4);
    private static final Set<Mutex> indexingMutexes = new HashSet<Mutex>();
    private static final RequestProcessor RP_LOCAL = new RequestProcessor("maven-local-indexing");
    private static final RequestProcessor RP_REMOTE = new RequestProcessor("maven-remote-indexing");
    private final NexusRepositoryQueries queries = new NexusRepositoryQueries(this);
    static final int MAX_RESULT_COUNT = 4096;
    static final int NO_CAP_RESULT_COUNT = -1;

    @Override
    public boolean handlesRepository(RepositoryInfo repo) {
        return true;
    }

    @Override
    public BaseQueries getBaseQueries() {
        return this.queries;
    }

    @Override
    public ChecksumQueries getChecksumQueries() {
        return this.queries;
    }

    @Override
    public ArchetypeQueries getArchetypeQueries() {
        return this.queries;
    }

    @Override
    public DependencyInfoQueries getDependencyInfoQueries() {
        return this.queries;
    }

    @Override
    public ClassesQuery getClassesQuery() {
        return this.queries;
    }

    @Override
    public ClassUsageQuery getClassUsageQuery() {
        return this.queries;
    }

    @Override
    public GenericFindQuery getGenericFindQuery() {
        return this.queries;
    }

    @Override
    public ContextLoadedQuery getContextLoadedQuery() {
        return this.queries;
    }

    static Mutex getRepoMutex(RepositoryInfo repo) {
        return NexusRepositoryIndexManager.getRepoMutex(repo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Mutex getRepoMutex(String repoId) {
        HashMap<String, Mutex> hashMap = repoMutexMap;
        synchronized (hashMap) {
            return repoMutexMap.computeIfAbsent(repoId, k -> new Mutex());
        }
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration config = new DefaultContainerConfiguration();
                ClassLoader indexerLoader = NexusRepositoryIndexManager.class.getClassLoader();
                ClassWorld classWorld = new ClassWorld();
                ClassRealm plexusRealm = classWorld.newRealm("plexus.core", EmbedderFactory.class.getClassLoader());
                plexusRealm.importFrom(indexerLoader, "META-INF/sisu");
                plexusRealm.importFrom(indexerLoader, "org.apache.maven.index");
                plexusRealm.importFrom(indexerLoader, "org.netbeans.modules.maven.indexer");
                config.setClassWorld(classWorld);
                config.setClassPathScanning("index");
                this.embedder = new DefaultPlexusContainer((ContainerConfiguration)config);
                ComponentDescriptor desc = new ComponentDescriptor();
                desc.setRoleClass(ArtifactContextProducer.class);
                desc.setImplementationClass(CustomArtifactContextProducer.class);
                ComponentRequirement req = new ComponentRequirement();
                req.setFieldName("mapper");
                req.setRole(ArtifactPackagingMapper.class.getName());
                desc.addRequirement(req);
                this.embedder.addComponentDescriptor(desc);
                this.indexer = (Indexer)this.embedder.lookup(Indexer.class);
                this.searcher = (SearchEngine)this.embedder.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)this.embedder.lookup(IndexUpdater.class);
                this.contextProducer = (ArtifactContextProducer)this.embedder.lookup(ArtifactContextProducer.class);
                this.scanner = new FastScanner(this.contextProducer);
                this.inited = true;
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    public Map<String, IndexingContext> getIndexingContexts() {
        return Collections.unmodifiableMap(this.indexingContexts);
    }

    private IndexingContext addIndexingContextForced(RepositoryInfo repo, List<? extends IndexCreator> indexers) throws IOException {
        IndexingContext context = this.indexer.createIndexingContext(repo.getId(), repo.getId(), repo.isLocal() ? new File(repo.getRepositoryPath()) : null, NexusRepositoryIndexManager.getIndexDirectory(repo).toFile(), repo.isRemoteDownloadable() ? repo.getRepositoryUrl() : null, repo.isRemoteDownloadable() ? repo.getIndexUpdateUrl() : null, true, true, indexers);
        try {
            context.setAllGroups(Files.readAllLines(NexusRepositoryIndexManager.getAllGroupCacheFile(repo)));
            context.setRootGroups(Files.readAllLines(NexusRepositoryIndexManager.getRootGroupCacheFile(repo)));
        }
        catch (IOException ex) {
            NexusRepositoryIndexManager.rebuildGroupCache(repo, context);
        }
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    public void removeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        if (this.indexingContexts.remove(context.getId()) != null) {
            this.indexer.closeIndexingContext(context, deleteFiles);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    boolean loadIndexingContext(RepositoryInfo info) throws IOException {
        block12: {
            if (!NexusRepositoryIndexManager.$assertionsDisabled && !NexusRepositoryIndexManager.getRepoMutex(info).isWriteAccess()) {
                throw new AssertionError();
            }
            this.initIndexer();
            context = this.getIndexingContexts().get(info.getId());
            indexUpdateUrl = info.getIndexUpdateUrl();
            if (context == null) ** GOTO lbl20
            contexturl = context.getIndexUpdateUrl();
            contextfile = context.getRepository();
            v0 = repofile = info.getRepositoryPath() != null ? new File(info.getRepositoryPath()) : null;
            if (BaseUtilities.compareObjects((Object)contexturl, (Object)indexUpdateUrl)) break block12;
            NexusRepositoryIndexManager.LOGGER.log(Level.FINE, "Remote context changed: {0}, unload/load", info.getId());
            this.unloadIndexingContext(info.getId());
            ** GOTO lbl20
        }
        if (BaseUtilities.compareObjects((Object)contextfile, (Object)repofile)) {
            NexusRepositoryIndexManager.LOGGER.log(Level.FINER, "Skipping Context: {0}, already loaded.", info.getId());
        } else {
            NexusRepositoryIndexManager.LOGGER.log(Level.FINE, "Local context changed: {0}, unload/load", info.getId());
            this.unloadIndexingContext(info.getId());
lbl20:
            // 3 sources

            creators /* !! */  = info.isLocal() != false ? List.of(new JarFileContentsIndexCreator(), new MinimalArtifactInfoIndexCreator(), new MavenArchetypeArtifactInfoIndexCreator(), new MavenPluginArtifactInfoIndexCreator(), new ArtifactDependencyIndexCreator(), new ClassDependencyIndexCreator()) : List.of(info.getId().equals(this.queries.getSMO().getRepositoryId()) != false ? new MinimalArtifactInfoRemoteIndexCreator() : new MinimalArtifactInfoIndexCreator(), new NotifyingIndexCreator());
            if (info.isRemoteDownloadable() && !NexusRepositoryIndexManager.indexExists(NexusRepositoryIndexManager.getIndexDirectory(info))) {
                this.tryMoveRemoteIndexFromOldCache(info);
            }
            try {
                NexusRepositoryIndexManager.LOGGER.log(Level.FINE, "Loading Context: {0}", info.getId());
                this.addIndexingContextForced(info, creators /* !! */ );
                NexusRepositoryIndexManager.LOGGER.log(Level.FINE, "using index creators: {0}", creators /* !! */ );
            }
            catch (IOException | IllegalArgumentException ex) {
                NexusRepositoryIndexManager.LOGGER.log(Level.WARNING, "Found an incompatible or broken index at " + NexusRepositoryIndexManager.getIndexDirectory(info) + " with loaded contexts " + this.getIndexingContexts().keySet() + ", resetting.", ex);
                NexusRepositoryIndexManager.removeDir(NexusRepositoryIndexManager.getIndexDirectory(info));
            }
        }
        currents = new HashSet<String>();
        for (Object info2 : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            currents.add(info2.getId());
        }
        toRemove = new HashSet<String>(this.getIndexingContexts().keySet());
        toRemove.removeAll(currents);
        if (!toRemove.isEmpty()) {
            for (String repo : toRemove) {
                try {
                    NexusRepositoryIndexManager.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadIndexingContext$1(java.lang.String ), ()Ljava/lang/Void;)((NexusRepositoryIndexManager)this, (String)repo));
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!NexusRepositoryIndexManager.indexExists(indexDir = NexusRepositoryIndexManager.getIndexDirectory(info))) {
            NexusRepositoryIndexManager.LOGGER.log(Level.FINER, "Index Not Available: {0} at: {1}", new Object[]{info.getId(), indexDir.toAbsolutePath()});
            return true;
        }
        return false;
    }

    private void tryMoveRemoteIndexFromOldCache(RepositoryInfo info) {
        int ourVersion;
        String buildnumber = System.getProperty("netbeans.buildnumber");
        if (buildnumber == null || buildnumber.isBlank() || !buildnumber.contains("-")) {
            return;
        }
        try {
            String debugRelease = System.getProperty("maven.indexing.diag.release");
            ourVersion = debugRelease != null ? Integer.parseInt(debugRelease) : Integer.parseInt(buildnumber.substring(0, buildnumber.lastIndexOf("-")));
        }
        catch (NumberFormatException ignore) {
            return;
        }
        Path cacheParent = Places.getCacheDirectory().toPath().getParent();
        if (cacheParent != null) {
            try (Stream<Path> caches = Files.list(cacheParent);){
                Path oldIndex;
                record CacheFolder(Path path, int version) {
                }
                Optional<CacheFolder> oldCache = caches.filter(path -> Files.exists(path.resolve(".lastUsedVersion"), new LinkOption[0])).map(path -> {
                    try {
                        int version = Integer.parseInt(Files.readString(path.resolve(".lastUsedVersion")));
                        return new CacheFolder((Path)path, version);
                    }
                    catch (IOException | NumberFormatException ex) {
                        return null;
                    }
                }).filter(Objects::nonNull).filter(cache -> cache.version < ourVersion).max((c1, c2) -> c1.version - c2.version);
                if (oldCache.isPresent() && NexusRepositoryIndexManager.indexExists(oldIndex = NexusRepositoryIndexManager.getIndexDirectory(oldCache.get().path, info))) {
                    Instant lastUse = Files.getLastModifiedTime(oldIndex.resolve("timestamp"), new LinkOption[0]).toInstant();
                    if (Instant.now().minus(30L, ChronoUnit.DAYS).isBefore(lastUse)) {
                        LOGGER.log(Level.INFO, "moving index from old cache [{0}]", oldIndex);
                        Files.move(oldIndex, NexusRepositoryIndexManager.getIndexDirectory(info), new CopyOption[0]);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "index import failed: {0}: {1}", new Object[]{ex.getClass().getName(), ex.getMessage()});
            }
        }
    }

    private void unloadIndexingContext(String repo) throws IOException {
        assert (NexusRepositoryIndexManager.getRepoMutex(repo).isWriteAccess());
        LOGGER.log(Level.FINE, "Unloading Context: {0}", repo);
        IndexingContext ic = this.getIndexingContexts().get(repo);
        if (ic != null) {
            this.removeIndexingContext(ic, false);
        }
    }

    /*
     * Exception decompiling
     */
    private void indexLoadedRepo(RepositoryInfo repo, boolean updateLocal) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[CATCHBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void pauseRemoteRepoIndexing(int minutes) {
        LOGGER.log(Level.INFO, "pausing index downloads for {0} {1}.", new Object[]{minutes, ChronoUnit.MINUTES});
        RepositoryPreferences.pauseIndexDownloadsFor(minutes, ChronoUnit.MINUTES);
    }

    private static boolean isNoSpaceLeftOnDevice(Throwable ex) {
        String msg = ex.getMessage();
        Throwable cause = ex.getCause();
        Throwable[] suppressed = ex.getSuppressed();
        return msg != null && msg.contains("No space left on device") || cause != null && NexusRepositoryIndexManager.isNoSpaceLeftOnDevice(cause) || suppressed.length > 0 && Stream.of(suppressed).anyMatch(NexusRepositoryIndexManager::isNoSpaceLeftOnDevice);
    }

    private static boolean isCancellation(Throwable ex) {
        return Stream.of(ex.getSuppressed()).anyMatch(s -> s instanceof Cancellation);
    }

    private static boolean isDiag() {
        return Boolean.getBoolean("maven.indexing.diag");
    }

    boolean spawnIndexLoadedRepo(RepositoryInfo repo) {
        if (NexusRepositoryIndexManager.shouldSkipIndexRequest(repo)) {
            return false;
        }
        RequestProcessor rp = repo.isLocal() ? RP_LOCAL : RP_REMOTE;
        rp.post(() -> NexusRepositoryIndexManager.getRepoMutex(repo).writeAccess(() -> {
            if (NexusRepositoryIndexManager.shouldSkipIndexRequest(repo)) {
                return null;
            }
            try {
                this.indexLoadedRepo(repo, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), ex);
            }
            return null;
        }));
        return true;
    }

    @Override
    public void indexRepo(RepositoryInfo repo) {
        if (NexusRepositoryIndexManager.shouldSkipIndexRequest(repo)) {
            return;
        }
        LOGGER.log(Level.FINER, "Indexing Context: {0}", repo);
        try {
            RemoteIndexTransferListener.addToActive(Thread.currentThread());
            NexusRepositoryIndexManager.getRepoMutex(repo).writeAccess(() -> {
                if (NexusRepositoryIndexManager.shouldSkipIndexRequest(repo)) {
                    return null;
                }
                try {
                    this.initIndexer();
                    assert (this.indexer != null);
                    boolean noIndexExists = this.loadIndexingContext(repo);
                    this.indexLoadedRepo(repo, !noIndexExists);
                }
                catch (IOException x) {
                    LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), x);
                }
                return null;
            });
        }
        finally {
            RemoteIndexTransferListener.removeFromActive(Thread.currentThread());
        }
    }

    private static boolean shouldSkipIndexRequest(RepositoryInfo repo) {
        if (repo.isRemoteDownloadable()) {
            if (!RepositoryPreferences.isIndexDownloadEnabledEffective()) {
                return true;
            }
            if (RepositoryPreferences.isIndexDownloadDeniedFor(repo)) {
                return true;
            }
            if (!RepositoryPreferences.isIndexDownloadAllowedFor(repo)) {
                IndexingNotificationProvider np = (IndexingNotificationProvider)Lookup.getDefault().lookup(IndexingNotificationProvider.class);
                if (np != null) {
                    np.requestPermissionsFor(repo);
                }
                return true;
            }
        }
        return false;
    }

    public void shutdownAll() {
        LOGGER.fine("Shutting Down All Contexts");
        try {
            if (this.inited) {
                for (IndexingContext ic : this.getIndexingContexts().values()) {
                    LOGGER.log(Level.FINER, "Shutting Down: {0}", ic.getId());
                    this.removeIndexingContext(ic, false);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void scanLocalRepo(IndexingContext context, String fromPath, ArtifactScanningListener listener, boolean update) throws IOException {
        File repositoryDirectory = context.getRepository();
        if (repositoryDirectory == null) {
            return;
        }
        if (!repositoryDirectory.exists()) {
            throw new IOException("Repository directory " + repositoryDirectory + " does not exist");
        }
        Path tmpDir = Places.getCacheDirectory().toPath().resolve("tmp-" + context.getRepositoryId());
        if (Files.exists(tmpDir, new LinkOption[0])) {
            NexusRepositoryIndexManager.removeDir(tmpDir);
        }
        Files.createDirectory(tmpDir, new FileAttribute[0]);
        IndexingContext tmpContext = null;
        try {
            FSDirectory directory = FSDirectory.open((Path)tmpDir);
            if (update) {
                IndexUtils.copyDirectory(context.getIndexDirectory(), (Directory)directory);
            }
            tmpContext = new DefaultIndexingContext(context.getId() + "-tmp", context.getRepositoryId(), context.getRepository(), tmpDir.toFile(), context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators(), true);
            DefaultScannerListener defaultListener = new DefaultScannerListener(tmpContext, (IndexerEngine)this.embedder.lookup(IndexerEngine.class), update, listener);
            this.scanner.scan(new ScanningRequest(tmpContext, defaultListener, fromPath));
            tmpContext.updateTimestamp(true);
            context.replace(tmpContext.getIndexDirectory());
        }
        catch (Exception ex) {
            throw new IOException("Error scanning context " + context.getId() + ": " + ex, ex);
        }
        finally {
            if (tmpContext != null) {
                tmpContext.close(true);
            }
            NexusRepositoryIndexManager.removeDir(tmpDir);
        }
    }

    @Override
    public void updateIndexWithArtifacts(RepositoryInfo repo, Collection<Artifact> artifacts) {
        if (!RepositoryPreferences.isIndexRepositories()) {
            return;
        }
        ArtifactRepository repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        try {
            NexusRepositoryIndexManager.getRepoMutex(repo).writeAccess(() -> {
                boolean index = this.loadIndexingContext(repo);
                if (index) {
                    return null;
                }
                IndexingContext indexingContext = this.indexingContexts.get(repo.getId());
                if (indexingContext == null) {
                    LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                    return null;
                }
                if (!indexingContext.getRepository().exists()) {
                    LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no update.", indexingContext.getRepository());
                    return null;
                }
                HashSet<ArtifactContext> artifactContexts = new HashSet<ArtifactContext>();
                for (Artifact artifact : artifacts) {
                    File art;
                    Object absolutePath;
                    if (artifact.getFile() != null) {
                        absolutePath = artifact.getFile().getAbsolutePath();
                    } else {
                        if (artifact.getVersion() == null) continue;
                        absolutePath = repo.getRepositoryPath() + File.separator + repository.pathOf(artifact);
                    }
                    if (!(art = new File((String)absolutePath)).exists()) continue;
                    boolean add = artifact.isSnapshot();
                    if (!artifact.isSnapshot()) {
                        String id = artifact.getGroupId() + "|" + artifact.getArtifactId() + "|" + artifact.getVersion() + "|" + ArtifactInfo.nvl(artifact.getClassifier());
                        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST)).build();
                        try (IteratorSearchResponse response = this.queries.repeatedPagedSearch((Query)bq, indexingContext, 4096);){
                            add = response == null || response.getTotalHitsCount() == 0;
                        }
                    }
                    if (add) {
                        LOGGER.log(Level.FINE, "indexing " + artifact.getId());
                        ArtifactContext ac = this.contextProducer.getArtifactContext(indexingContext, art);
                        artifactContexts.add(ac);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Skipped " + artifact.getId() + " already in index.");
                }
                this.indexer.addArtifactsToIndex(artifactContexts, indexingContext);
                NexusRepositoryIndexManager.storeGroupCache(repo, indexingContext);
                return null;
            });
        }
        catch (MutexException ex) {
            List<Artifact> sample = artifacts.stream().limit(5L).toList();
            LOGGER.log(Level.WARNING, "Unable to update index with artifact(s): " + sample + (String)(artifacts.size() > sample.size() ? " +" + (artifacts.size() - sample.size()) + " more" : ""), ex);
        }
        catch (NullPointerException x) {
            LOGGER.log(Level.INFO, "#201057", x);
        }
        this.fireChange(repo, () -> repo.fireIndexChange());
    }

    @Override
    public void deleteArtifactFromIndex(RepositoryInfo repo, Artifact artifact) {
        if (!RepositoryPreferences.isIndexRepositories()) {
            return;
        }
        ArtifactRepository repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        try {
            NexusRepositoryIndexManager.getRepoMutex(repo).writeAccess(() -> {
                Object absolutePath;
                boolean index = this.loadIndexingContext(repo);
                if (index) {
                    return null;
                }
                IndexingContext indexingContext = this.indexingContexts.get(repo.getId());
                if (indexingContext == null) {
                    LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                    return null;
                }
                if (!indexingContext.getRepository().exists()) {
                    LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no update.", indexingContext.getRepository());
                    return null;
                }
                if (artifact.getFile() != null) {
                    absolutePath = artifact.getFile().getAbsolutePath();
                } else if (artifact.getVersion() != null) {
                    absolutePath = repo.getRepositoryPath() + File.separator + repository.pathOf(artifact);
                } else {
                    return null;
                }
                String extension = artifact.getArtifactHandler().getExtension();
                Object pomPath = ((String)absolutePath).substring(0, ((String)absolutePath).length() - extension.length());
                pomPath = (String)pomPath + "pom";
                File pom = new File((String)pomPath);
                if (pom.exists()) {
                    this.indexer.deleteArtifactsFromIndex(List.of(this.contextProducer.getArtifactContext(indexingContext, pom)), indexingContext);
                    NexusRepositoryIndexManager.storeGroupCache(repo, indexingContext);
                }
                return null;
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChange(repo, () -> repo.fireIndexChange());
    }

    private void fireChange(RepositoryInfo repo, Runnable r) {
        if (NexusRepositoryIndexManager.getRepoMutex(repo).isWriteAccess()) {
            RequestProcessor.getDefault().post(() -> this.fireChange(repo, r));
            return;
        }
        assert (!NexusRepositoryIndexManager.getRepoMutex(repo).isWriteAccess() && !NexusRepositoryIndexManager.getRepoMutex(repo).isReadAccess());
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isIndexing(Mutex mutex) {
        Set<Mutex> set = indexingMutexes;
        synchronized (set) {
            return indexingMutexes.contains(mutex);
        }
    }

    static boolean indexExists(Path path) {
        try {
            return Files.exists(path.resolve("timestamp"), new LinkOption[0]) && DirectoryReader.indexExists((Directory)new MMapDirectory(path));
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINER, "Unable to verify index location at " + path, ex);
            return false;
        }
    }

    private ResourceFetcher createFetcher(Wagon wagon, TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) {
        return new WagonFetcher(wagon, listener, authenticationInfo, proxyInfo);
    }

    private static Path getIndexDirectory() {
        return Places.getCacheSubdirectory((String)"mavenindex").toPath();
    }

    static Path getIndexDirectory(RepositoryInfo info) {
        return NexusRepositoryIndexManager.getIndexDirectory().resolve(info.getId());
    }

    private static Path getIndexDirectory(Path cache, RepositoryInfo info) {
        return cache.resolve("mavenindex").resolve(info.getId());
    }

    private static Path getAllGroupCacheFile(RepositoryInfo info) {
        return NexusRepositoryIndexManager.getIndexDirectory(info).resolve("nb-groupcache-all-v1.txt");
    }

    private static Path getRootGroupCacheFile(RepositoryInfo info) {
        return NexusRepositoryIndexManager.getIndexDirectory(info).resolve("nb-groupcache-root-v1.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeGroupCache(RepositoryInfo repo, IndexingContext context) throws IOException {
        Path indexDir = NexusRepositoryIndexManager.getIndexDirectory(repo);
        Path tempAllCache = Files.createTempFile(indexDir, GROUP_CACHE_ALL_PREFIX, "txt", new FileAttribute[0]);
        Path tempRootCache = Files.createTempFile(indexDir, GROUP_CACHE_ROOT_PREFIX, "txt", new FileAttribute[0]);
        try {
            Files.write(tempAllCache, context.getAllGroups(), new OpenOption[0]);
            Files.move(tempAllCache, NexusRepositoryIndexManager.getAllGroupCacheFile(repo), StandardCopyOption.REPLACE_EXISTING);
            Files.write(tempRootCache, context.getRootGroups(), new OpenOption[0]);
            Files.move(tempRootCache, NexusRepositoryIndexManager.getRootGroupCacheFile(repo), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempAllCache);
            Files.deleteIfExists(tempRootCache);
        }
    }

    private static void removeGroupCache(RepositoryInfo repo) throws IOException {
        Files.deleteIfExists(NexusRepositoryIndexManager.getAllGroupCacheFile(repo));
        Files.deleteIfExists(NexusRepositoryIndexManager.getRootGroupCacheFile(repo));
    }

    private static void rebuildGroupCache(RepositoryInfo repo, IndexingContext context) throws IOException {
        NexusRepositoryIndexManager.removeGroupCache(repo);
        (repo.isLocal() ? RP_LOCAL : RP_REMOTE).submit(() -> NexusRepositoryIndexManager.getRepoMutex(repo).writeAccess(() -> {
            Path allGroupsPath = NexusRepositoryIndexManager.getAllGroupCacheFile(repo);
            Path rootGroupsPath = NexusRepositoryIndexManager.getRootGroupCacheFile(repo);
            if (Files.exists(allGroupsPath, new LinkOption[0]) && Files.exists(rootGroupsPath, new LinkOption[0])) {
                return;
            }
            try {
                LOGGER.log(Level.FINE, "Rebuilding group cache for {0}", repo.getId());
                long start = System.currentTimeMillis();
                context.rebuildGroups();
                NexusRepositoryIndexManager.storeGroupCache(repo, context);
                LOGGER.log(Level.INFO, "Group cache rebuilding of {0} took {1}s.", new Object[]{repo.getId(), System.currentTimeMillis() - start});
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to rebuild groups for repo: " + repo.getId(), e);
            }
        }));
    }

    Indexer getIndexer() {
        return this.indexer;
    }

    SearchEngine getSearcher() {
        return this.searcher;
    }

    private static void removeDir(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static long getFreeSpaceInMB(Path path) {
        try {
            return Files.getFileStore(path).getUsableSpace() / 0x100000L;
        }
        catch (IOException ignore) {
            return -1L;
        }
    }

    private static /* synthetic */ void lambda$indexLoadedRepo$10(RepositoryInfo repo) {
        repo.fireIndexChange();
    }

    private static /* synthetic */ void lambda$indexLoadedRepo$9(RepositoryInfo repo) {
        repo.fireNoIndex();
    }

    private static /* synthetic */ boolean lambda$indexLoadedRepo$8(IndexCreator c) {
        return c instanceof NotifyingIndexCreator;
    }

    private static /* synthetic */ boolean lambda$indexLoadedRepo$7(Instant cutoff, Document doc) {
        IndexableField date = doc.getField(MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey());
        return date != null && Instant.ofEpochMilli(Long.parseLong(date.stringValue())).isAfter(cutoff);
    }

    private static /* synthetic */ FSDirectory lambda$indexLoadedRepo$6(File file) throws IOException {
        return MMapDirectory.open((Path)file.toPath());
    }

    private /* synthetic */ Void lambda$loadIndexingContext$1(String repo) throws Exception {
        this.unloadIndexingContext(repo);
        return null;
    }

    private record WagonFetcher(Wagon wagon, TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) implements ResourceFetcher
    {
        public WagonFetcher {
            Objects.requireNonNull(wagon);
            Objects.requireNonNull(listener);
        }

        @Override
        public void connect(String id, String url) throws IOException {
            Repository repository = new Repository(id, url);
            try {
                this.wagon.addTransferListener(this.listener);
                if (this.authenticationInfo != null) {
                    if (this.proxyInfo != null) {
                        this.wagon.connect(repository, this.authenticationInfo, this.proxyInfo);
                    } else {
                        this.wagon.connect(repository, this.authenticationInfo);
                    }
                } else if (this.proxyInfo != null) {
                    this.wagon.connect(repository, this.proxyInfo);
                } else {
                    this.wagon.connect(repository);
                }
            }
            catch (AuthenticationException ex) {
                String msg = "Authentication exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg, ex);
            }
            catch (WagonException ex) {
                String msg = "Wagon exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg, ex);
            }
        }

        @Override
        public void disconnect() throws IOException {
            try {
                this.wagon.disconnect();
            }
            catch (ConnectionException ex) {
                throw new IOException(ex.toString(), ex);
            }
        }

        @Override
        public InputStream retrieve(String name) throws IOException, FileNotFoundException {
            if (NexusRepositoryIndexManager.isDiag()) {
                String id = this.wagon.getRepository().getId();
                if (name.endsWith(".properties") && System.getProperty("maven.diag.index.properties." + id) != null) {
                    LOGGER.log(Level.INFO, "maven indexer will use local properties file: {0}", System.getProperty("maven.diag.index.properties." + id));
                    return new FileInputStream(new File(System.getProperty("maven.diag.index.properties." + id)));
                }
                if (name.endsWith(".gz") && System.getProperty("maven.diag.index.gz." + id) != null) {
                    LOGGER.log(Level.INFO, "maven indexer will use gz file: {0}", System.getProperty("maven.diag.index.gz." + id));
                    return new FileInputStream(new File(System.getProperty("maven.diag.index.gz." + id)));
                }
            }
            final File target = Files.createTempFile("fetcher-" + name, "", new FileAttribute[0]).toFile();
            target.deleteOnExit();
            try {
                this.retrieve(name, target);
            }
            catch (Exception | Cancellation ex) {
                target.delete();
                throw ex;
            }
            return new FileInputStream(target){

                @Override
                public void close() throws IOException {
                    super.close();
                    target.delete();
                }
            };
        }

        public void retrieve(String name, File targetFile) throws IOException {
            try {
                this.wagon.get(name, targetFile);
            }
            catch (AuthorizationException e) {
                targetFile.delete();
                String msg = "Authorization exception retrieving " + name;
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg, e);
            }
            catch (ResourceDoesNotExistException e) {
                targetFile.delete();
                String msg = "Resource " + name + " does not exist";
                this.logError(msg, (Exception)((Object)e));
                FileNotFoundException fileNotFoundException = new FileNotFoundException(msg);
                fileNotFoundException.initCause(e);
                throw fileNotFoundException;
            }
            catch (WagonException e) {
                targetFile.delete();
                String msg = "Transfer for " + name + " failed";
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg + "; " + e.getMessage(), e);
            }
        }

        private void logError(String msg, Exception ex) {
            if (this.listener != null) {
                this.listener.debug(msg + "; " + ex.getMessage());
            }
        }
    }
}

