/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.spi;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class ProjectWebRootQuery {
    private ProjectWebRootQuery() {
    }

    public static FileObject getWebRoot(FileObject file) {
        ProjectWebRootProvider provider;
        if (file == null) {
            throw new NullPointerException("The file paramater cannot be null.");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null && (provider = (ProjectWebRootProvider)project.getLookup().lookup(ProjectWebRootProvider.class)) != null) {
            FileObject root = provider.getWebRoot(file);
            if (root == null) {
                return null;
            }
            return root;
        }
        return null;
    }

    @NonNull
    public static Collection<FileObject> getWebRoots(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ProjectWebRootProvider provider = (ProjectWebRootProvider)project.getLookup().lookup(ProjectWebRootProvider.class);
        if (provider == null) {
            return Collections.emptyList();
        }
        Collection<FileObject> webRoots = provider.getWebRoots();
        assert (webRoots != null) : "WebRoots cannot be null in " + provider.getClass().getName();
        return webRoots;
    }
}

