/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class TryCatchFinally {
    private static final Logger LOG = Logger.getLogger(TryCatchFinally.class.getName());
    public static final boolean DEF_REPORT_RETHROW = true;
    public static final String OPT_REPORT_RETHROW = "reportFinallyRethrow";

    public static List<ErrorDescription> finallyThrowsException(HintContext ctx) {
        Tree.Kind k;
        ArrayList<TreePath> trees = new ArrayList<TreePath>(3);
        ExitsFromBranches efab = new ExitsFromBranches(ctx.getInfo(), true);
        Collection paths = (Collection)ctx.getMultiVariables().get("$handler$");
        CompilationInfo info = ctx.getInfo();
        for (TreePath tp : paths) {
            efab.scan(tp, trees);
        }
        if (trees.isEmpty()) {
            return null;
        }
        TreePath selected = ctx.getPath();
        HashSet<VariableTree> catchVars = new HashSet<VariableTree>();
        for (TreePath parent = ctx.getPath().getParentPath(); parent != null && (k = parent.getLeaf().getKind()) != Tree.Kind.METHOD && k != Tree.Kind.CLASS && k != Tree.Kind.INTERFACE && k != Tree.Kind.ENUM; parent = parent.getParentPath()) {
            if (k != Tree.Kind.CATCH) continue;
            selected = parent;
            catchVars.add(((CatchTree)parent.getLeaf()).getParameter());
            break;
        }
        boolean checkRethrow = ctx.getPreferences().getBoolean(OPT_REPORT_RETHROW, true);
        ArrayList<ErrorDescription> errs = new ArrayList<ErrorDescription>(trees.size());
        if (!checkRethrow) {
            Flow.FlowResult assignments = Flow.assignmentsForUse(ctx.getInfo(), selected, () -> ((HintContext)ctx).isCanceled());
            if (assignments == null || ctx.isCanceled()) {
                return null;
            }
            Iterator it = trees.iterator();
            while (it.hasNext()) {
                TreePath p = (TreePath)it.next();
                Tree stmt = p.getLeaf();
                if (stmt.getKind() != Tree.Kind.THROW) {
                    it.remove();
                    continue;
                }
                ThrowTree tt = (ThrowTree)stmt;
                TreePath tp = new TreePath(p, tt.getExpression());
                ArrayDeque<TreePath> q = new ArrayDeque<TreePath>();
                q.offer(tp);
                boolean rethrow = true;
                Map<Tree, Iterable<? extends TreePath>> ass2Use = assignments.getAssignmentsForUse();
                while (rethrow && !q.isEmpty()) {
                    tp = (TreePath)q.poll();
                    Element el = info.getTrees().getElement(tp);
                    if (el == null) {
                        rethrow = false;
                        break;
                    }
                    if (el.getKind() == ElementKind.EXCEPTION_PARAMETER && el.getModifiers().contains((Object)Modifier.FINAL)) continue;
                    Iterable<? extends TreePath> vals = ass2Use.get(tp.getLeaf());
                    if (vals == null) {
                        rethrow = false;
                        break;
                    }
                    for (TreePath treePath : vals) {
                        if (catchVars.contains(treePath.getLeaf())) continue;
                        q.offer(treePath);
                    }
                }
                if (!rethrow) continue;
                it.remove();
            }
        }
        if (ctx.isCanceled()) {
            return null;
        }
        for (TreePath p : trees) {
            Tree stmt = p.getLeaf();
            errs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)stmt, (String)Bundle.TEXT_throwsInFinallyBlock(), (Fix[])new Fix[0]));
        }
        return errs;
    }

    public static List<ErrorDescription> finallyDiscardsException(HintContext ctx) {
        ArrayList<TreePath> trees = new ArrayList<TreePath>(3);
        ExitsFromBranches efab = new ExitsFromBranches(ctx.getInfo());
        Collection paths = (Collection)ctx.getMultiVariables().get("$handler$");
        for (TreePath tp : paths) {
            efab.scan(tp, trees);
        }
        if (trees.isEmpty()) {
            return null;
        }
        ArrayList<ErrorDescription> errs = new ArrayList<ErrorDescription>(trees.size());
        block6: for (TreePath p : trees) {
            String stmtName;
            Tree stmt = p.getLeaf();
            switch (stmt.getKind()) {
                case CONTINUE: {
                    stmtName = "continue";
                    break;
                }
                case BREAK: {
                    stmtName = "break";
                    break;
                }
                case RETURN: {
                    stmtName = "return";
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unexpected statement kind: {0}", (Object)stmt.getKind());
                    continue block6;
                }
            }
            errs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)stmt, (String)Bundle.TEXT_returnBreakContinueInFinallyBlock(stmtName), (Fix[])new Fix[0]));
        }
        return errs;
    }

    private static final class ExitsFromBranches
    extends ErrorAwareTreePathScanner<Void, Collection<TreePath>> {
        private final boolean analyzeThrows;
        private final CompilationInfo info;
        private final Set<Tree> seenTrees = new HashSet<Tree>();
        private final Stack<Set<TypeMirror>> caughtExceptions = new Stack();

        public ExitsFromBranches(CompilationInfo info, boolean analyzeThrows) {
            this.info = info;
            this.analyzeThrows = analyzeThrows;
        }

        public ExitsFromBranches(CompilationInfo info) {
            this.info = info;
            this.analyzeThrows = false;
        }

        public Void scan(TreePath path, Collection<TreePath> p) {
            this.seenTrees.add(path.getLeaf());
            return (Void)super.scan(path, p);
        }

        public Void scan(Tree tree, Collection<TreePath> trees) {
            this.seenTrees.add(tree);
            return (Void)super.scan(tree, trees);
        }

        public Void visitLabeledStatement(LabeledStatementTree node, Collection<TreePath> p) {
            this.seenTrees.add(node);
            return (Void)super.visitLabeledStatement(node, p);
        }

        public Void visitIf(IfTree node, Collection<TreePath> trees) {
            this.scan((Tree)node.getThenStatement(), trees);
            this.scan((Tree)node.getElseStatement(), trees);
            return null;
        }

        public Void visitReturn(ReturnTree node, Collection<TreePath> trees) {
            if (!this.analyzeThrows) {
                trees.add(this.getCurrentPath());
            }
            return null;
        }

        public Void visitBreak(BreakTree node, Collection<TreePath> trees) {
            if (!this.analyzeThrows && !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                trees.add(this.getCurrentPath());
            }
            return null;
        }

        public Void visitContinue(ContinueTree node, Collection<TreePath> trees) {
            if (!this.analyzeThrows && !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                trees.add(this.getCurrentPath());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void visitTry(TryTree node, Collection<TreePath> trees) {
            HashSet<TypeMirror> caught = new HashSet<TypeMirror>();
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(new TreePath(this.getCurrentPath(), catchTree), catchTree.getParameter()));
                if (t == null) continue;
                caught.add(t);
            }
            this.caughtExceptions.push(caught);
            try {
                this.scan((Tree)node.getBlock(), trees);
            }
            finally {
                this.caughtExceptions.pop();
            }
            this.scan((Tree)node.getFinallyBlock(), trees);
            return null;
        }

        public Void visitThrow(ThrowTree node, Collection<TreePath> trees) {
            if (!this.analyzeThrows) {
                return null;
            }
            TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            boolean isCaught = false;
            block0: for (Set set : this.caughtExceptions) {
                for (TypeMirror c : set) {
                    if (!this.info.getTypes().isSubtype(type, c)) continue;
                    isCaught = true;
                    break block0;
                }
            }
            super.visitThrow(node, trees);
            if (!isCaught) {
                trees.add(this.getCurrentPath());
            }
            return null;
        }
    }
}

