/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot.script;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

final class Sanitizer {
    private static final String[] ALLOWED_GLOBALS = "Object,Function,Array,String,Date,Number,BigInt,Boolean,RegExp,Math,JSON,NaN,Infinity,undefined,isNaN,isFinite,parseFloat,parseInt,encodeURI,encodeURIComponent,decodeURI,decodeURIComponent,eval,escape,unescape,Error,EvalError,RangeError,ReferenceError,SyntaxError,TypeError,URIError,ArrayBuffer,Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array,BigInt64Array,BigUint64Array,DataView,Map,Set,WeakMap,WeakSet,Symbol,Reflect,Proxy,Promise,SharedArrayBuffer,Atomics,console,performance,arguments,load".split(",");

    private Sanitizer() {
    }

    static void clean(ScriptEngine engine) throws ScriptException {
        try {
            Object cleaner = engine.eval("(function(allowed) {\n   var names = Object.getOwnPropertyNames(this);\n   MAIN: for (var i = 0; i < names.length; i++) {\n     for (var j = 0; j < allowed.length; j++) {\n       if (names[i] === allowed[j]) {\n         continue MAIN;\n       }\n     }\n     delete this[names[i]];\n   }\n})");
            ((Invocable)((Object)engine)).invokeMethod(cleaner, "call", null, ALLOWED_GLOBALS);
        }
        catch (NoSuchMethodException ex) {
            throw new ScriptException(ex);
        }
    }

    static void defineAlert(ScriptEngine engine) throws ScriptException {
        try {
            Object defineAlert = engine.eval("(function(out) {\n  this.alert = function(msg) {\n    out.println(msg);\n };});");
            ((Invocable)((Object)engine)).invokeMethod(defineAlert, "call", null, System.out);
        }
        catch (NoSuchMethodException ex) {
            throw new ScriptException(ex);
        }
    }
}

