/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class FileUtilities {
    private static final Logger LOGGER = Logger.getLogger(FileUtilities.class.getName());
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String XHTML_MIME_TYPE = "text/xhtml";
    private static final String CSS_MIME_TYPE = "text/css";
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";

    private FileUtilities() {
    }

    public static boolean isHtmlFile(FileObject file) {
        return FileUtil.getMIMEType((FileObject)file, (String[])new String[]{HTML_MIME_TYPE, XHTML_MIME_TYPE, null}) != null;
    }

    public static boolean isCssFile(FileObject file) {
        return FileUtil.getMIMEType((FileObject)file, (String[])new String[]{CSS_MIME_TYPE, null}) != null;
    }

    public static boolean isJavaScriptFile(FileObject file) {
        return FileUtil.getMIMEType((FileObject)file, (String[])new String[]{JAVASCRIPT_MIME_TYPE, null}) != null;
    }

    public static void cleanupFolder(FileObject fileObject) throws IOException {
        for (FileObject child : fileObject.getChildren()) {
            child.delete();
        }
    }

    @CheckForNull
    public static FileObject lookupSourceFileOnly(Lookup context) {
        Collection fileObjects = context.lookupAll(FileObject.class);
        if (fileObjects.size() != 1) {
            return null;
        }
        FileObject fileObject = (FileObject)fileObjects.iterator().next();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ClientSideProject clientSideProject = (ClientSideProject)project.getLookup().lookup(ClientSideProject.class);
        if (clientSideProject == null) {
            return null;
        }
        FileObject sourcesFolder = clientSideProject.getSourcesFolder();
        if (sourcesFolder == null) {
            return null;
        }
        if (!FileUtil.isParentOf((FileObject)sourcesFolder, (FileObject)fileObject)) {
            return null;
        }
        FileObject siteRootFolder = clientSideProject.getSiteRootFolder();
        if (siteRootFolder != null && FileUtil.isParentOf((FileObject)siteRootFolder, (FileObject)fileObject) && !siteRootFolder.equals(sourcesFolder)) {
            return null;
        }
        FileObject testsFolder = clientSideProject.getTestsFolder(false);
        if (testsFolder != null && FileUtil.isParentOf((FileObject)testsFolder, (FileObject)fileObject)) {
            return null;
        }
        FileObject testsSeleniumFolder = clientSideProject.getTestsSeleniumFolder(false);
        if (testsSeleniumFolder != null && FileUtil.isParentOf((FileObject)testsSeleniumFolder, (FileObject)fileObject)) {
            return null;
        }
        return fileObject;
    }

    public static void moveContent(FileObject source, FileObject target) throws IOException {
        for (FileObject child : source.getChildren()) {
            String newName;
            FileObject newChild = target.getFileObject(child.getNameExt());
            if (newChild == null) {
                FileUtil.moveFile((FileObject)child, (FileObject)target, (String)child.getName());
                continue;
            }
            if (newChild.isFolder()) {
                FileUtilities.moveContent(child, newChild);
                child.delete();
                continue;
            }
            int i = 0;
            while (target.getFileObject(newName = child.getName() + "_" + i++) != null) {
            }
            FileUtil.moveFile((FileObject)child, (FileObject)target, (String)newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnZipEntries(@NonNull File zipFile, @NonNull ZipEntryTask entryTask, @NullAllowed ZipEntryFilter entryFilter) throws IOException {
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                boolean accept = true;
                if (entryFilter != null) {
                    accept = entryFilter.accept(zipEntry);
                }
                if (!accept) continue;
                entryTask.run(zipEntry);
                try (InputStream inputStream = zip.getInputStream(zipEntry);){
                    entryTask.run(inputStream);
                }
            }
        }
    }

    public static List<String> listZipFiles(@NonNull File zipFile, @NonNull ZipEntryFilter entryFilter) throws IOException {
        assert (zipFile != null);
        assert (entryFilter != null);
        final ArrayList<String> files = new ArrayList<String>();
        FileUtilities.runOnZipEntries(zipFile, new ZipEntryTask(){

            @Override
            public void run(ZipEntry zipEntry) {
                files.add(zipEntry.getName());
            }

            @Override
            public void run(InputStream zipEntryInputStream) {
            }
        }, entryFilter);
        return files;
    }

    public static List<String> listJsFilesFromZipFile(File zipFile) {
        try {
            return FileUtilities.listZipFiles(zipFile, new ZipEntryFilter(){

                @Override
                public boolean accept(ZipEntry zipEntry) {
                    return !zipEntry.isDirectory() && zipEntry.getName().toLowerCase().endsWith(".js");
                }
            });
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }

    public static interface ZipEntryTask {
        public void run(ZipEntry var1);

        public void run(InputStream var1);
    }
}

