/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.env.Values;
import org.netbeans.modules.web.clientproject.problems.Bundle;
import org.netbeans.modules.web.clientproject.problems.CustomizerProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ProjectPropertiesProblemProvider
implements ProjectProblemsProvider {
    static final List<String> WATCHED_PROPERTIES = new CopyOnWriteArrayList<String>(Arrays.asList("source.folder", "site.root.folder", "test.folder", "test.selenium.folder"));
    final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final ClientSideProject project;
    private final PropertyChangeListener projectPropertiesListener = new ProjectPropertiesListener();
    private volatile FileChangeListener fileChangesListener = new FileChangesListener();

    private ProjectPropertiesProblemProvider(ClientSideProject project) {
        assert (project != null);
        this.project = project;
    }

    public static ProjectPropertiesProblemProvider createForProject(ClientSideProject project) {
        ProjectPropertiesProblemProvider projectProblems = new ProjectPropertiesProblemProvider(project);
        projectProblems.addProjectPropertiesListeners();
        projectProblems.addFileChangesListeners();
        return projectProblems;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                ProjectPropertiesProblemProvider.this.checkSourceDir(currentProblems);
                ProjectPropertiesProblemProvider.this.checkSiteRootDir(currentProblems);
                ProjectPropertiesProblemProvider.this.checkTestDir(currentProblems);
                ProjectPropertiesProblemProvider.this.checkTestSeleniumDir(currentProblems);
                return currentProblems;
            }
        });
    }

    private void checkSourceDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(this.project.getSourcesFolder(), "source.folder");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidSourceDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidSourceDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "SOURCES", "source.folder"));
            currentProblems.add(problem);
        }
    }

    private void checkSiteRootDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(this.project.getSiteRootFolder(), "site.root.folder");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidSiteRootDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidSiteRootDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "SOURCES", "site.root.folder"));
            currentProblems.add(problem);
        }
    }

    private void checkTestDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(this.project.getTestsFolder(false), "test.folder");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidTestDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidTestDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "SOURCES", "test.folder"));
            currentProblems.add(problem);
        }
    }

    private void checkTestSeleniumDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(this.project.getTestsSeleniumFolder(false), "test.selenium.folder");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidTestSeleniumDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidTestSeleniumDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "SOURCES", "test.selenium.folder"));
            currentProblems.add(problem);
        }
    }

    private File getInvalidDirectory(FileObject directory, String propertyName) {
        assert (WATCHED_PROPERTIES.contains(propertyName)) : "Property '" + propertyName + "' should be watched for changes";
        if (directory != null) {
            if (directory.isValid()) {
                return null;
            }
            return FileUtil.toFile((FileObject)directory);
        }
        File dir = this.resolveFile(propertyName);
        if (dir != null && dir.isDirectory()) {
            return null;
        }
        return dir;
    }

    private File resolveFile(String propertyName) {
        String propValue = this.project.getEvaluator().getProperty(propertyName);
        if (propValue == null) {
            return null;
        }
        return this.project.getProjectHelper().resolveFile(propValue);
    }

    private void addProjectPropertiesListeners() {
        Values evaluator = this.project.getEvaluator();
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.projectPropertiesListener, (Object)evaluator));
    }

    private void addFileChangesListeners() {
        this.addFileChangeListener(this.resolveFile("source.folder"));
        this.addFileChangeListener(this.resolveFile("site.root.folder"));
        this.addFileChangeListener(this.resolveFile("test.folder"));
        this.addFileChangeListener(this.resolveFile("test.selenium.folder"));
    }

    private void addFileChangeListener(File file) {
        if (file == null) {
            return;
        }
        try {
            FileUtil.addFileChangeListener((FileChangeListener)this.fileChangesListener, (File)file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void propertiesChanged() {
        this.fileChangesListener = new FileChangesListener();
        this.addFileChangesListeners();
    }

    private final class ProjectPropertiesListener
    implements PropertyChangeListener {
        private ProjectPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (WATCHED_PROPERTIES.contains(evt.getPropertyName())) {
                ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
                ProjectPropertiesProblemProvider.this.propertiesChanged();
            }
        }
    }

    private final class FileChangesListener
    implements FileChangeListener {
        private FileChangesListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

