/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.breakpoints;

import java.beans.PropertyChangeListener;
import java.net.URL;
import org.netbeans.modules.javascript2.debug.EditorLineHandler;
import org.netbeans.modules.javascript2.debug.EditorLineHandlerFactory;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class TruffleLineBreakpoint
extends JSLineBreakpoint {
    private volatile boolean suspend = true;
    private volatile String printText;

    public TruffleLineBreakpoint(EditorLineHandler lineHandler) {
        super(lineHandler);
    }

    public TruffleLineBreakpoint(URL url, int lineNumber) {
        this(TruffleLineBreakpoint.getEditorLineHandler(url, lineNumber));
    }

    public final boolean isSuspend() {
        return this.suspend;
    }

    public final void setSuspend(boolean suspend) {
        this.suspend = suspend;
    }

    public final String getPrintText() {
        return this.printText;
    }

    public final void setPrintText(String printText) {
        this.printText = printText;
    }

    private static EditorLineHandler getEditorLineHandler(URL url, int lineNumber) {
        Object handler = Lookup.getDefault().lookup(EditorLineHandlerFactory.class) != null ? EditorLineHandlerFactory.getHandler((URL)url, (int)lineNumber) : new FixedLineHandler(url, lineNumber);
        return handler;
    }

    private static final class FixedLineHandler
    implements EditorLineHandler {
        private final URL url;
        private int lineNumber;

        FixedLineHandler(URL url, int lineNumber) {
            this.url = url;
            this.lineNumber = lineNumber;
        }

        public FileObject getFileObject() {
            return URLMapper.findFileObject((URL)this.url);
        }

        public URL getURL() {
            return this.url;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void dispose() {
        }

        public void addPropertyChangeListener(PropertyChangeListener pchl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pchl) {
        }
    }
}

