/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpgradeStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="drgId")
    private final String drgId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="upgradedConnections")
    private final String upgradedConnections;

    @Deprecated
    @ConstructorProperties(value={"drgId", "status", "upgradedConnections"})
    public UpgradeStatus(String drgId, Status status, String upgradedConnections) {
        this.drgId = drgId;
        this.status = status;
        this.upgradedConnections = upgradedConnections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDrgId() {
        return this.drgId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getUpgradedConnections() {
        return this.upgradedConnections;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpgradeStatus(");
        sb.append("super=").append(super.toString());
        sb.append("drgId=").append(String.valueOf(this.drgId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", upgradedConnections=").append(String.valueOf(this.upgradedConnections));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpgradeStatus)) {
            return false;
        }
        UpgradeStatus other = (UpgradeStatus)((Object)o);
        return Objects.equals(this.drgId, other.drgId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.upgradedConnections, other.upgradedConnections) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.upgradedConnections == null ? 43 : this.upgradedConnections.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        NotUpgraded("NOT_UPGRADED"),
        InProgress("IN_PROGRESS"),
        Upgraded("UPGRADED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="drgId")
        private String drgId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="upgradedConnections")
        private String upgradedConnections;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            this.__explicitlySet__.add("drgId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder upgradedConnections(String upgradedConnections) {
            this.upgradedConnections = upgradedConnections;
            this.__explicitlySet__.add("upgradedConnections");
            return this;
        }

        public UpgradeStatus build() {
            UpgradeStatus model = new UpgradeStatus(this.drgId, this.status, this.upgradedConnections);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpgradeStatus model) {
            if (model.wasPropertyExplicitlySet("drgId")) {
                this.drgId(model.getDrgId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("upgradedConnections")) {
                this.upgradedConnections(model.getUpgradedConnections());
            }
            return this;
        }
    }
}

