/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg.toolbar.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.netbeans.modules.svg.SVGViewerElement;
import org.netbeans.modules.svg.toolbar.actions.CustomZoomPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class CustomZoomAction
extends CallableSystemAction {
    static final long serialVersionUID = 8247068408606777895L;

    public void performAction() {
        SVGViewerElement svgViewerElement;
        TopComponent currentComponent = TopComponent.getRegistry().getActivated();
        Lookup tcLookup = currentComponent != null ? currentComponent.getLookup() : null;
        SVGViewerElement sVGViewerElement = svgViewerElement = tcLookup != null ? (SVGViewerElement)tcLookup.lookup(SVGViewerElement.class) : null;
        if (svgViewerElement != null) {
            final Dialog[] dialogs = new Dialog[1];
            final CustomZoomPanel zoomPanel = new CustomZoomPanel();
            zoomPanel.setEnlargeFactor(1);
            zoomPanel.setDecreaseFactor(1);
            DialogDescriptor dd = new DialogDescriptor((Object)zoomPanel, NbBundle.getMessage(CustomZoomAction.class, (String)"LBL_CustomZoomAction"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ev.getSource() == DialogDescriptor.OK_OPTION) {
                        int decreaseFactor;
                        int enlargeFactor;
                        try {
                            enlargeFactor = zoomPanel.getEnlargeFactor();
                            decreaseFactor = zoomPanel.getDecreaseFactor();
                        }
                        catch (NumberFormatException nfe) {
                            this.notifyInvalidInput();
                            return;
                        }
                        if (enlargeFactor == 0 || decreaseFactor == 0) {
                            this.notifyInvalidInput();
                            return;
                        }
                        svgViewerElement.customZoom(enlargeFactor, decreaseFactor);
                        dialogs[0].setVisible(false);
                        dialogs[0].dispose();
                    } else {
                        dialogs[0].setVisible(false);
                        dialogs[0].dispose();
                    }
                }

                private void notifyInvalidInput() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomZoomAction.class, (String)"MSG_InvalidValues"), 0));
                }
            });
            dialogs[0] = DialogDisplayer.getDefault().createDialog(dd);
            dialogs[0].setVisible(true);
        }
    }

    public String getName() {
        return "";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.svg.toolbar.CustomZoomAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/image/customZoom.gif";
    }

    protected boolean asynchronous() {
        return false;
    }
}

