/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf20;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class JsfTagFeatureProvider
implements TagFeatureProvider {
    private static final String VAR = "var";
    private static final String VALUE = "value";

    public <T extends TagFeature> Collection<T> getFeatures(final Tag tag, Library library, Class<T> clazz) {
        IterableTag iterableTag;
        if (clazz.equals(TagFeature.IterableTagPattern.class) && (iterableTag = this.resolveIterableTag(library, tag)) != null) {
            return Collections.singleton((TagFeature)clazz.cast(new TagFeature.IterableTagPattern(){

                public Attribute getVariable() {
                    return tag.getAttribute(iterableTag.getVariableAttribute());
                }

                public Attribute getItems() {
                    return tag.getAttribute(iterableTag.getItemsAttribute());
                }
            }));
        }
        return Collections.emptyList();
    }

    private IterableTag resolveIterableTag(Library library, Tag tag) {
        String libraryNamespace = library.getNamespace();
        if (libraryNamespace == null) {
            return null;
        }
        for (IterableTag iterableTag : IterableTag.values()) {
            if (!iterableTag.getName().equals(tag.getName()) || !libraryNamespace.equals(iterableTag.getLibraryInfo().getNamespace())) continue;
            return iterableTag;
        }
        return null;
    }

    private static enum IterableTag {
        FOR_EACH(DefaultLibraryInfo.JSTL_CORE, "forEach", "items", "var"),
        SELECT_ITEMS(DefaultLibraryInfo.JSF_CORE, "selectItems", "value", "var"),
        SELECT_ITEMS_GROUPS(DefaultLibraryInfo.JSF_CORE, "selectItemGroups", "value", "var"),
        DATA_TABLE(DefaultLibraryInfo.HTML, "dataTable", "value", "var"),
        REPEAT(DefaultLibraryInfo.FACELETS, "repeat", "value", "var");

        private final DefaultLibraryInfo libraryInfo;
        private final String name;
        private final String itemsAttribute;
        private final String variableAttribute;

        private IterableTag(DefaultLibraryInfo libraryInfo, String name, String itemsAttribute, String variableAttribute) {
            this.libraryInfo = libraryInfo;
            this.name = name;
            this.itemsAttribute = itemsAttribute;
            this.variableAttribute = variableAttribute;
        }

        public DefaultLibraryInfo getLibraryInfo() {
            return this.libraryInfo;
        }

        public String getName() {
            return this.name;
        }

        public String getItemsAttribute() {
            return this.itemsAttribute;
        }

        public String getVariableAttribute() {
            return this.variableAttribute;
        }
    }
}

