/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class WebBeansELVariableResolver
implements ELVariableResolver {
    private static final String CONTENT_NAME = "NamedBeans";

    public ELVariableResolver.FieldInfo getInjectableField(String beanName, FileObject target, ResolverContext context) {
        for (WebBean bean : this.getWebBeans(target, context)) {
            if (!beanName.equals(bean.getName())) continue;
            return new ELVariableResolver.FieldInfo(bean.getEnclodingClass(), bean.getBeanClassName());
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject target, ResolverContext context) {
        for (WebBean bean : this.getWebBeans(target, context)) {
            if (!clazz.equals(bean.getBeanClassName())) continue;
            return bean.getName();
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject target, ResolverContext context) {
        List<WebBean> beans = this.getWebBeans(target, context);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(beans.size());
        for (WebBean bean : beans) {
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bean.getName(), (String)bean.getBeanClassName()));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String name, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    private List<WebBean> getWebBeans(FileObject target, ResolverContext context) {
        JsfSupportImpl jsfSupport = JsfSupportImpl.findFor(target);
        if (jsfSupport == null) {
            return Collections.emptyList();
        }
        if (context.getContent(CONTENT_NAME) == null) {
            context.setContent(CONTENT_NAME, WebBeansELVariableResolver.getNamedBeans(jsfSupport.getWebBeansModel()));
        }
        return (List)context.getContent(CONTENT_NAME);
    }

    private static List<WebBean> getNamedBeans(MetadataModel<WebBeansModel> webBeansModel) {
        try {
            return (List)webBeansModel.runReadAction(metadata -> {
                List namedElements = metadata.getNamedElements();
                LinkedList<WebBean> webBeans = new LinkedList<WebBean>();
                for (Element e : namedElements) {
                    if (e == null) continue;
                    webBeans.add(new WebBean(e, metadata.getName(e)));
                }
                return webBeans;
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }

    private static final class WebBean {
        private Element element;
        private String name;

        private WebBean(Element element, String name) {
            this.element = element;
            this.name = name;
        }

        private Element getElement() {
            return this.element;
        }

        public String getBeanClassName() {
            if (this.getElement() instanceof ExecutableElement) {
                ExecutableElement methodElement = (ExecutableElement)this.getElement();
                String returnType = methodElement.getReturnType().toString();
                int genericOffset = returnType.indexOf(60);
                return genericOffset == -1 ? returnType : returnType.substring(0, genericOffset);
            }
            return this.getElement().asType().toString();
        }

        public String getName() {
            return this.name;
        }

        private String getEnclodingClass() {
            if (this.getElement() instanceof ExecutableElement) {
                ExecutableElement methodElement = (ExecutableElement)this.getElement();
                return methodElement.getEnclosingElement().asType().toString();
            }
            return this.getElement().asType().toString();
        }
    }
}

