/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellDebuggerUtils;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchListener;
import org.netbeans.modules.jshell.project.RunOptionsModel;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public final class ShellLaunchManager {
    private static final Logger LOG = Logger.getLogger(ShellLaunchManager.class.getName());
    public static final int HANDSHAKE_TIMEOUT = 1000;
    public static final int CONNECT_TIMEOUT = 5000000;
    private static final RequestProcessor RP = new RequestProcessor("JShell monitor", 5);
    private final Random keyGenerator = new Random(LOG.isLoggable(Level.FINE) ? 0L : System.currentTimeMillis());
    private AtomicInteger sessionKey = new AtomicInteger(1);
    private Selector servers;
    private volatile List<ShellLaunchListener> listeners = new ArrayList<ShellLaunchListener>();
    private final Map<String, ShellAgent> registeredAgents = new HashMap<String, ShellAgent>();
    private Map<Project, Collection<ShellAgent>> projectAgents = new HashMap<Project, Collection<ShellAgent>>();
    private Set<String> usedKeys = new HashSet<String>();
    private final List<ShellAgent> requests = new ArrayList<ShellAgent>();
    private List<WaitForDebuggerStart> uninitializedDebuggers = new ArrayList<WaitForDebuggerStart>();
    private static final int MAX_PROBE_COUNTER = Integer.MAX_VALUE;
    private static final int DEBUGGER_PROBE_DELAY = 200;
    private static final Pattern REGEXP_KEY = Pattern.compile("-javaagent:[^ ]*key=([^,]+)");

    public static ShellLaunchManager getInstance() {
        return (ShellLaunchManager)Lookup.getDefault().lookup(ShellLaunchManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShellAgent openForProject(Project p, boolean debugger) throws IOException {
        String encodedKey;
        boolean shouldInit = false;
        ShellLaunchManager shellLaunchManager = this;
        synchronized (shellLaunchManager) {
            BigInteger key;
            shouldInit = this.usedKeys.isEmpty();
            while (!this.usedKeys.add(encodedKey = (key = BigInteger.probablePrime(64, this.keyGenerator)).toString(36))) {
            }
        }
        if (shouldInit) {
            this.init();
        }
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.configureBlocking(false);
        InetSocketAddress local = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        ssc.bind(local);
        ssc.accept();
        ServerSocket ss = ssc.socket();
        LOG.log(Level.FINE, "Creating new server socket {0} for project: {1}", new Object[]{ss, p});
        ShellAgent agent = new ShellAgent(this, p, ss, encodedKey, debugger);
        Object object = this;
        synchronized (object) {
            this.registeredAgents.put(encodedKey, agent);
        }
        object = this.requests;
        synchronized (object) {
            this.servers.wakeup();
            this.requests.add(agent);
        }
        return agent;
    }

    private void init() throws IOException {
        if (this.servers != null) {
            return;
        }
        LOG.log(Level.FINE, "Initializing");
        this.servers = Selector.open();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)new DebuggerManagerAdapter(){

            public void sessionAdded(Session session) {
                LOG.log(Level.FINE, "Debugger: session added: {0}", session);
                Project p = ShellProjectUtils.getSessionProject(session);
                JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
                RP.post((Runnable)new WaitForDebuggerStart(session, p));
            }
        });
        RP.post((Runnable)new ShellAgentMonitor());
    }

    public void addLaunchListener(ShellLaunchListener l) {
        ArrayList<ShellLaunchListener> ll = new ArrayList<ShellLaunchListener>(this.listeners);
        ll.add(l);
        this.listeners = ll;
    }

    public void removeLaunchListener(ShellLaunchListener l) {
        ArrayList<ShellLaunchListener> ll = new ArrayList<ShellLaunchListener>(this.listeners);
        ll.remove(l);
        this.listeners = ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachInputOutput(String remoteKey, InputOutput out, String displayName) {
        ShellAgent ag;
        Map<String, ShellAgent> map = this.registeredAgents;
        synchronized (map) {
            ag = this.registeredAgents.get(remoteKey);
        }
        if (ag == null) {
            LOG.log(Level.FINE, "Unregistered agent for key: {0}", remoteKey);
        } else {
            ag.setIO(out, displayName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session findWaitingDebugger(String authKey) {
        ArrayList<WaitForDebuggerStart> al;
        List<WaitForDebuggerStart> list = this.uninitializedDebuggers;
        synchronized (list) {
            al = new ArrayList<WaitForDebuggerStart>(this.uninitializedDebuggers);
        }
        for (WaitForDebuggerStart d : al) {
            if (!authKey.equals(d.getKey())) continue;
            List<WaitForDebuggerStart> list2 = this.uninitializedDebuggers;
            synchronized (list2) {
                Session s = d.refSession.get();
                this.uninitializedDebuggers.remove(d);
                return s;
            }
        }
        return null;
    }

    void fire(Consumer<ShellLaunchListener> c) {
        this.listeners.stream().forEach(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAgent(String authKey) {
        ShellAgent agent;
        if (authKey == null || "".equals(authKey)) {
            LOG.log(Level.FINE, "Attempt to destroy unknown agent key: {0}", authKey);
            return;
        }
        LOG.log(Level.FINE, "Unregistering agent for key: {0}", authKey);
        ShellLaunchManager shellLaunchManager = this;
        synchronized (shellLaunchManager) {
            agent = this.registeredAgents.remove(authKey);
            if (agent == null) {
                return;
            }
        }
        try {
            agent.destroy();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Java Shell agent shut down unsuccessfully:", ex);
        }
        ShellLaunchEvent ev = new ShellLaunchEvent(this, agent);
        this.fire(l -> l.agentDestroyed(ev));
    }

    static void queueTask(Runnable run, int delay) {
        RP.post(run);
    }

    public static String getAuthKey(String args) {
        if (args == null) {
            return null;
        }
        Matcher m = REGEXP_KEY.matcher(args);
        return m.find() ? m.group(1) : null;
    }

    public static List<String> buildLocalJVMAgentArgs(JavaPlatform platform, ShellAgent agent, Function<String, String> propertyEvaluator) {
        String s;
        String method;
        String field;
        String clazz;
        InetSocketAddress isa = agent.getHandshakeAddress();
        File agentJar = InstalledFileLocator.getDefault().locate("modules/ext/nb-custom-jshell-probe.jar", "org.netbeans.lib.jshell.agent", false);
        String policy = propertyEvaluator.apply("jshell.run.classloader");
        if (policy == null) {
            policy = RunOptionsModel.LoaderPolicy.SYSTEM.toString().toLowerCase();
        }
        if ((clazz = propertyEvaluator.apply("jshell.classloader.from.class")) == null) {
            clazz = "";
        }
        if ((field = propertyEvaluator.apply("jshell.classloader.from.field")) == null) {
            field = "";
        }
        if ((method = propertyEvaluator.apply("jshell.classloader.from.method")) == null) {
            method = "";
        }
        String executor = propertyEvaluator.apply("jshell.executor");
        String arg = String.format("-javaagent:%1$s=address=%2$s,port=%3$d,key=%4$s,loaderPolicy=%5$s,class=%6$s,field=%7$s,method=%8$s", agentJar.toPath().toString(), isa.getHostString(), isa.getPort(), agent.getAuthorizationKey(), policy, clazz, field, method);
        ArrayList<String> args = new ArrayList<String>();
        if (executor != null) {
            args.add("-Dorg.netbeans.lib.jshell.agent.AgentWorker.executor=" + executor);
        }
        if ((s = System.getProperty("jshell.logging.properties")) != null) {
            args.add("-Djava.util.logging.config.file=" + s);
        }
        args.add(arg);
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ShellAgent> getLiveAgents(Project filter) {
        ArrayList<ShellAgent> ret;
        ShellLaunchManager shellLaunchManager = this;
        synchronized (shellLaunchManager) {
            ret = new ArrayList<ShellAgent>(this.registeredAgents.values());
        }
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            ShellAgent a = (ShellAgent)it.next();
            if (a.isReady() && (filter == null || filter == a.getProject())) continue;
            it.remove();
        }
        return ret;
    }

    private class ShellAgentMonitor
    implements Runnable {
        private ShellAgentMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block17: while (true) {
                        List<ShellAgent> list = ShellLaunchManager.this.requests;
                        synchronized (list) {
                            for (ShellAgent a : ShellLaunchManager.this.requests) {
                                ServerSocketChannel ssc = a.getHandshakeSocket().getChannel();
                                try {
                                    ssc.register(ShellLaunchManager.this.servers, 16, a);
                                }
                                catch (IOException | IllegalStateException exception) {}
                            }
                        }
                        ShellLaunchManager.this.servers.select();
                        Set<SelectionKey> keys = ShellLaunchManager.this.servers.selectedKeys();
                        Iterator<SelectionKey> it = keys.iterator();
                        while (true) {
                            SelectionKey k;
                            if (!it.hasNext() || !(k = it.next()).isValid()) continue block17;
                            if (k.isAcceptable()) {
                                try {
                                    SocketChannel ss = ((ServerSocketChannel)k.channel()).accept();
                                    try {
                                        if (ss == null) continue;
                                        LOG.fine("Accepted socket " + ss);
                                        this.processHandshake(ss);
                                    }
                                    finally {
                                        if (ss == null) continue;
                                        ss.close();
                                        continue;
                                    }
                                }
                                catch (IOException ex) {
                                    LOG.log(Level.INFO, "Error during Java Shell agent handshake", ex);
                                }
                            }
                            it.remove();
                        }
                        break;
                    }
                }
                catch (ClosedSelectorException ex) {
                    LOG.fine("Selector closed");
                }
                catch (IOException | RuntimeException ex) {
                    LOG.log(Level.FINE, "Error occurred during connection handling", ex);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processHandshake(SocketChannel accepted) throws IOException {
            ShellAgent agent;
            accepted.configureBlocking(true);
            Socket sock = accepted.socket();
            sock.setSoTimeout(1000);
            ObjectInputStream is = new ObjectInputStream(sock.getInputStream());
            String authorizationKey = is.readUTF();
            LOG.log(Level.FINE, "Approaching agent with authorization key: {0}", authorizationKey);
            ShellLaunchManager shellLaunchManager = ShellLaunchManager.this;
            synchronized (shellLaunchManager) {
                agent = ShellLaunchManager.this.registeredAgents.get(authorizationKey);
            }
            if (agent == null) {
                LOG.log(Level.INFO, "Connection on Java Shell agent port with improper authorization ({0}) from {1}", new Object[]{authorizationKey, sock});
                return;
            }
            int targetPort = is.readInt();
            InetSocketAddress connectTo = new InetSocketAddress(((InetSocketAddress)sock.getRemoteSocketAddress()).getAddress(), targetPort);
            agent.target(connectTo);
        }
    }

    private class WaitForDebuggerStart
    implements Runnable,
    PropertyChangeListener {
        final Reference<Session> refSession;
        final Project project;
        int probeCounter;
        boolean stop;
        volatile String readKey;

        public WaitForDebuggerStart(Session session, Project project) {
            this.refSession = new WeakReference<Session>(session);
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            ShellLaunchManager shellLaunchManager = ShellLaunchManager.this;
            synchronized (shellLaunchManager) {
                ShellLaunchManager.this.uninitializedDebuggers.remove(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDADebugger deb = (JPDADebugger)evt.getSource();
            if (deb != null && deb.getState() == 4) {
                deb.removePropertyChangeListener((PropertyChangeListener)this);
                this.stop();
            }
        }

        @Override
        public void run() {
            LOG.log(Level.FINE, "Tick at {0}", System.currentTimeMillis());
            Session session = this.refSession.get();
            if (this.stop || session == null) {
                this.stop();
                return;
            }
            JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                this.stop();
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
            if (debugger.getState() == 4) {
                LOG.log(Level.FINE, "debugge has disconnected: {0}", session);
                this.stop();
                return;
            }
            try {
                if (this.probeCounter == 0) {
                    this.waitVirtualMachine(debugger, session);
                } else if (this.probeCounter >= Integer.MAX_VALUE) {
                    LOG.log(Level.FINE, "Max probe count reached for debugger session {0}", session);
                    this.stop();
                    return;
                }
                if (this.probe(debugger, session)) {
                    RP.schedule((Runnable)this, 200L, TimeUnit.MILLISECONDS);
                    ++this.probeCounter;
                }
            }
            catch (DebuggerStartException ex) {
                LOG.log(Level.FINE, "Exception during debugger start: {0}", ex);
                this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitVirtualMachine(JPDADebugger debugger, Session session) throws DebuggerStartException {
            LOG.log(Level.FINE, "Waiting for debugger to create VM for project {0} in thread {1}", new Object[]{this.project, Thread.currentThread()});
            debugger.waitRunning();
            VirtualMachine vm = ((JPDADebuggerImpl)debugger).getVirtualMachine();
            LOG.log(Level.FINE, "Debugger VirtualMachine created for project {0} in thread {1}", new Object[]{this.project, Thread.currentThread()});
            ShellLaunchManager shellLaunchManager = ShellLaunchManager.this;
            synchronized (shellLaunchManager) {
                ShellLaunchManager.this.uninitializedDebuggers.add(this);
            }
        }

        public String getKey() {
            if (this.readKey != null) {
                return this.readKey;
            }
            Session s = this.refSession.get();
            if (s == null) {
                return null;
            }
            this.readKey = ShellDebuggerUtils.getAgentKey(s);
            return this.readKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean probe(JPDADebugger debugger, Session session) {
            ShellAgent agent;
            String key = this.getKey();
            if (key == null) {
                LOG.log(Level.FINE, "NB Java Shell Agent did not execute far enough; queueing until the agent connects back");
                return true;
            }
            if ("".equals(key)) {
                return false;
            }
            LOG.log(Level.FINE, "Authentication key acquired from JDI: {0}", key);
            this.readKey = key;
            ShellLaunchManager shellLaunchManager = ShellLaunchManager.this;
            synchronized (shellLaunchManager) {
                agent = ShellLaunchManager.this.registeredAgents.get(key);
                if (agent == null) {
                    LOG.log(Level.FINE, "Could not find agent matching key: {0}", key);
                    return false;
                }
            }
            shellLaunchManager = ShellLaunchManager.this;
            synchronized (shellLaunchManager) {
                ShellLaunchManager.this.uninitializedDebuggers.remove(this);
            }
            agent.attachDebugger(session);
            return false;
        }
    }
}

