/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ui.util.ValidateablePanel;
import org.netbeans.modules.nativeexecution.api.util.Authentication;
import org.netbeans.modules.nativeexecution.api.util.AuthenticationUtils;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.support.ui.api.FileSelectorField;
import org.netbeans.modules.nativeexecution.ui.SSHKeyFileChooser;
import org.netbeans.modules.nativeexecution.ui.SSHKeyFileCompletionProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class AuthenticationSettingsPanel
extends ValidateablePanel {
    private final ExecutionEnvironment env;
    private final RequestProcessor.Task validationTask;
    private String problem;
    private final Authentication auth;
    private final AuthenticationListModel authListModel;
    private JPanel authPanel;
    private JList<AuthenticationCheckboxListItem> authenticationsList;
    private ButtonGroup buttonGroup1;
    private JCheckBox connectionSettings;
    private JPanel connectionSettingsPanel;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JButton keyBrowseButton;
    private JTextField keyFileFld;
    private JRadioButton keyRadioButton;
    private JLabel loginLabel;
    private JPanel loginPanel;
    private JLabel preferredAuthenticationsLabel;
    private JButton pwdClearButton;
    private JRadioButton pwdRadioButton;
    private JLabel pwdStoredLbl;
    private JLabel timeoutLabel;
    private JSpinner timeoutSpinner;
    private JButton upButton;
    private static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());

    public AuthenticationSettingsPanel(Authentication auth, boolean showClearPwdButton) {
        this.env = auth.getEnv();
        this.auth = auth;
        this.initComponents();
        this.pwdClearButton.setVisible(showClearPwdButton);
        this.pwdStoredLbl.setVisible(showClearPwdButton);
        if (this.env != null) {
            this.loginLabel.setText(this.env.getUser() + "@" + this.env.getHost() + (this.env.getSSHPort() == 22 ? "" : Integer.valueOf(this.env.getSSHPort())));
        } else {
            this.loginPanel.setVisible(false);
        }
        if (auth.getType() == Authentication.Type.SSH_KEY) {
            this.keyRadioButton.setSelected(true);
            this.pwdRadioButton.setSelected(false);
        } else {
            this.keyRadioButton.setSelected(false);
            this.pwdRadioButton.setSelected(true);
        }
        this.keyFileFld.setText(auth.getSSHKeyFile());
        if (this.env != null) {
            boolean stored = PasswordManager.getInstance().isRememberPassword(this.env);
            this.pwdClearButton.setEnabled(stored);
            this.pwdStoredLbl.setVisible(stored);
        }
        this.validationTask = new RequestProcessor("", 1).create((Runnable)new ValidationTask(), true);
        this.keyFileFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AuthenticationSettingsPanel.this.validationTask.schedule(0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AuthenticationSettingsPanel.this.validationTask.schedule(0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AuthenticationSettingsPanel.this.validationTask.schedule(0);
            }
        });
        this.connectionSettingsPanel.setVisible(false);
        this.connectionSettings.setSelected(false);
        this.connectionSettings.setIcon(AuthenticationSettingsPanel.getCollapsedIcon());
        this.authListModel = new AuthenticationListModel(auth.getAuthenticationMethods());
        this.authenticationsList.setModel(this.authListModel);
        this.authenticationsList.setCellRenderer(new AuthentificationCheckboxListRenderer());
        this.authenticationsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index != -1) {
                    Rectangle checkBounds = ((AuthentificationCheckboxListRenderer)list.getCellRenderer()).check.getBounds();
                    if (event.getPoint().x <= checkBounds.width) {
                        AuthenticationCheckboxListItem item;
                        item.setSelected(!(item = (AuthenticationCheckboxListItem)list.getModel().getElementAt(index)).isSelected());
                        list.repaint(list.getCellBounds(index, index));
                    }
                }
            }
        });
        this.authenticationsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AuthenticationCheckboxListItem item;
                if (e.getKeyChar() == ' ' && (item = (AuthenticationCheckboxListItem)AuthenticationSettingsPanel.this.authenticationsList.getSelectedValue()) != null) {
                    int index = AuthenticationSettingsPanel.this.authenticationsList.getSelectedIndex();
                    item.setSelected(!item.isSelected());
                    AuthenticationSettingsPanel.this.authenticationsList.repaint(AuthenticationSettingsPanel.this.authenticationsList.getCellBounds(index, index));
                }
            }
        });
        this.authenticationsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = AuthenticationSettingsPanel.this.authenticationsList.getSelectedIndex();
                if (index == -1) {
                    AuthenticationSettingsPanel.this.upButton.setEnabled(false);
                    AuthenticationSettingsPanel.this.downButton.setEnabled(false);
                    return;
                }
                if (index >= 0 && index < AuthenticationSettingsPanel.this.authListModel.getSize() - 1) {
                    AuthenticationSettingsPanel.this.downButton.setEnabled(true);
                } else {
                    AuthenticationSettingsPanel.this.downButton.setEnabled(false);
                }
                if (index >= 1 && index < AuthenticationSettingsPanel.this.authListModel.getSize()) {
                    AuthenticationSettingsPanel.this.upButton.setEnabled(true);
                } else {
                    AuthenticationSettingsPanel.this.upButton.setEnabled(false);
                }
            }
        });
        this.timeoutSpinner.setModel(new SpinnerNumberModel(auth.getTimeout(), 1, 500, 1));
        this.timeoutSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Number number = ((SpinnerNumberModel)AuthenticationSettingsPanel.this.timeoutSpinner.getModel()).getNumber();
                AuthenticationSettingsPanel.this.auth.setTimeout(number.intValue());
            }
        });
        this.enableControls();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.pwdRadioButton.setEnabled(enabled);
        this.keyRadioButton.setEnabled(enabled);
        this.enableKeyField();
    }

    private void resetAuthentificationListModel(Authentication.MethodList methods) {
        this.authListModel.resetModel(methods);
        this.authenticationsList.clearSelection();
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.authenticationsList.repaint(this.authenticationsList.getCellBounds(0, this.authListModel.getSize() - 1));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.loginPanel = new JPanel();
        this.loginLabel = new JLabel();
        this.authPanel = new JPanel();
        this.pwdRadioButton = new JRadioButton();
        this.pwdStoredLbl = new JLabel();
        this.pwdClearButton = new JButton();
        this.keyRadioButton = new JRadioButton();
        this.keyFileFld = Utilities.isWindows() ? new JTextField() : new FileSelectorField(new SSHKeyFileCompletionProvider());
        this.keyBrowseButton = new JButton();
        this.connectionSettings = new JCheckBox();
        this.connectionSettingsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.authenticationsList = new JList();
        this.downButton = new JButton();
        this.preferredAuthenticationsLabel = new JLabel();
        this.upButton = new JButton();
        this.timeoutLabel = new JLabel();
        this.timeoutSpinner = new JSpinner();
        this.loginPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.loginPanel.border.title")));
        this.loginLabel.setText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.loginLabel.text"));
        GroupLayout loginPanelLayout = new GroupLayout(this.loginPanel);
        this.loginPanel.setLayout(loginPanelLayout);
        loginPanelLayout.setHorizontalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loginLabel).addContainerGap(-1, Short.MAX_VALUE)));
        loginPanelLayout.setVerticalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginPanelLayout.createSequentialGroup().addComponent(this.loginLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.authPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.authPanel.border.title")));
        this.buttonGroup1.add(this.pwdRadioButton);
        this.pwdRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.pwdRadioButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.pwdRadioButton.text"));
        this.pwdRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.pwdRadioButtonActionPerformed(evt);
            }
        });
        this.pwdStoredLbl.setText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.pwdStoredLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.pwdClearButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.pwdClearButton.text_1"));
        this.pwdClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.pwdClearButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.keyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.keyRadioButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.keyRadioButton.text"));
        this.keyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.keyRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.keyBrowseButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.keyBrowseButton.text_1"));
        this.keyBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.keyBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.connectionSettings, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.connectionSettings.text"));
        this.connectionSettings.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.connectionSettings.toolTipText"));
        this.connectionSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.connectionSettingsActionPerformed(evt);
            }
        });
        this.authenticationsList.setSelectionMode(0);
        this.authenticationsList.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.authenticationsList.toolTipText"));
        this.jScrollPane1.setViewportView(this.authenticationsList);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.downButton.text"));
        this.downButton.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.downButton.toolTipText"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.downButtonActionPerformed(evt);
            }
        });
        this.preferredAuthenticationsLabel.setLabelFor(this.authenticationsList);
        Mnemonics.setLocalizedText((JLabel)this.preferredAuthenticationsLabel, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.preferredAuthenticationsLabel.text"));
        this.preferredAuthenticationsLabel.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.preferredAuthenticationsLabel.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.upButton.text"));
        this.upButton.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.upButton.toolTipText"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.timeoutLabel.setLabelFor(this.timeoutSpinner);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutLabel.text"));
        this.timeoutLabel.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutLabel.toolTipText"));
        this.timeoutSpinner.setToolTipText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutSpinner.toolTipText"));
        GroupLayout connectionSettingsPanelLayout = new GroupLayout(this.connectionSettingsPanel);
        this.connectionSettingsPanel.setLayout(connectionSettingsPanelLayout);
        connectionSettingsPanelLayout.setHorizontalGroup(connectionSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionSettingsPanelLayout.createSequentialGroup().addComponent(this.preferredAuthenticationsLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(connectionSettingsPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(18, 18, 18).addGroup(connectionSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.upButton, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE))).addGroup(connectionSettingsPanelLayout.createSequentialGroup().addComponent(this.timeoutLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeoutSpinner, -2, 72, -2).addGap(0, 0, Short.MAX_VALUE)));
        connectionSettingsPanelLayout.setVerticalGroup(connectionSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionSettingsPanelLayout.createSequentialGroup().addComponent(this.preferredAuthenticationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectionSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionSettingsPanelLayout.createSequentialGroup().addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addGroup(connectionSettingsPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane1, -2, 109, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectionSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutLabel).addComponent(this.timeoutSpinner, -2, -1, -2)).addGap(0, 12, Short.MAX_VALUE)));
        this.downButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.downButton.AccessibleContext.accessibleName"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.downButton.AccessibleContext.accessibleDescription"));
        this.preferredAuthenticationsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.preferredAuthenticationsLabel.AccessibleContext.accessibleName"));
        this.preferredAuthenticationsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.preferredAuthenticationsLabel.AccessibleContext.accessibleDescription"));
        this.upButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.upButton.AccessibleContext.accessibleName"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.upButton.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutSpinner.AccessibleContext.accessibleName"));
        this.timeoutSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.timeoutSpinner.AccessibleContext.accessibleDescription"));
        GroupLayout authPanelLayout = new GroupLayout(this.authPanel);
        this.authPanel.setLayout(authPanelLayout);
        authPanelLayout.setHorizontalGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authPanelLayout.createSequentialGroup().addContainerGap().addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(authPanelLayout.createSequentialGroup().addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authPanelLayout.createSequentialGroup().addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pwdRadioButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.keyRadioButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authPanelLayout.createSequentialGroup().addGap(184, 184, 184).addComponent(this.pwdStoredLbl, -1, 63, Short.MAX_VALUE)).addGroup(authPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.keyFileFld)))).addComponent(this.connectionSettings, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.pwdClearButton, -1, -1, Short.MAX_VALUE).addComponent(this.keyBrowseButton, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        authPanelLayout.setVerticalGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authPanelLayout.createSequentialGroup().addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pwdRadioButton).addComponent(this.pwdClearButton).addComponent(this.pwdStoredLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyRadioButton).addComponent(this.keyBrowseButton).addComponent(this.keyFileFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionSettingsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.connectionSettings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.connectionSettings.AccessibleContext.accessibleName"));
        this.connectionSettings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.connectionSettings.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.authPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loginPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authPanel, -2, -1, -2)));
    }

    private void keyRadioButtonActionPerformed(ActionEvent evt) {
        this.resetAuthentificationListModel(Authentication.SSH_KEY_METHODS);
        this.enableControls();
        this.keyFileFld.requestFocus();
    }

    private void pwdClearButtonActionPerformed(ActionEvent evt) {
        PasswordManager.getInstance().forceClearPassword(this.env);
        this.pwdStoredLbl.setVisible(false);
        this.pwdClearButton.setEnabled(false);
    }

    private void keyBrowseButtonActionPerformed(ActionEvent evt) {
        SSHKeyFileChooser chooser = new SSHKeyFileChooser(this.keyFileFld.getText());
        int result = chooser.showOpenDialog(this);
        if (0 == result) {
            this.keyFileFld.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void pwdRadioButtonActionPerformed(ActionEvent evt) {
        this.resetAuthentificationListModel(Authentication.PASSWORD_METHODS);
        this.enableControls();
    }

    private void connectionSettingsActionPerformed(ActionEvent evt) {
        this.connectionSettingsPanel.setVisible(this.connectionSettings.isSelected());
        this.connectionSettings.setIcon(this.connectionSettings.isSelected() ? AuthenticationSettingsPanel.getExpandedIcon() : AuthenticationSettingsPanel.getCollapsedIcon());
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.authenticationsList.getSelectedIndex();
        if (selectedIndex <= 0) {
            return;
        }
        this.authListModel.swapElement(selectedIndex, selectedIndex - 1);
        this.authenticationsList.repaint(this.authenticationsList.getCellBounds(selectedIndex - 1, selectedIndex));
        this.authenticationsList.setSelectedIndex(selectedIndex - 1);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.authenticationsList.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= this.authListModel.getSize() - 1) {
            return;
        }
        this.authListModel.swapElement(selectedIndex, selectedIndex + 1);
        this.authenticationsList.repaint(this.authenticationsList.getCellBounds(selectedIndex, selectedIndex + 1));
        this.authenticationsList.setSelectedIndex(selectedIndex + 1);
    }

    private void enableControls() {
        this.enableKeyField();
        this.validationTask.schedule(0);
    }

    private void enableKeyField() {
        this.enableKeyField(this.authListModel.hasPublicKey());
    }

    private void enableKeyField(boolean enable) {
        this.keyFileFld.setEnabled(enable);
        this.keyBrowseButton.setEnabled(enable);
    }

    @Override
    public boolean hasProblem() {
        return this.problem != null;
    }

    @Override
    public String getProblem() {
        return this.problem;
    }

    @Override
    public void applyChanges(Object customData) {
        if (customData instanceof ExecutionEnvironment) {
            ExecutionEnvironment e = (ExecutionEnvironment)customData;
            Authentication a = Authentication.getFor((ExecutionEnvironment)e);
            a.setTimeout(this.auth.getTimeout());
            this.authListModel.storeAuthenticationMethods(this.auth);
            a.setAuthenticationMethods(this.auth.getAuthenticationMethods());
            if (this.auth.getType() == Authentication.Type.SSH_KEY) {
                a.setSSHKeyFile(this.auth.getSSHKeyFile());
            } else {
                a.setPassword();
            }
            a.store();
            AuthenticationUtils.changeAuth((ExecutionEnvironment)e, (Authentication)a);
        } else if (this.env != null) {
            this.authListModel.storeAuthenticationMethods(this.auth);
            this.auth.store();
            AuthenticationUtils.changeAuth((ExecutionEnvironment)this.env, (Authentication)this.auth);
        }
    }

    static Icon getExpandedIcon() {
        return UIManager.getIcon(isGtk ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon");
    }

    static Icon getCollapsedIcon() {
        return UIManager.getIcon(isGtk ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon");
    }

    private final class AuthenticationListModel
    extends AbstractListModel<AuthenticationCheckboxListItem> {
        private final ArrayList<AuthenticationCheckboxListItem> list = new ArrayList(4);

        private AuthenticationListModel(Authentication.MethodList methodsList) {
            if (methodsList == null || methodsList.isEmpty()) {
                this.resetModel(Authentication.DEFAULT_METHODS);
            } else {
                this.resetModel(methodsList);
            }
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public boolean isEmpty() {
            for (AuthenticationCheckboxListItem item : this.list) {
                if (!item.isSelected) continue;
                return false;
            }
            return true;
        }

        @Override
        public AuthenticationCheckboxListItem getElementAt(int index) {
            return this.list.get(index);
        }

        public void swapElement(int from, int to) {
            AuthenticationCheckboxListItem fromItem = this.list.get(from);
            this.list.set(from, this.list.get(to));
            this.list.set(to, fromItem);
        }

        public boolean hasPublicKey() {
            for (AuthenticationCheckboxListItem item : this.list) {
                if (!item.isSelected || !item.method.hasKeyFile()) continue;
                return true;
            }
            return false;
        }

        public void resetModel(Authentication.MethodList methodsList) {
            Authentication.Method[] methods = methodsList.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Authentication.Method method = methods[i];
                boolean enabled = methodsList.isEnabled(method);
                AuthenticationCheckboxListItem authenticationCheckboxListItem = new AuthenticationCheckboxListItem(method, enabled);
                if (i == this.list.size()) {
                    this.list.add(authenticationCheckboxListItem);
                    continue;
                }
                this.list.set(i, authenticationCheckboxListItem);
            }
        }

        private Authentication.MethodList toMethodList() {
            ArrayList<Pair> pairs = new ArrayList<Pair>();
            for (int i = 0; i < this.list.size(); ++i) {
                AuthenticationCheckboxListItem m = this.list.get(i);
                pairs.add(Pair.of((Object)m.method, (Object)m.isSelected));
            }
            return new Authentication.MethodList(pairs);
        }

        public void storeAuthenticationMethods(Authentication auth) {
            auth.setAuthenticationMethods(this.toMethodList());
        }
    }

    private class ValidationTask
    implements Runnable {
        private ValidationTask() {
        }

        @Override
        public void run() {
            this.validate();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AuthenticationSettingsPanel.this.fireChange();
                }
            });
        }

        private boolean validate() {
            AuthenticationSettingsPanel.this.authListModel.storeAuthenticationMethods(AuthenticationSettingsPanel.this.auth);
            if (AuthenticationSettingsPanel.this.authListModel.hasPublicKey()) {
                AuthenticationSettingsPanel.this.keyRadioButton.setSelected(true);
            } else {
                AuthenticationSettingsPanel.this.pwdRadioButton.setSelected(true);
            }
            if (AuthenticationSettingsPanel.this.authListModel.isEmpty()) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.emptyMethodList.text");
                return false;
            }
            boolean needskeyFile = AuthenticationSettingsPanel.this.authListModel.hasPublicKey();
            if (!needskeyFile) {
                AuthenticationSettingsPanel.this.problem = null;
                AuthenticationSettingsPanel.this.auth.setPassword();
                return true;
            }
            String keyFile = AuthenticationSettingsPanel.this.keyFileFld.getText();
            if (keyFile.length() == 0) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.emptyKey.text");
                return false;
            }
            File file = new File(keyFile);
            if (file.isDirectory()) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.isDirectory.text", (Object)keyFile);
                return false;
            }
            if (!file.exists()) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.fileNotFound.text", (Object)keyFile);
                return false;
            }
            if (!file.canRead()) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.fileNotReadable.text", (Object)keyFile);
                return false;
            }
            if (!Authentication.isValidSSHKeyFile((String)file.getAbsolutePath())) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.invalidKey.text", (Object)keyFile);
                return false;
            }
            AuthenticationSettingsPanel.this.auth.setSSHKeyFile(file.getAbsolutePath());
            AuthenticationSettingsPanel.this.problem = null;
            return true;
        }
    }

    private static class AuthentificationCheckboxListRenderer
    extends JPanel
    implements ListCellRenderer<AuthenticationCheckboxListItem> {
        private final JCheckBox check;
        private final JLabel label;
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final Border focusBorder = new EtchedBorder();

        private AuthentificationCheckboxListRenderer() {
            this.check = new JCheckBox();
            this.label = new JLabel();
            this.setLayout(new BorderLayout());
            this.add((Component)this.check, "West");
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AuthenticationCheckboxListItem> list, AuthenticationCheckboxListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fc;
            Color bc;
            if (isSelected) {
                bc = UIManager.getColor("List.selectionBackground");
                fc = UIManager.getColor("List.selectionForeground");
            } else {
                bc = list.getBackground();
                fc = list.getForeground();
            }
            this.setBackground(bc);
            this.setForeground(fc);
            this.label.setBackground(bc);
            this.label.setForeground(fc);
            this.label.setText(value.getDisplayName());
            this.label.setFont(list.getFont());
            this.check.setSelected(value.isSelected());
            this.check.setBackground(bc);
            this.check.setForeground(fc);
            this.check.setEnabled(list.isEnabled());
            Border border = cellHasFocus ? this.focusBorder : this.noFocusBorder;
            this.setBorder(border);
            return this;
        }
    }

    private class AuthenticationCheckboxListItem {
        private final Authentication.Method method;
        private boolean isSelected;

        public AuthenticationCheckboxListItem(Authentication.Method method, boolean selected) {
            this.method = method;
            this.isSelected = selected;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
            if (this.method.hasKeyFile()) {
                AuthenticationSettingsPanel.this.enableKeyField(isSelected);
            }
            AuthenticationSettingsPanel.this.validationTask.schedule(0);
        }

        public String getDisplayName() {
            return this.method.getDisplayName();
        }

        public String toString() {
            return this.method.toString() + ' ' + this.isSelected;
        }

        public Pair<Authentication.Method, Boolean> toPair() {
            return Pair.of((Object)this.method, (Object)this.isSelected);
        }
    }
}

