/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.create;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class TestCreator {
    private static final Logger LOGGER = Logger.getLogger(TestCreator.class.getName());
    private final PhpModule phpModule;

    public TestCreator(PhpModule phpModule) {
        this.phpModule = phpModule;
    }

    public CreateTestsResult createTests(List<FileObject> files) {
        HashSet<FileObject> failed = new HashSet<FileObject>();
        HashSet<FileObject> succeeded = new HashSet<FileObject>();
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        assert (sourceDirectory != null) : "Source directory should exist for " + this.phpModule;
        FileObject template = FileUtil.getConfigFile((String)"Templates/Scripting/Tests/AtoumTest.php");
        assert (template != null);
        for (FileObject fo : files) {
            try {
                this.generateTest(sourceDirectory, template, fo, succeeded);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                failed.add(fo);
            }
        }
        return new CreateTestsResult(succeeded, failed);
    }

    private void generateTest(FileObject sourceDirectory, FileObject template, FileObject fo, Set<FileObject> succeeded) throws IOException {
        FileObject testDirectory = this.phpModule.getTestDirectory(fo);
        assert (testDirectory != null);
        FileObject dir = this.getTargetFolder(sourceDirectory, testDirectory, fo);
        String name = fo.getName();
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject newTest = dataTemplate.createFromTemplate(dataFolder, name, this.getTemplateParams(name));
        succeeded.add(newTest.getPrimaryFile());
    }

    private FileObject getTargetFolder(FileObject sourceDirectory, FileObject testDirectory, FileObject fo) throws IOException {
        FileObject commonRoot = FileUtils.getCommonRoot((FileObject)fo, (FileObject)testDirectory);
        if (commonRoot == null || !FileUtil.isParentOf((FileObject)sourceDirectory, (FileObject)commonRoot)) {
            commonRoot = sourceDirectory;
        }
        assert (commonRoot != null);
        String relativePath = FileUtil.getRelativePath((FileObject)commonRoot, (FileObject)fo.getParent());
        assert (relativePath != null) : "Dir " + commonRoot + " must be parent of " + fo;
        FileObject target = testDirectory.getFileObject(relativePath);
        if (target == null) {
            target = FileUtil.createFolder((FileObject)testDirectory, (String)relativePath);
        }
        return target;
    }

    private Map<String, ? extends Object> getTemplateParams(String name) {
        return Collections.singletonMap("name", name);
    }
}

