/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JFXProjectConfigurations {
    private static final Logger LOG = Logger.getLogger(JFXProjectConfigurations.class.getName());
    public static final String APPLICATION_ARGS = "application.args";
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final String APP_PARAM_PREFIX = "javafx.param.";
    public static final String[] APP_PARAM_SUFFIXES = new String[]{"name", "value", "hidden"};
    public static final String APP_PARAM_CONNECT_SIGN = "=";
    public static final String APP_MANIFEST_PREFIX = "javafx.manifest.entry.";
    public static final String[] APP_MANIFEST_SUFFIXES = new String[]{"name", "value", "hidden"};
    public static final String APP_MANIFEST_CONNECT_SIGN = ": ";
    private static final String MULTI_PROPERTY_STRING = "MultiProperty";
    private static final String MULTI_PROPERTY_EMPTY = "empty";
    public static final String APP_MULTIPROP_HIDDEN_TRUE = "true";
    public static final String PROJECT_CONFIGS_DIR = "nbproject/configs";
    public static final String PROJECT_PRIVATE_CONFIGS_DIR = "nbproject/private/configs";
    public static final String PROPERTIES_FILE_EXT = "properties";
    public static final String CONFIG_PROPERTIES_FILE = "nbproject/private/config.properties";
    private Map<String, Map<String, String>> RUN_CONFIGS;
    private MultiProperty appParams;
    private MultiProperty appManifestEntries;
    private Set<String> ERASED_CONFIGS;
    private BoundedPropertyGroups groups = new BoundedPropertyGroups();
    private String active;
    private FileObject projectDir;
    private List<String> PROJECT_PROPERTIES = new ArrayList<String>();
    private List<String> PRIVATE_PROPERTIES = new ArrayList<String>();
    private List<String> STATIC_PROPERTIES = new ArrayList<String>();
    private Map<String, String> DEFAULT_IF_MISSING = new HashMap<String, String>();
    private List<String> CLEAN_EMPTY_PROJECT_PROPERTIES = new ArrayList<String>();
    private List<String> CLEAN_EMPTY_PRIVATE_PROPERTIES = new ArrayList<String>();

    public static String getSharedConfigFilePath(@NonNull String config) {
        return "nbproject/configs/" + config + "." + PROPERTIES_FILE_EXT;
    }

    public static String getPrivateConfigFilePath(@NonNull String config) {
        return "nbproject/private/configs/" + config + "." + PROPERTIES_FILE_EXT;
    }

    private Comparator<String> getComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        };
    }

    JFXProjectConfigurations(@NonNull FileObject projectDirFO) {
        this.projectDir = projectDirFO;
        this.reset();
    }

    public void registerProjectProperties(String[] props) {
        if (props != null) {
            this.PROJECT_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerPrivateProperties(String[] props) {
        if (props != null) {
            this.PRIVATE_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerStaticProperties(String[] props) {
        if (props != null) {
            this.STATIC_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerDefaultsIfMissing(Map<String, String> defaults) {
        if (defaults != null) {
            this.DEFAULT_IF_MISSING.putAll(defaults);
        }
    }

    public void registerCleanEmptyProjectProperties(String[] props) {
        if (props != null) {
            this.CLEAN_EMPTY_PROJECT_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerCleanEmptyPrivateProperties(String[] props) {
        if (props != null) {
            this.CLEAN_EMPTY_PRIVATE_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void resetProjectProperties() {
        this.PROJECT_PROPERTIES.clear();
    }

    public void resetPrivateProperties() {
        this.PRIVATE_PROPERTIES.clear();
    }

    public void resetStaticProperties() {
        this.STATIC_PROPERTIES.clear();
    }

    public void resetDefaultsIfMissing() {
        this.DEFAULT_IF_MISSING.clear();
    }

    public void resetCleanEmptyProjectProperties() {
        this.CLEAN_EMPTY_PROJECT_PROPERTIES.clear();
    }

    public void resetCleanEmptyPrivateProperties() {
        this.CLEAN_EMPTY_PRIVATE_PROPERTIES.clear();
    }

    public void reset() {
        this.RUN_CONFIGS = new TreeMap<String, Map<String, String>>(this.getComparator());
        this.ERASED_CONFIGS = null;
        this.appParams = new MultiProperty(APP_PARAM_PREFIX, APP_PARAM_SUFFIXES, APP_PARAM_CONNECT_SIGN);
        this.appManifestEntries = new MultiProperty(APP_MANIFEST_PREFIX, APP_MANIFEST_SUFFIXES, APP_MANIFEST_CONNECT_SIGN);
    }

    private boolean configNameWrong(String config) {
        return config != null && config.contains(DEFAULT_CONFIG_NAME);
    }

    public final void defineGroup(String groupName, Collection<String> props) {
        this.groups.defineGroup(groupName, props);
    }

    public final void clearGroup(String groupName) {
        this.groups.clearGroup(groupName);
    }

    public final void clearAllGroups() {
        this.groups.clearAllGroups();
    }

    public boolean isBound(String prop) {
        return this.groups.isBound(prop);
    }

    public Collection<String> getBoundedProperties(String prop) {
        return this.groups.getBoundedProperties(prop);
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String config) {
        assert (!this.configNameWrong(config));
        this.active = config;
    }

    public boolean hasConfig(String config) {
        assert (!this.configNameWrong(config));
        return this.RUN_CONFIGS.containsKey(config);
    }

    public boolean isConfigEmpty(String config) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            return configMap.isEmpty();
        }
        return true;
    }

    public boolean isDefaultConfigEmpty() {
        return this.isConfigEmpty(null);
    }

    public boolean isActiveConfigEmpty() {
        return this.isConfigEmpty(this.getActive());
    }

    public Set<String> getConfigNames() {
        return Collections.unmodifiableSet(this.RUN_CONFIGS.keySet());
    }

    private Map<String, String> getConfigUnmodifyable(String config) {
        assert (!this.configNameWrong(config));
        return Collections.unmodifiableMap(this.RUN_CONFIGS.get(config));
    }

    private Map<String, String> getDefaultConfigUnmodifyable() {
        return this.getConfigUnmodifyable(null);
    }

    private Map<String, String> getActiveConfigUnmodifyable() {
        return this.getConfigUnmodifyable(this.getActive());
    }

    private Map<String, String> getConfig(String config) {
        assert (!this.configNameWrong(config));
        return this.RUN_CONFIGS.get(config);
    }

    private Map<String, String> getDefaultConfig() {
        return this.getConfig(null);
    }

    private Map<String, String> getActiveConfig() {
        return this.getConfig(this.getActive());
    }

    private Map<String, String> getConfigNonNull(String config) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap == null) {
            configMap = new TreeMap<String, String>(this.getComparator());
            this.RUN_CONFIGS.put(config, configMap);
        }
        return configMap;
    }

    private Map<String, String> getDefaultConfigNonNull() {
        return this.getConfigNonNull(null);
    }

    private Map<String, String> getActiveConfigNonNull() {
        return this.getConfigNonNull(this.getActive());
    }

    public void addToConfig(String config, Map<String, String> props) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap == null) {
            configMap = new TreeMap<String, String>(this.getComparator());
            this.RUN_CONFIGS.put(config, configMap);
        }
        configMap.putAll(props);
    }

    public void addToDefaultConfig(Map<String, String> props) {
        this.addToConfig(null, props);
    }

    public void addToActiveConfig(Map<String, String> props) {
        this.addToConfig(this.getActive(), props);
    }

    public void addToConfig(String config, EditableProperties props) {
        assert (!this.configNameWrong(config));
        this.addToConfig(config, new HashMap<String, String>((Map<String, String>)props));
    }

    public void addToDefaultConfig(EditableProperties props) {
        this.addToConfig(null, props);
    }

    public void addToActiveConfig(EditableProperties props) {
        this.addToConfig(this.getActive(), props);
    }

    public void eraseConfig(String config) {
        assert (!this.configNameWrong(config));
        assert (config != null);
        this.RUN_CONFIGS.remove(config);
        if (this.ERASED_CONFIGS == null) {
            this.ERASED_CONFIGS = new HashSet<String>();
        }
        this.ERASED_CONFIGS.add(config);
    }

    public boolean isPropertySet(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            return configMap.containsKey(prop);
        }
        return false;
    }

    public boolean isDefaultPropertySet(@NonNull String prop) {
        return this.isPropertySet(null, prop);
    }

    public boolean isActivePropertySet(@NonNull String prop) {
        return this.isPropertySet(this.getActive(), prop);
    }

    private boolean isBoundedToNonemptyProperty(String config, String prop) {
        assert (!this.configNameWrong(config));
        for (String name : this.groups.getBoundedProperties(prop)) {
            if (!this.isPropertySet(config, name)) continue;
            return true;
        }
        return false;
    }

    public String getProperty(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            return configMap.get(prop);
        }
        return null;
    }

    public String getDefaultProperty(@NonNull String prop) {
        return this.getProperty(null, prop);
    }

    public String getActiveProperty(@NonNull String prop) {
        return this.getProperty(this.getActive(), prop);
    }

    public String getPropertyTransparent(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        String value = null;
        if (configMap != null && (value = configMap.get(prop)) == null && config != null) {
            return this.getDefaultProperty(prop);
        }
        return value;
    }

    public String getActivePropertyTransparent(@NonNull String prop) {
        return this.getPropertyTransparent(this.getActive(), prop);
    }

    public void setProperty(String config, @NonNull String prop, String value) {
        this.setPropertyImpl(config, prop, value);
        this.solidifyBoundedGroups(config, prop);
        if (config == null) {
            for (String c : this.getConfigNames()) {
                if (c == null || !JFXProjectProperties.isEqualText(this.getProperty(c, prop), value) || this.STATIC_PROPERTIES.contains(prop) || !this.isBoundedPropertiesEraseable(c, prop)) continue;
                this.eraseProperty(c, prop);
            }
        }
    }

    private void setPropertyImpl(String config, @NonNull String prop, String value) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfigNonNull(config);
        configMap.put(prop, value);
    }

    public void setDefaultProperty(@NonNull String prop, String value) {
        this.setProperty(null, prop, value);
    }

    public void setActiveProperty(@NonNull String prop, String value) {
        this.setProperty(this.getActive(), prop, value);
    }

    public void setPropertyTransparent(String config, @NonNull String prop, String value) {
        assert (!this.configNameWrong(config));
        if (config != null && JFXProjectProperties.isEqualText(this.getDefaultProperty(prop), value) && (!this.STATIC_PROPERTIES.contains(prop) || !this.isPropertySet(config, prop)) && this.isBoundedPropertiesEraseable(config, prop)) {
            this.eraseProperty(config, prop);
        } else {
            this.setProperty(config, prop, value);
        }
    }

    public void setActivePropertyTransparent(@NonNull String prop, String value) {
        this.setPropertyTransparent(this.getActive(), prop, value);
    }

    public boolean solidifyProperty(String config, @NonNull String prop) {
        if (!this.isPropertySet(config, prop)) {
            if (config != null) {
                this.setPropertyImpl(config, prop, this.getDefaultProperty(prop));
            } else {
                this.setPropertyImpl(null, prop, "");
            }
            return true;
        }
        return false;
    }

    private boolean solidifyBoundedGroups(String config, @NonNull String prop) {
        boolean solidified = false;
        for (String name : this.groups.getBoundedProperties(prop)) {
            solidified |= this.solidifyProperty(config, name);
        }
        return solidified;
    }

    public void eraseProperty(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            configMap.remove(prop);
            configMap.keySet().removeAll(this.groups.getBoundedProperties(prop));
        }
    }

    public void eraseDefaultProperty(@NonNull String prop) {
        this.eraseProperty(null, prop);
    }

    public void eraseActiveProperty(@NonNull String prop) {
        this.eraseProperty(this.getActive(), prop);
    }

    private boolean isBoundedPropertiesEraseable(String config, String prop) {
        assert (!this.configNameWrong(config));
        if (config == null) {
            return false;
        }
        boolean canErase = true;
        for (String name : this.groups.getBoundedProperties(prop)) {
            if ((!this.isPropertySet(config, name) || JFXProjectProperties.isEqualText(this.getDefaultProperty(name), this.getProperty(config, name))) && !this.STATIC_PROPERTIES.contains(name)) continue;
            canErase = false;
            break;
        }
        return canErase;
    }

    public boolean hasParamTransparent(String config, @NonNull String name) {
        return this.appParams.hasEntryTransparent(config, name);
    }

    public boolean hasDefaultParamTransparent(@NonNull String name) {
        return this.appParams.hasDefaultEntryTransparent(name);
    }

    public boolean hasActiveParamTransparent(@NonNull String name) {
        return this.appParams.hasActiveEntryTransparent(name);
    }

    public boolean hasParamTransparent(String config, @NonNull String name, @NonNull String value) {
        return this.appParams.hasEntryTransparent(config, name, value);
    }

    public boolean hasDefaultParamTransparent(@NonNull String name, @NonNull String value) {
        return this.appParams.hasDefaultEntryTransparent(name, value);
    }

    public boolean hasActiveParamTransparent(@NonNull String name, @NonNull String value) {
        return this.appParams.hasActiveEntryTransparent(name, value);
    }

    public boolean hasParamValueTransparent(String config, @NonNull String name) {
        return this.appParams.hasEntryValueTransparent(config, name);
    }

    public boolean hasDefaultParamValueTransparent(@NonNull String name) {
        return this.appParams.hasDefaultEntryValueTransparent(name);
    }

    public boolean hasActiveParamValueTransparent(@NonNull String name) {
        return this.appParams.hasActiveEntryValueTransparent(name);
    }

    public Map<String, String> getParamTransparent(String config, @NonNull String name) {
        return this.appParams.getEntryTransparent(config, name);
    }

    public Map<String, String> getDefaultParamTransparent(@NonNull String name) {
        return this.appParams.getDefaultEntryTransparent(name);
    }

    public Map<String, String> getActiveParamTransparent(@NonNull String name) {
        return this.appParams.getActiveEntryTransparent(name);
    }

    public String getParamValueTransparent(String config, @NonNull String name) {
        return this.appParams.getEntryValueTransparent(config, name);
    }

    public String getDefaultParamValueTransparent(@NonNull String name) {
        return this.appParams.getDefaultEntryValueTransparent(name);
    }

    public String getActiveParamValueTransparent(@NonNull String name) {
        return this.appParams.getActiveEntryValueTransparent(name);
    }

    public List<Map<String, String>> getParamsTransparent(String config) {
        return this.appParams.getEntriesTransparent(config);
    }

    public List<Map<String, String>> getDefaultParamsTransparent() {
        return this.appParams.getDefaultEntriesTransparent();
    }

    public List<Map<String, String>> getActiveParamsTransparent() {
        return this.appParams.getActiveEntriesTransparent();
    }

    public void addParamTransparent(String config, @NonNull String name) {
        this.appParams.addEntryTransparent(config, name);
    }

    public void addDefaultParamTransparent(@NonNull String name) {
        this.appParams.addDefaultEntryTransparent(name);
    }

    public void addActiveParamTransparent(@NonNull String name) {
        this.appParams.addActiveEntryTransparent(name);
    }

    public void addParamTransparent(String config, @NonNull String name, @NonNull String value) {
        this.appParams.addEntryTransparent(config, name, value);
    }

    public void addDefaultParamTransparent(@NonNull String name, @NonNull String value) {
        this.appParams.addDefaultEntryTransparent(name, value);
    }

    public void addActiveParamTransparent(@NonNull String name, @NonNull String value) {
        this.appParams.addActiveEntryTransparent(name, value);
    }

    public void setParamsTransparent(String config, List<Map<String, String>> params) {
        this.appParams.setEntriesTransparent(config, params);
    }

    public void setDefaultParamsTransparent(List<Map<String, String>> params) {
        this.appParams.setDefaultEntriesTransparent(params);
    }

    public void setActiveParamsTransparent(List<Map<String, String>> params) {
        this.appParams.setActiveEntriesTransparent(params);
    }

    public void eraseParamTransparent(String config, @NonNull String name) {
        this.appParams.eraseEntryTransparent(config, name);
    }

    public void eraseDefaultParamTransparent(@NonNull String name) {
        this.appParams.eraseDefaultEntryTransparent(name);
    }

    public void eraseActiveParamTransparent(@NonNull String name) {
        this.appParams.eraseActiveEntryTransparent(name);
    }

    public void eraseParamsTransparent(String config) {
        this.appParams.eraseEntriesTransparent(config);
    }

    public void eraseDefaultParamsTransparent() {
        this.appParams.eraseDefaultEntriesTransparent();
    }

    public void eraseActiveParamsTransparent() {
        this.appParams.eraseActiveEntriesTransparent();
    }

    public String getParamsTransparentAsString(String config, boolean commandLine) {
        return this.appParams.getEntriesTransparentAsString(config, commandLine);
    }

    public String getDefaultParamsTransparentAsString(boolean commandLine) {
        return this.appParams.getDefaultEntriesTransparentAsString(commandLine);
    }

    public String getActiveParamsTransparentAsString(boolean commandLine) {
        return this.appParams.getActiveEntriesTransparentAsString(commandLine);
    }

    public boolean hasActiveParam(@NonNull String name) {
        return this.appParams.hasActiveEntry(name);
    }

    public String paramsToString() {
        return this.appParams.toString();
    }

    public String getParamsAsString(String config, boolean commandLine) {
        return this.appParams.getEntriesAsString(config, commandLine);
    }

    public String getDefaultParamsAsString(boolean commandLine) {
        return this.appParams.getDefaultEntriesAsString(commandLine);
    }

    public String getActiveParamsAsString(boolean commandLine) {
        return this.appParams.getActiveEntriesAsString(commandLine);
    }

    public boolean hasManifestEntryTransparent(String config, @NonNull String name) {
        return this.appManifestEntries.hasEntryTransparent(config, name);
    }

    public boolean hasDefaultManifestEntryTransparent(@NonNull String name) {
        return this.appManifestEntries.hasDefaultEntryTransparent(name);
    }

    public boolean hasActiveManifestEntryTransparent(@NonNull String name) {
        return this.appManifestEntries.hasActiveEntryTransparent(name);
    }

    public boolean hasManifestEntryTransparent(String config, @NonNull String name, @NonNull String value) {
        return this.appManifestEntries.hasEntryTransparent(config, name, value);
    }

    public boolean hasDefaultManifestEntryTransparent(@NonNull String name, @NonNull String value) {
        return this.appManifestEntries.hasDefaultEntryTransparent(name, value);
    }

    public boolean hasActiveManifestEntryTransparent(@NonNull String name, @NonNull String value) {
        return this.appManifestEntries.hasActiveEntryTransparent(name, value);
    }

    public boolean hasManifestEntryValueTransparent(String config, @NonNull String name) {
        return this.appManifestEntries.hasEntryValueTransparent(config, name);
    }

    public boolean hasDefaultManifestEntryValueTransparent(@NonNull String name) {
        return this.appManifestEntries.hasDefaultEntryValueTransparent(name);
    }

    public boolean hasActiveManifestEntryValueTransparent(@NonNull String name) {
        return this.appManifestEntries.hasActiveEntryValueTransparent(name);
    }

    public Map<String, String> getManifestEntryTransparent(String config, @NonNull String name) {
        return this.appManifestEntries.getEntryTransparent(config, name);
    }

    public Map<String, String> getDefaultManifestEntryTransparent(@NonNull String name) {
        return this.appManifestEntries.getDefaultEntryTransparent(name);
    }

    public Map<String, String> getActiveManifestEntryTransparent(@NonNull String name) {
        return this.appManifestEntries.getActiveEntryTransparent(name);
    }

    public String getManifestEntryValueTransparent(String config, @NonNull String name) {
        return this.appManifestEntries.getEntryValueTransparent(config, name);
    }

    public String getDefaultManifestEntryValueTransparent(@NonNull String name) {
        return this.appManifestEntries.getDefaultEntryValueTransparent(name);
    }

    public String getActiveManifestEntryValueTransparent(@NonNull String name) {
        return this.appManifestEntries.getActiveEntryValueTransparent(name);
    }

    public List<Map<String, String>> getManifestEntriesTransparent(String config) {
        return this.appManifestEntries.getEntriesTransparent(config);
    }

    public List<Map<String, String>> getDefaultManifestEntriesTransparent() {
        return this.appManifestEntries.getDefaultEntriesTransparent();
    }

    public List<Map<String, String>> getActiveManifestEntriesTransparent() {
        return this.appManifestEntries.getActiveEntriesTransparent();
    }

    public void addManifestEntryTransparent(String config, @NonNull String name) {
        this.appManifestEntries.addEntryTransparent(config, name);
    }

    public void addDefaultManifestEntryTransparent(@NonNull String name) {
        this.appManifestEntries.addDefaultEntryTransparent(name);
    }

    public void addActiveManifestEntryTransparent(@NonNull String name) {
        this.appManifestEntries.addActiveEntryTransparent(name);
    }

    public void addManifestEntryTransparent(String config, @NonNull String name, @NonNull String value) {
        this.appManifestEntries.addEntryTransparent(config, name, value);
    }

    public void addDefaultManifestEntryTransparent(@NonNull String name, @NonNull String value) {
        this.appManifestEntries.addDefaultEntryTransparent(name, value);
    }

    public void addActiveManifestEntryTransparent(@NonNull String name, @NonNull String value) {
        this.appManifestEntries.addActiveEntryTransparent(name, value);
    }

    public void setManifestEntriesTransparent(String config, List<Map<String, String>> params) {
        this.appManifestEntries.setEntriesTransparent(config, params);
    }

    public void setDefaultManifestEntriesTransparent(List<Map<String, String>> params) {
        this.appManifestEntries.setDefaultEntriesTransparent(params);
    }

    public void setActiveManifestEntriesTransparent(List<Map<String, String>> params) {
        this.appManifestEntries.setActiveEntriesTransparent(params);
    }

    public void eraseManifestEntryTransparent(String config, @NonNull String name) {
        this.appManifestEntries.eraseEntryTransparent(config, name);
    }

    public void eraseDefaultManifestEntryTransparent(@NonNull String name) {
        this.appManifestEntries.eraseDefaultEntryTransparent(name);
    }

    public void eraseActiveManifestEntryTransparent(@NonNull String name) {
        this.appManifestEntries.eraseActiveEntryTransparent(name);
    }

    public void eraseManifestEntriesTransparent(String config) {
        this.appManifestEntries.eraseEntriesTransparent(config);
    }

    public void eraseDefaultManifestEntriesTransparent() {
        this.appManifestEntries.eraseDefaultEntriesTransparent();
    }

    public void eraseActiveManifestEntriesTransparent() {
        this.appManifestEntries.eraseActiveEntriesTransparent();
    }

    public String getManifestEntriesTransparentAsString(String config) {
        return this.appManifestEntries.getEntriesTransparentAsString(config, false);
    }

    public String getDefaultManifestEntriesTransparentAsString() {
        return this.appManifestEntries.getDefaultEntriesTransparentAsString(false);
    }

    public String getActiveManifestEntriesTransparentAsString() {
        return this.appManifestEntries.getActiveEntriesTransparentAsString(false);
    }

    public boolean hasActiveManifestEntry(@NonNull String name) {
        return this.appManifestEntries.hasActiveEntry(name);
    }

    public String manifestEntriesToString() {
        return this.appManifestEntries.toString();
    }

    public int getNoOfManifestEntries(String config) {
        return this.appManifestEntries.getNoOfEntries(config);
    }

    public int getNoOfDefaultManifestEntries() {
        return this.appManifestEntries.getNoOfDefaultEntries();
    }

    public int getNoOfActiveManifestEntries() {
        return this.appManifestEntries.getNoOfActiveEntries();
    }

    public void read() {
        this.reset();
        this.readDefaultConfig("nbproject/project.properties");
        this.readDefaultConfig("nbproject/private/private.properties");
        this.addDefaultsIfMissing();
        this.readNonDefaultConfigs(PROJECT_CONFIGS_DIR, true);
        this.readNonDefaultConfigs(PROJECT_PRIVATE_CONFIGS_DIR, false);
    }

    private void readDefaultConfig(String propsFile) {
        EditableProperties ep = null;
        try {
            ep = JFXProjectUtils.readFromFile(this.projectDir, propsFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ep != null) {
            for (String prop : this.PROJECT_PROPERTIES) {
                String v = ep.getProperty(prop);
                if (v == null) continue;
                this.setDefaultProperty(prop, v);
            }
        }
        this.appParams.extractDefaultEntries(ep);
        this.appManifestEntries.extractDefaultEntries(ep);
    }

    private void addDefaultsIfMissing() {
        for (String prop : this.DEFAULT_IF_MISSING.keySet()) {
            if (this.isDefaultPropertySet(prop)) continue;
            this.setDefaultProperty(prop, this.DEFAULT_IF_MISSING.get(prop));
        }
    }

    private void readNonDefaultConfigs(String subDir, boolean createIfNotExists) {
        FileObject configsFO = this.projectDir.getFileObject(subDir);
        if (configsFO != null) {
            for (FileObject kid : configsFO.getChildren()) {
                Map<String, String> c;
                if (!kid.hasExt(PROPERTIES_FILE_EXT) || (c = this.getConfig(kid.getName())) == null && !createIfNotExists) continue;
                EditableProperties cep = null;
                try {
                    cep = JFXProjectUtils.readFromFile(kid);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.addToConfig(kid.getName(), cep);
                this.appParams.extractEntries(cep, kid.getName());
                this.appManifestEntries.extractEntries(cep, kid.getName());
            }
        }
    }

    public void readActive() {
        try {
            this.setActive(JFXProjectUtils.readFromFile(this.projectDir, CONFIG_PROPERTIES_FILE).getProperty("config"));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to read active configuration from {0}.", CONFIG_PROPERTIES_FILE);
        }
    }

    public void storeActive() throws IOException {
        String configPath = CONFIG_PROPERTIES_FILE;
        if (this.active == null) {
            try {
                JFXProjectUtils.deleteFile(this.projectDir, configPath);
            }
            catch (IOException iOException) {}
        } else {
            EditableProperties configProps = JFXProjectUtils.readFromFile(this.projectDir, configPath);
            configProps.setProperty("config", this.active);
            JFXProjectUtils.saveToFile(this.projectDir, configPath, configProps);
        }
    }

    private boolean storeParamsAsCommandLine(String config, EditableProperties projectProperties) {
        assert (!this.configNameWrong(config));
        String params = this.appParams.getEntriesTransparentAsString(config, true, true);
        if (config != null && JFXProjectProperties.isEqualText(params, this.appParams.getDefaultEntriesAsString(true, true))) {
            params = null;
        }
        if (!Utilities.compareObjects((Object)params, (Object)projectProperties.getProperty(APPLICATION_ARGS))) {
            if (params != null && params.length() > 0) {
                projectProperties.setProperty(APPLICATION_ARGS, params);
                projectProperties.setComment(APPLICATION_ARGS, new String[]{"# " + NbBundle.getMessage(JFXProjectConfigurations.class, (String)"COMMENT_app_args")}, false);
            } else {
                projectProperties.remove((Object)APPLICATION_ARGS);
            }
            return true;
        }
        return false;
    }

    private boolean storeDefaultParamsAsCommandLine(EditableProperties projectProperties) {
        return this.storeParamsAsCommandLine(null, projectProperties);
    }

    public void store(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        for (String name : this.PROJECT_PROPERTIES) {
            String value = this.getDefaultProperty(name);
            this.updateProperty(name, value, projectProperties, privateProperties, this.isBoundedToNonemptyProperty(null, name));
        }
        ArrayList paramNamesUsed = new ArrayList();
        ArrayList manifestEntryNamesUsed = new ArrayList();
        this.appParams.updateDefaultEntryProperties(projectProperties, privateProperties, paramNamesUsed);
        this.appManifestEntries.updateDefaultEntryProperties(projectProperties, privateProperties, manifestEntryNamesUsed);
        this.storeDefaultParamsAsCommandLine(privateProperties);
        for (Map.Entry<String, Map<String, String>> entry : this.RUN_CONFIGS.entrySet()) {
            String config = entry.getKey();
            if (config == null) continue;
            String sharedPath = JFXProjectConfigurations.getSharedConfigFilePath(config);
            String privatePath = JFXProjectConfigurations.getPrivateConfigFilePath(config);
            Map<String, String> configProps = entry.getValue();
            if (configProps == null) {
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, sharedPath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", sharedPath);
                }
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, privatePath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", privatePath);
                }
                continue;
            }
            EditableProperties sharedCfgProps = JFXProjectUtils.readFromFile(this.projectDir, sharedPath);
            EditableProperties privateCfgProps = JFXProjectUtils.readFromFile(this.projectDir, privatePath);
            boolean privatePropsChanged = false;
            for (Map.Entry<String, String> prop : configProps.entrySet()) {
                String name = prop.getKey();
                String value = prop.getValue();
                String defaultValue = this.getDefaultProperty(name);
                boolean storeIfEmpty = defaultValue != null && defaultValue.length() > 0 || this.isBoundedToNonemptyProperty(config, name);
                privatePropsChanged |= this.updateProperty(name, value, sharedCfgProps, privateCfgProps, storeIfEmpty);
            }
            this.cleanPropertiesIfEmpty(this.CLEAN_EMPTY_PROJECT_PROPERTIES.toArray(new String[0]), config, sharedCfgProps);
            privatePropsChanged |= this.cleanPropertiesIfEmpty(this.CLEAN_EMPTY_PRIVATE_PROPERTIES.toArray(new String[0]), config, privateCfgProps);
            privatePropsChanged |= this.appParams.updateEntryProperties(config, sharedCfgProps, privateCfgProps, paramNamesUsed);
            privatePropsChanged |= this.appManifestEntries.updateEntryProperties(config, sharedCfgProps, privateCfgProps, manifestEntryNamesUsed);
            JFXProjectUtils.saveToFile(this.projectDir, sharedPath, sharedCfgProps);
            if (!(privatePropsChanged |= this.storeParamsAsCommandLine(config, privateCfgProps))) continue;
            JFXProjectUtils.saveToFile(this.projectDir, privatePath, privateCfgProps);
        }
        if (this.ERASED_CONFIGS != null) {
            for (String string : this.ERASED_CONFIGS) {
                if (this.RUN_CONFIGS.containsKey(string)) continue;
                String sharedPath = JFXProjectConfigurations.getSharedConfigFilePath(string);
                String privatePath = JFXProjectConfigurations.getPrivateConfigFilePath(string);
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, sharedPath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", sharedPath);
                }
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, privatePath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", privatePath);
                }
            }
        }
    }

    private boolean updateProperty(@NonNull String name, String value, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, boolean storeEmpty) {
        EditableProperties ep;
        boolean changePrivate = this.PRIVATE_PROPERTIES.contains(name) || privateProperties.containsKey((Object)name);
        EditableProperties editableProperties = ep = changePrivate ? privateProperties : projectProperties;
        if (changePrivate) {
            projectProperties.remove((Object)name);
        }
        if (!Utilities.compareObjects((Object)value, (Object)ep.getProperty(name))) {
            if (value != null && (value.length() > 0 || storeEmpty)) {
                ep.setProperty(name, value);
            } else {
                ep.remove((Object)name);
            }
            return changePrivate;
        }
        return false;
    }

    private boolean updateProperty(@NonNull String name, String value, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties) {
        return this.updateProperty(name, value, projectProperties, privateProperties, false);
    }

    private boolean cleanPropertyIfEmpty(@NonNull String name, String config, @NonNull EditableProperties ep) {
        if (!this.isPropertySet(config, name)) {
            ep.remove((Object)name);
            return true;
        }
        return false;
    }

    private boolean cleanPropertiesIfEmpty(@NonNull String[] names, String config, @NonNull EditableProperties ep) {
        boolean updated = false;
        for (String name : names) {
            updated |= this.cleanPropertyIfEmpty(name, config, ep);
        }
        return updated;
    }

    private class BoundedPropertyGroups {
        Map<String, Set<String>> groups = new HashMap<String, Set<String>>();

        private BoundedPropertyGroups() {
        }

        public void defineGroup(String groupName, Collection<String> props) {
            HashSet<String> group = new HashSet<String>();
            group.addAll(props);
            this.groups.put(groupName, group);
        }

        public void clearGroup(String groupName) {
            this.groups.remove(groupName);
        }

        public void clearAllGroups() {
            this.groups.clear();
        }

        public boolean isBound(String prop) {
            for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                Set<String> group = entry.getValue();
                if (group == null || !group.contains(prop) || group.size() <= 1) continue;
                return true;
            }
            return false;
        }

        public Collection<String> getBoundedProperties(String prop) {
            HashSet<String> bounded = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                Set<String> group = entry.getValue();
                if (group == null || !group.contains(prop)) continue;
                bounded.addAll(group);
            }
            bounded.remove(prop);
            return bounded;
        }
    }

    private final class MultiProperty {
        private Map<String, List<Map<String, String>>> APP_MULTIPROPS;
        private String prefix;
        private String[] suffixes;
        private String connectSign;

        public MultiProperty(@NonNull String prefix, @NonNull String[] suffixes, String connectSign) {
            assert (suffixes.length == 3);
            this.prefix = prefix;
            this.suffixes = suffixes;
            this.connectSign = connectSign;
            this.reset();
        }

        public void reset() {
            this.APP_MULTIPROPS = new TreeMap<String, List<Map<String, String>>>(JFXProjectConfigurations.this.getComparator());
        }

        private boolean isEntryHidden(Map<String, String> entry) {
            return entry != null && JFXProjectProperties.isTrue(entry.get(this.suffixes[2]));
        }

        private boolean isEntryHidden(String config, @NonNull String name) {
            Map<String, String> entry = this.getEntry(config, name);
            if (entry != null) {
                return this.isEntryHidden(entry);
            }
            return false;
        }

        private void hideEntry(@NonNull Map<String, String> entry) {
            assert (entry != null);
            entry.put(this.suffixes[2], JFXProjectConfigurations.APP_MULTIPROP_HIDDEN_TRUE);
        }

        private void unhideEntry(@NonNull Map<String, String> entry) {
            assert (entry != null);
            entry.remove(this.suffixes[2]);
        }

        private void hideEntry(String config, String name) {
            Map<String, String> map = this.getEntry(config, name);
            if (map != null) {
                this.hideEntry(map);
            }
        }

        private void unhideEntry(String config, String name) {
            Map<String, String> map = this.getEntry(config, name);
            if (map != null) {
                this.unhideEntry(map);
            }
        }

        private List<Map<String, String>> removeHiddenEntries(@NonNull List<Map<String, String>> entries) {
            ArrayList<Map<String, String>> filtered = new ArrayList<Map<String, String>>();
            if (entries != null) {
                for (Map<String, String> map : entries) {
                    if (this.isEntryHidden(map)) continue;
                    filtered.add(map);
                }
            }
            return filtered;
        }

        private String getEntryName(Map<String, String> entry) {
            return entry != null ? entry.get(this.suffixes[0]) : null;
        }

        private String getEntryValue(Map<String, String> entry) {
            return entry != null ? entry.get(this.suffixes[1]) : null;
        }

        private void setEntryName(Map<String, String> entry, String name) {
            if (entry != null) {
                entry.put(this.suffixes[0], name);
            }
        }

        private void setEntryValue(Map<String, String> entry, String value) {
            if (entry != null) {
                entry.put(this.suffixes[1], value);
            }
        }

        private boolean hasEntry(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.getEntry(config, name) != null;
        }

        private boolean hasDefaultEntry(@NonNull String name) {
            return this.hasEntry(null, name);
        }

        private boolean hasActiveEntry(@NonNull String name) {
            return this.hasEntry(JFXProjectConfigurations.this.getActive(), name);
        }

        public boolean hasEntryTransparent(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.getEntryTransparent(config, name) != null;
        }

        public boolean hasDefaultEntryTransparent(@NonNull String name) {
            return this.hasEntryTransparent(null, name);
        }

        public boolean hasActiveEntryTransparent(@NonNull String name) {
            return this.hasEntryTransparent(JFXProjectConfigurations.this.getActive(), name);
        }

        private boolean hasEntry(String config, @NonNull String name, @NonNull String value) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            String v = this.getEntryValue(config, name);
            return JFXProjectProperties.isEqualText(v, value);
        }

        private boolean hasDefaultEntry(@NonNull String name, @NonNull String value) {
            return this.hasEntry(null, name, value);
        }

        private boolean hasActiveEntry(@NonNull String name, @NonNull String value) {
            return this.hasEntry(JFXProjectConfigurations.this.getActive(), name, value);
        }

        public boolean hasEntryTransparent(String config, @NonNull String name, @NonNull String value) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            String v = this.getEntryValueTransparent(config, name);
            return JFXProjectProperties.isEqualText(v, value);
        }

        public boolean hasDefaultEntryTransparent(@NonNull String name, @NonNull String value) {
            return this.hasEntryTransparent(null, name, value);
        }

        public boolean hasActiveEntryTransparent(@NonNull String name, @NonNull String value) {
            return this.hasEntryTransparent(JFXProjectConfigurations.this.getActive(), name, value);
        }

        private boolean hasEntryValue(Map<String, String> entry) {
            return entry != null && entry.containsKey(this.suffixes[1]);
        }

        private boolean hasEntryValue(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            Map<String, String> entry = this.getEntry(config, name);
            return this.hasEntryValue(entry);
        }

        private boolean hasDefaultEntryValue(@NonNull String name) {
            return this.hasEntryValue(null, name);
        }

        private boolean hasActiveEntryValue(@NonNull String name) {
            return this.hasEntryValue(JFXProjectConfigurations.this.getActive(), name);
        }

        public boolean hasEntryValueTransparent(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            Map<String, String> entry = this.getEntry(config, name);
            if (config != null && entry == null) {
                return this.hasEntryValueTransparent(null, name);
            }
            return this.isEntryHidden(entry) ? false : this.hasEntryValue(entry);
        }

        public boolean hasDefaultEntryValueTransparent(@NonNull String name) {
            return this.hasEntryValueTransparent(null, name);
        }

        public boolean hasActiveEntryValueTransparent(@NonNull String name) {
            return this.hasEntryValueTransparent(JFXProjectConfigurations.this.getActive(), name);
        }

        private Map<String, String> getEntry(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.getEntry(this.getEntries(config), name);
        }

        private Map<String, String> getDefaultEntry(@NonNull String name) {
            return this.getEntry((String)null, name);
        }

        private Map<String, String> getActiveEntry(@NonNull String name) {
            return this.getEntry(JFXProjectConfigurations.this.getActive(), name);
        }

        public Map<String, String> getEntryTransparent(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            Map<String, String> entry = this.getEntry(config, name);
            if (config != null && entry == null) {
                return this.getEntryTransparent(null, name);
            }
            return this.isEntryHidden(entry) ? null : entry;
        }

        public Map<String, String> getDefaultEntryTransparent(@NonNull String name) {
            return this.getEntryTransparent(null, name);
        }

        public Map<String, String> getActiveEntryTransparent(@NonNull String name) {
            return this.getEntryTransparent(JFXProjectConfigurations.this.getActive(), name);
        }

        private String getEntryValue(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            Map<String, String> entry = this.getEntry(config, name);
            if (entry != null) {
                return this.getEntryValue(entry);
            }
            return null;
        }

        private String getDefaultEntryValue(@NonNull String name) {
            return this.getEntryValue(null, name);
        }

        private String getActiveEntryValue(@NonNull String name) {
            return this.getEntryValue(JFXProjectConfigurations.this.getActive(), name);
        }

        public String getEntryValueTransparent(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            Map<String, String> entry = this.getEntry(config, name);
            if (config != null && entry == null) {
                return this.getEntryValueTransparent(null, name);
            }
            return this.isEntryHidden(entry) ? null : this.getEntryValue(entry);
        }

        public String getDefaultEntryValueTransparent(@NonNull String name) {
            return this.getEntryValueTransparent(null, name);
        }

        public String getActiveEntryValueTransparent(@NonNull String name) {
            return this.getEntryValueTransparent(JFXProjectConfigurations.this.getActive(), name);
        }

        @NonNull
        private List<Map<String, String>> getEntries(String config) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.APP_MULTIPROPS.get(config);
        }

        private List<Map<String, String>> getDefaultEntries() {
            return this.APP_MULTIPROPS.get(null);
        }

        private List<Map<String, String>> getActiveEntries() {
            return this.APP_MULTIPROPS.get(JFXProjectConfigurations.this.getActive());
        }

        public List<Map<String, String>> getEntriesTransparent(String config) {
            String name;
            List<Map<String, String>> configEntries;
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            if (config == null) {
                return this.removeHiddenEntries(this.getDefaultEntries());
            }
            ArrayList<Map<String, String>> union = new ArrayList<Map<String, String>>();
            HashSet<String> markerDefault = new HashSet<String>();
            HashSet<String> markerConfig = new HashSet<String>();
            List<Map<String, String>> defaultEntries = this.getDefaultEntries();
            if (defaultEntries != null) {
                for (Map<String, String> map : defaultEntries) {
                    if (this.isEntryHidden(map)) continue;
                    markerDefault.add(this.getEntryName(map));
                }
            }
            if ((configEntries = this.getEntries(config)) != null) {
                for (Map<String, String> map : configEntries) {
                    if (!this.isEntryHidden(map)) {
                        markerConfig.add(this.getEntryName(map));
                        continue;
                    }
                    markerDefault.remove(this.getEntryName(map));
                }
            }
            if (defaultEntries != null) {
                for (Map<String, String> map : defaultEntries) {
                    name = this.getEntryName(map);
                    if (!markerDefault.contains(name) || markerConfig.contains(name)) continue;
                    union.add(this.createEntry(name, this.getEntryValue(map)));
                }
            }
            if (configEntries != null) {
                for (Map<String, String> map : configEntries) {
                    name = this.getEntryName(map);
                    if (!markerConfig.contains(name)) continue;
                    union.add(this.createEntry(name, this.getEntryValue(map)));
                }
            }
            return union;
        }

        public List<Map<String, String>> getDefaultEntriesTransparent() {
            return this.getEntriesTransparent(null);
        }

        public List<Map<String, String>> getActiveEntriesTransparent() {
            return this.getEntriesTransparent(JFXProjectConfigurations.this.getActive());
        }

        private String getEntriesAsString(String config, boolean commandLine) {
            return this.getEntriesAsString(this.getEntries(config), commandLine);
        }

        private String getDefaultEntriesAsString(boolean commandLine, boolean quoteEntries) {
            return this.getEntriesAsString(this.getDefaultEntries(), commandLine, quoteEntries);
        }

        private String getDefaultEntriesAsString(boolean commandLine) {
            return this.getEntriesAsString(this.getDefaultEntries(), commandLine);
        }

        private String getActiveEntriesAsString(boolean commandLine) {
            return this.getEntriesAsString(this.getActiveEntries(), commandLine);
        }

        public String getEntriesTransparentAsString(String config, boolean commandLine) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.getEntriesAsString(this.getEntriesTransparent(config), commandLine);
        }

        public String getEntriesTransparentAsString(String config, boolean commandLine, boolean quoteParams) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.getEntriesAsString(this.getEntriesTransparent(config), commandLine, quoteParams);
        }

        public String getDefaultEntriesTransparentAsString(boolean commandLine) {
            return this.getEntriesAsString(this.getDefaultEntriesTransparent(), commandLine);
        }

        public String getActiveEntriesTransparentAsString(boolean commandLine) {
            return this.getEntriesAsString(this.getActiveEntriesTransparent(), commandLine);
        }

        private String getEntriesAsString(List<Map<String, String>> props, boolean commandLine) {
            return this.getEntriesAsString(props, commandLine, false);
        }

        private String getEntriesAsString(List<Map<String, String>> props, boolean commandLine, boolean quoteParams) {
            StringBuilder sb = new StringBuilder();
            if (props != null) {
                int index = 0;
                for (Map<String, String> m : props) {
                    String name = this.getEntryName(m);
                    String value = this.getEntryValue(m);
                    if (name == null || name.length() <= 0 || this.isEntryHidden(m)) continue;
                    if (sb.length() > 0) {
                        if (!commandLine) {
                            sb.append(",");
                        }
                        sb.append(" ");
                    }
                    if (value != null && value.length() > 0) {
                        if (commandLine) {
                            sb.append("--");
                        }
                        if (quoteParams) {
                            sb.append("'").append(name).append("'");
                        } else {
                            sb.append(name);
                        }
                        if (commandLine) {
                            sb.append(JFXProjectConfigurations.APP_PARAM_CONNECT_SIGN);
                        } else {
                            sb.append(this.connectSign);
                        }
                        if (quoteParams) {
                            sb.append("'").append(value).append("'");
                        } else {
                            sb.append(value);
                        }
                    } else if (quoteParams) {
                        sb.append("'").append(name).append("'");
                    } else {
                        sb.append(name);
                    }
                    ++index;
                }
            }
            return sb.toString();
        }

        public int getNoOfEntries(String config) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            return this.getNoOfEntries(this.getEntriesTransparent(config));
        }

        public int getNoOfDefaultEntries() {
            return this.getNoOfEntries(this.getDefaultEntriesTransparent());
        }

        public int getNoOfActiveEntries() {
            return this.getNoOfEntries(this.getActiveEntriesTransparent());
        }

        private int getNoOfEntries(List<Map<String, String>> props) {
            int sum = 0;
            if (props != null) {
                for (Map<String, String> m : props) {
                    String name = this.getEntryName(m);
                    if (name == null || name.length() <= 0 || this.isEntryHidden(m)) continue;
                    ++sum;
                }
            }
            return sum;
        }

        private Map<String, String> createEntry(@NonNull String name) {
            TreeMap<String, String> prop = new TreeMap<String, String>(JFXProjectConfigurations.this.getComparator());
            this.setEntryName(prop, name);
            return prop;
        }

        private Map<String, String> createEntry(@NonNull String name, String value) {
            TreeMap<String, String> prop = new TreeMap<String, String>(JFXProjectConfigurations.this.getComparator());
            this.setEntryName(prop, name);
            this.setEntryValue(prop, value);
            return prop;
        }

        private Map<String, String> copyEntry(@NonNull Map<String, String> entry) {
            HashMap<String, String> newEntry = new HashMap<String, String>();
            for (String name : this.suffixes) {
                String value = entry.get(name);
                if (value == null || value.isEmpty()) continue;
                newEntry.put(name, value);
            }
            return newEntry;
        }

        private void addEntry(String config, @NonNull Map<String, String> entry) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            List<Map<String, String>> props = this.getEntries(config);
            if (props == null) {
                props = new ArrayList<Map<String, String>>();
                this.APP_MULTIPROPS.put(config, props);
            } else {
                this.eraseEntry(props, entry);
            }
            props.add(entry);
        }

        private void addDefaultEntry(@NonNull Map<String, String> entry) {
            this.addEntry((String)null, entry);
        }

        private void addActiveEntry(@NonNull Map<String, String> entry) {
            this.addEntry(JFXProjectConfigurations.this.getActive(), entry);
        }

        private Map<String, String> addEntry(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            List<Map<String, String>> props = this.getEntries(config);
            if (props == null) {
                props = new ArrayList<Map<String, String>>();
                this.APP_MULTIPROPS.put(config, props);
            } else {
                this.eraseEntry(props, name);
            }
            Map<String, String> newEntry = this.createEntry(name);
            props.add(newEntry);
            return newEntry;
        }

        private Map<String, String> addDefaultEntry(@NonNull String name) {
            return this.addEntry((String)null, name);
        }

        private Map<String, String> addActiveEntry(@NonNull String name) {
            return this.addEntry(JFXProjectConfigurations.this.getActive(), name);
        }

        public Map<String, String> addEntryTransparent(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            if (config == null) {
                for (String c : JFXProjectConfigurations.this.getConfigNames()) {
                    Map<String, String> entry = this.getEntry(c, name);
                    if (c == null || entry == null || this.getEntryValue(entry) != null || this.isEntryHidden(entry)) continue;
                    this.eraseEntry(c, name);
                }
                return this.addDefaultEntry(name);
            }
            if (this.hasDefaultEntryTransparent(name) && !this.hasDefaultEntryValueTransparent(name)) {
                this.eraseEntry(config, name);
                return null;
            }
            return this.addEntry(config, name);
        }

        public Map<String, String> addDefaultEntryTransparent(@NonNull String name) {
            return this.addEntryTransparent(null, name);
        }

        public Map<String, String> addActiveEntryTransparent(@NonNull String name) {
            return this.addEntryTransparent(JFXProjectConfigurations.this.getActive(), name);
        }

        private Map<String, String> addEntry(String config, @NonNull String name, String value) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            List<Map<String, String>> props = this.getEntries(config);
            if (props == null) {
                props = new ArrayList<Map<String, String>>();
                this.APP_MULTIPROPS.put(config, props);
            } else {
                this.eraseEntry(props, name);
            }
            Map<String, String> newEntry = this.createEntry(name, value);
            props.add(newEntry);
            return newEntry;
        }

        private Map<String, String> addDefaultEntry(@NonNull String name, String value) {
            return this.addEntry(null, name, value);
        }

        private Map<String, String> addActiveEntry(@NonNull String name, String value) {
            return this.addEntry(JFXProjectConfigurations.this.getActive(), name, value);
        }

        public Map<String, String> addEntryTransparent(String config, @NonNull String name, String value) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            if (config == null) {
                for (String c : JFXProjectConfigurations.this.getConfigNames()) {
                    Map<String, String> entry = this.getEntry(c, name);
                    if (c == null || entry == null || !JFXProjectProperties.isEqualText(this.getEntryValue(entry), value) || this.isEntryHidden(entry)) continue;
                    this.eraseEntry(c, name);
                }
                return this.addDefaultEntry(name, value);
            }
            if (this.hasDefaultEntryTransparent(name, value)) {
                this.eraseEntry(config, name);
                return null;
            }
            return this.addEntry(config, name, value);
        }

        public Map<String, String> addDefaultEntryTransparent(@NonNull String name, String value) {
            return this.addEntryTransparent(null, name, value);
        }

        public Map<String, String> addActiveEntryTransparent(@NonNull String name, String value) {
            return this.addEntryTransparent(JFXProjectConfigurations.this.getActive(), name, value);
        }

        public void setEntriesTransparent(String config, List<Map<String, String>> entries) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            if (config == null) {
                ArrayList<Map<String, String>> newDefault = new ArrayList<Map<String, String>>();
                HashSet<String> toClean = new HashSet<String>();
                if (this.APP_MULTIPROPS.get(null) != null) {
                    for (Map<String, String> entry : this.APP_MULTIPROPS.get(null)) {
                        if (this.isEntryHidden(entry)) {
                            newDefault.add(entry);
                            continue;
                        }
                        toClean.add(this.getEntryName(entry));
                    }
                }
                this.APP_MULTIPROPS.put(null, newDefault);
                if (entries != null) {
                    for (Map<String, String> entry : entries) {
                        String name = this.getEntryName(entry);
                        toClean.remove(name);
                        Map<String, String> added = this.hasEntryValue(entry) ? this.addDefaultEntryTransparent(name, this.getEntryValue(entry)) : this.addDefaultEntryTransparent(name);
                        if (!this.isEntryHidden(entry)) continue;
                        this.hideEntry(added);
                    }
                }
                for (String name : toClean) {
                    this.eraseNonDefaultEntries(name, true);
                }
            } else {
                ArrayList<Map<String, String>> reduct = new ArrayList<Map<String, String>>();
                if (entries != null) {
                    List<Map<String, String>> def = JFXProjectUtils.copyList(this.getDefaultEntriesTransparent());
                    for (Map<String, String> map : entries) {
                        String name = this.getEntryName(map);
                        String value = this.getEntryValue(map);
                        Map<String, String> defEntry = this.getDefaultEntryTransparent(name);
                        if (defEntry != null) {
                            String defValue = this.getEntryValue(defEntry);
                            if (!JFXProjectProperties.isEqualText(value, defValue)) {
                                reduct.add(JFXProjectUtils.copyMap(map));
                            }
                            def.remove(defEntry);
                            continue;
                        }
                        if (this.isEntryHidden(map)) continue;
                        reduct.add(JFXProjectUtils.copyMap(map));
                    }
                    for (Map<String, String> map : def) {
                        Map<String, String> defCopy = JFXProjectUtils.copyMap(map);
                        this.hideEntry(defCopy);
                        reduct.add(defCopy);
                    }
                }
                this.APP_MULTIPROPS.put(config, reduct);
            }
        }

        public void setDefaultEntriesTransparent(List<Map<String, String>> entries) {
            this.setEntriesTransparent(null, entries);
        }

        public void setActiveEntriesTransparent(List<Map<String, String>> entries) {
            this.setEntriesTransparent(JFXProjectConfigurations.this.getActive(), entries);
        }

        private void eraseEntry(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            this.eraseEntry(this.getEntries(config), name);
        }

        private void eraseDefaultEntry(@NonNull String name) {
            this.eraseEntry((String)null, name);
        }

        private void eraseActiveEntry(@NonNull String name) {
            this.eraseEntry(JFXProjectConfigurations.this.getActive(), name);
        }

        private void eraseNonDefaultEntries(@NonNull String name, boolean hidden) {
            for (String c : JFXProjectConfigurations.this.getConfigNames()) {
                Map<String, String> entry = this.getEntry(c, name);
                if (c == null || entry == null || this.isEntryHidden(entry) != hidden) continue;
                this.eraseEntry(c, name);
            }
        }

        public void eraseEntryTransparent(String config, @NonNull String name) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            if (config == null) {
                this.eraseNonDefaultEntries(name, true);
                this.eraseDefaultEntry(name);
            } else if (this.hasDefaultEntryTransparent(name)) {
                if (this.hasEntry(config, name)) {
                    this.hideEntry(config, name);
                } else {
                    Map<String, String> toHide = this.addEntry(config, name);
                    this.hideEntry(toHide);
                }
            } else {
                this.eraseEntry(config, name);
            }
        }

        public void eraseDefaultEntryTransparent(@NonNull String name) {
            this.eraseEntryTransparent(null, name);
        }

        public void eraseActiveEntryTransparent(@NonNull String name) {
            this.eraseEntryTransparent(JFXProjectConfigurations.this.getActive(), name);
        }

        private void eraseEntries(String config) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            this.APP_MULTIPROPS.remove(config);
        }

        private void eraseDefaultEntries() {
            this.eraseEntries(null);
        }

        private void eraseActiveEntries() {
            this.eraseEntries(JFXProjectConfigurations.this.getActive());
        }

        public void eraseEntriesTransparent(String config) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            if (config == null) {
                if (this.APP_MULTIPROPS.get(null) != null) {
                    for (Map<String, String> defEntry : this.APP_MULTIPROPS.get(null)) {
                        if (this.isEntryHidden(defEntry)) continue;
                        String name = this.getEntryName(defEntry);
                        for (String c : JFXProjectConfigurations.this.getConfigNames()) {
                            Map<String, String> entry = this.getEntry(c, name);
                            if (c == null || entry == null || !this.isEntryHidden(entry)) continue;
                            this.eraseEntry(c, name);
                        }
                    }
                }
                this.eraseDefaultEntries();
            } else {
                ArrayList<Map<String, String>> hidden = new ArrayList<Map<String, String>>();
                List<Map<String, String>> configEntries = this.getEntries(config);
                if (configEntries != null) {
                    for (Map<String, String> map : configEntries) {
                        String name = this.getEntryName(map);
                        if (!this.hasDefaultEntryTransparent(name)) continue;
                        Map<String, String> h = JFXProjectUtils.copyMap(map);
                        this.hideEntry(h);
                        hidden.add(h);
                    }
                }
                this.APP_MULTIPROPS.put(config, hidden);
            }
        }

        public void eraseDefaultEntriesTransparent() {
            this.eraseEntriesTransparent(null);
        }

        public void eraseActiveEntriesTransparent() {
            this.eraseEntriesTransparent(JFXProjectConfigurations.this.getActive());
        }

        private Map<String, String> getEntry(List<Map<String, String>> entries, String entryName) {
            if (entries != null && entryName != null) {
                for (Map<String, String> map : entries) {
                    String name = this.getEntryName(map);
                    if (name == null || !name.equals(entryName)) continue;
                    return map;
                }
            }
            return null;
        }

        private void eraseEntry(List<Map<String, String>> entries, String entryName) {
            if (entries != null && entryName != null) {
                Map<String, String> toErase = null;
                for (Map<String, String> map : entries) {
                    String name = this.getEntryName(map);
                    if (name == null || !name.equals(entryName)) continue;
                    toErase = map;
                    break;
                }
                if (toErase != null) {
                    entries.remove(toErase);
                }
            }
        }

        private void eraseEntry(List<Map<String, String>> entries, Map<String, String> entry) {
            if (entries != null && entry != null) {
                String name = this.getEntryName(entry);
                this.eraseEntry(entries, name);
            }
        }

        private boolean isEntryNameProperty(@NonNull String prop) {
            return prop != null && prop.startsWith(this.prefix) && prop.endsWith(this.suffixes[0]);
        }

        private boolean isEntryValueProperty(@NonNull String prop) {
            return prop != null && prop.startsWith(this.prefix) && prop.endsWith(this.suffixes[1]);
        }

        private boolean isEntryHiddenProperty(@NonNull String prop) {
            return prop != null && prop.startsWith(this.prefix) && prop.endsWith(this.suffixes[2]);
        }

        private String getEntryValueProperty(String entryNameProperty) {
            if (entryNameProperty != null && this.isEntryNameProperty(entryNameProperty)) {
                return entryNameProperty.replace(this.suffixes[0], this.suffixes[1]);
            }
            return null;
        }

        private String getEntryHiddenProperty(String entryNameProperty) {
            if (entryNameProperty != null && this.isEntryNameProperty(entryNameProperty)) {
                return entryNameProperty.replace(this.suffixes[0], this.suffixes[2]);
            }
            return null;
        }

        private String getEntryNameProperty(int index) {
            return this.prefix + index + "." + this.suffixes[0];
        }

        private String getEntryValueProperty(int index) {
            return this.prefix + index + "." + this.suffixes[1];
        }

        private String getEntryHiddenProperty(int index) {
            return this.prefix + index + "." + this.suffixes[2];
        }

        private boolean isFreeEntryPropertyIndex(int index, @NonNull EditableProperties ep) {
            return !ep.containsKey((Object)this.getEntryNameProperty(index));
        }

        private int getFreeEntryPropertyIndex(int start, @NonNull EditableProperties ep, @NonNull EditableProperties pep, List<String> propNamesUsed) {
            int index;
            int n = index = start >= 0 ? start : 0;
            while (index >= 0 && (!this.isFreeEntryPropertyIndex(index, ep) || !this.isFreeEntryPropertyIndex(index, pep) || propNamesUsed != null && propNamesUsed.contains(this.getEntryNameProperty(index)))) {
                ++index;
            }
            return index >= 0 ? index : 0;
        }

        private boolean updateEntryProperties(String config, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, @NonNull List<String> propNamesUsed) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            boolean privateUpdated = false;
            List<Map<String, String>> reduce = JFXProjectUtils.copyList(this.getEntries(config));
            for (String string : propNamesUsed) {
                if (string == null || string.length() <= 0) continue;
                projectProperties.remove((Object)string);
                projectProperties.remove((Object)this.getEntryValueProperty(string));
                projectProperties.remove((Object)this.getEntryHiddenProperty(string));
                privateProperties.remove((Object)string);
                privateProperties.remove((Object)this.getEntryValueProperty(string));
                privateProperties.remove((Object)this.getEntryHiddenProperty(string));
            }
            this.cleanEntryPropertiesIfEmpty(config, privateProperties);
            for (String string : privateProperties.keySet()) {
                if (!this.isEntryNameProperty(string)) continue;
                propNamesUsed.add(string);
            }
            LinkedList<Map<String, String>> toEraseList = new LinkedList<Map<String, String>>();
            for (Map<String, String> map : reduce) {
                if (!this.updateEntryPropertyIfExists(map, privateProperties, true)) continue;
                toEraseList.add(map);
                privateUpdated = true;
            }
            reduce.removeAll(toEraseList);
            this.cleanEntryPropertiesNotListed(reduce, projectProperties);
            for (String string : projectProperties.keySet()) {
                if (!this.isEntryNameProperty(string)) continue;
                propNamesUsed.add(string);
            }
            boolean bl = false;
            for (Map<String, String> map : reduce) {
                int n;
                String name = this.getEntryName(map);
                if (name == null || name.length() <= 0 || this.updateEntryPropertyIfExists(map, projectProperties, false)) continue;
                n = this.getFreeEntryPropertyIndex(n, projectProperties, privateProperties, propNamesUsed);
                this.exportEntryProperty(map, this.getEntryNameProperty(n), this.getEntryValueProperty(n), this.getEntryHiddenProperty(n), projectProperties);
                propNamesUsed.add(this.getEntryNameProperty(n));
            }
            return privateUpdated;
        }

        private boolean updateDefaultEntryProperties(@NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, List<String> propNamesUsed) {
            return this.updateEntryProperties(null, projectProperties, privateProperties, propNamesUsed);
        }

        private boolean updateEntryPropertyIfExists(Map<String, String> entry, EditableProperties ep, boolean storeEmpty) {
            String name;
            if (entry != null && (name = this.getEntryName(entry)) != null && !name.isEmpty()) {
                for (String prop : ep.keySet()) {
                    if (!this.isEntryNameProperty(prop) || !JFXProjectProperties.isEqualText(name, ep.get((Object)prop))) continue;
                    String propVal = this.getEntryValueProperty(prop);
                    String value = this.getEntryValue(entry);
                    if (value != null && (value.length() > 0 || storeEmpty)) {
                        ep.setProperty(propVal, value);
                    } else {
                        ep.remove((Object)propVal);
                    }
                    String propHid = this.getEntryHiddenProperty(prop);
                    if (this.isEntryHidden(entry)) {
                        ep.setProperty(propHid, JFXProjectConfigurations.APP_MULTIPROP_HIDDEN_TRUE);
                    } else {
                        ep.remove((Object)propHid);
                    }
                    return true;
                }
            }
            return false;
        }

        private void cleanEntryPropertiesIfEmpty(String config, EditableProperties ep) {
            assert (!JFXProjectConfigurations.this.configNameWrong(config));
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String prop : ep.keySet()) {
                String name;
                if (!this.isEntryNameProperty(prop) || this.hasEntry(config, name = ep.get((Object)prop))) continue;
                toRemove.add(prop);
            }
            for (String prop : toRemove) {
                ep.remove((Object)prop);
                ep.remove((Object)this.getEntryValueProperty(prop));
                ep.remove((Object)this.getEntryHiddenProperty(prop));
            }
        }

        private void cleanEntryPropertiesNotListed(List<Map<String, String>> entries, EditableProperties ep) {
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String name : ep.keySet()) {
                if (!this.isEntryNameProperty(name)) continue;
                boolean inProps = false;
                if (entries != null) {
                    for (Map<String, String> map : entries) {
                        String prop = this.getEntryName(map);
                        if (!JFXProjectProperties.isEqualText(name, prop)) continue;
                        inProps = true;
                        break;
                    }
                }
                if (inProps) continue;
                toRemove.add(name);
            }
            for (String prop : toRemove) {
                ep.remove((Object)prop);
                ep.remove((Object)this.getEntryValueProperty(prop));
                ep.remove((Object)this.getEntryHiddenProperty(prop));
            }
        }

        private void exportEntryProperty(@NonNull Map<String, String> entry, String newPropName, String newPropValue, String newPropHidden, @NonNull EditableProperties ep) {
            String name = this.getEntryName(entry);
            String value = this.getEntryValue(entry);
            if (name != null) {
                ep.put(newPropName, name);
                if (value != null && value.length() > 0) {
                    ep.put(newPropValue, value);
                }
                if (this.isEntryHidden(entry)) {
                    ep.put(newPropHidden, JFXProjectConfigurations.APP_MULTIPROP_HIDDEN_TRUE);
                }
            }
        }

        private void extractEntries(@NonNull EditableProperties ep, String config) {
            if (ep != null) {
                for (String prop : ep.keySet()) {
                    String name;
                    if (!this.isEntryNameProperty(prop) || (name = ep.getProperty(prop)) == null) continue;
                    String value = ep.getProperty(this.getEntryValueProperty(prop));
                    String hidden = ep.getProperty(this.getEntryHiddenProperty(prop));
                    Map<String, String> map = this.createEntry(name);
                    if (value != null) {
                        this.setEntryValue(map, value);
                    }
                    if (hidden != null && JFXProjectProperties.isTrue(hidden)) {
                        this.hideEntry(map);
                    }
                    this.addEntry(config, map);
                }
            }
        }

        private void extractDefaultEntries(@NonNull EditableProperties ep) {
            this.extractEntries(ep, null);
        }

        private void extractActiveEntries(@NonNull EditableProperties ep) {
            this.extractEntries(ep, JFXProjectConfigurations.this.getActive());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(JFXProjectConfigurations.MULTI_PROPERTY_STRING);
            sb.append(":");
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(this.APP_MULTIPROPS.keySet());
            keys.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            if (keys == null || keys.isEmpty()) {
                sb.append(" ");
                sb.append(JFXProjectConfigurations.MULTI_PROPERTY_EMPTY);
            } else {
                for (String configName : keys) {
                    sb.append(" {");
                    sb.append(configName);
                    sb.append("}");
                    ArrayList<Map<String, String>> configList = new ArrayList<Map<String, String>>((Collection)this.APP_MULTIPROPS.get(configName));
                    configList.sort(new Comparator<Map<String, String>>(){

                        @Override
                        public int compare(Map<String, String> o1, Map<String, String> o2) {
                            String n1 = MultiProperty.this.getEntryName(o1);
                            String n2 = MultiProperty.this.getEntryName(o2);
                            if (n1 == null && n2 != null) {
                                return -1;
                            }
                            if (n1 != null && n2 == null) {
                                return 1;
                            }
                            if (n1 == null && n2 == null || n1.compareTo(n2) == 0) {
                                String v1 = MultiProperty.this.getEntryValue(o1);
                                String v2 = MultiProperty.this.getEntryValue(o2);
                                if (v1 == null && v2 != null) {
                                    return -1;
                                }
                                if (v1 != null && v2 == null) {
                                    return 1;
                                }
                                if (v1 == null && v2 == null) {
                                    return 0;
                                }
                                return v1.compareTo(v2);
                            }
                            return n1.compareTo(n2);
                        }
                    });
                    for (Map map : configList) {
                        for (int i = 0; i < this.suffixes.length; ++i) {
                            String s = (String)map.get(this.suffixes[i]);
                            if (s == null) continue;
                            sb.append(" ");
                            sb.append(this.suffixes[i]);
                            sb.append(JFXProjectConfigurations.APP_PARAM_CONNECT_SIGN);
                            sb.append(s);
                        }
                    }
                }
            }
            return sb.toString();
        }
    }
}

