/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BitbucketServerFilterAttributes;
import com.oracle.bmc.devops.model.Filter;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="triggerSource")
@JsonFilter(value="explicitlySetFilter")
public final class BitbucketServerFilter
extends Filter {
    @JsonProperty(value="events")
    private final List<Events> events;
    @JsonProperty(value="include")
    private final BitbucketServerFilterAttributes include;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BitbucketServerFilter(List<Events> events, BitbucketServerFilterAttributes include) {
        this.events = events;
        this.include = include;
    }

    public List<Events> getEvents() {
        return this.events;
    }

    public BitbucketServerFilterAttributes getInclude() {
        return this.include;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BitbucketServerFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", events=").append(String.valueOf(this.events));
        sb.append(", include=").append(String.valueOf((Object)this.include));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitbucketServerFilter)) {
            return false;
        }
        BitbucketServerFilter other = (BitbucketServerFilter)((Object)o);
        return Objects.equals(this.events, other.events) && Objects.equals((Object)this.include, (Object)other.include) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.events == null ? 43 : this.events.hashCode());
        result = result * 59 + (this.include == null ? 43 : this.include.hashCode());
        return result;
    }

    public static enum Events implements BmcEnum
    {
        Push("PUSH"),
        PullRequestOpened("PULL_REQUEST_OPENED"),
        PullRequestModified("PULL_REQUEST_MODIFIED"),
        PullRequestMerged("PULL_REQUEST_MERGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Events> map;

        private Events(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Events create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Events', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Events.class);
            map = new HashMap<String, Events>();
            for (Events v : Events.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="events")
        private List<Events> events;
        @JsonProperty(value="include")
        private BitbucketServerFilterAttributes include;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder events(List<Events> events) {
            this.events = events;
            this.__explicitlySet__.add("events");
            return this;
        }

        public Builder include(BitbucketServerFilterAttributes include) {
            this.include = include;
            this.__explicitlySet__.add("include");
            return this;
        }

        public BitbucketServerFilter build() {
            BitbucketServerFilter model = new BitbucketServerFilter(this.events, this.include);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BitbucketServerFilter model) {
            if (model.wasPropertyExplicitlySet("events")) {
                this.events(model.getEvents());
            }
            if (model.wasPropertyExplicitlySet("include")) {
                this.include(model.getInclude());
            }
            return this;
        }
    }
}

