/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public final class QuarkusProject {
    private final Path projectDirPath;
    private ExtensionCatalog catalog;
    private List<ResourceLoader> codestartResourceLoaders;
    private final ExtensionManager extensionManager;
    private final MessageWriter log;
    private final JavaVersion javaVersion;

    private QuarkusProject(Path projectDirPath, ExtensionCatalog catalog, List<ResourceLoader> codestartResourceLoaders, MessageWriter log, ExtensionManager extensionManager, JavaVersion javaVersion) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectDirPath is required");
        this.catalog = Objects.requireNonNull(catalog, "catalog is required");
        this.codestartResourceLoaders = Objects.requireNonNull(codestartResourceLoaders, "codestartResourceLoaders is required");
        this.extensionManager = Objects.requireNonNull(extensionManager, "extensionManager is required");
        this.log = log == null ? MessageWriter.info() : log;
        this.javaVersion = javaVersion;
    }

    public static QuarkusProject of(Path projectDirPath, ExtensionCatalog catalog, List<ResourceLoader> codestartResourceLoaders, MessageWriter log, ExtensionManager extensionManager, JavaVersion javaVersion) {
        return new QuarkusProject(projectDirPath, catalog, codestartResourceLoaders, log, extensionManager, javaVersion);
    }

    public static QuarkusProject of(Path projectDirPath, ExtensionCatalog catalog, List<ResourceLoader> codestartsResourceLoader, MessageWriter log, BuildTool buildTool, JavaVersion javaVersion) {
        return new QuarkusProject(projectDirPath, catalog, codestartsResourceLoader, log, buildTool.createExtensionManager(projectDirPath, catalog), javaVersion);
    }

    public Path getProjectDirPath() {
        return this.projectDirPath;
    }

    public BuildTool getBuildTool() {
        return this.extensionManager.getBuildTool();
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public ExtensionCatalog getExtensionsCatalog() {
        return this.catalog;
    }

    public List<ResourceLoader> getCodestartResourceLoaders() {
        return this.codestartResourceLoaders;
    }

    public MessageWriter log() {
        return this.log;
    }

    public static BuildTool resolveExistingProjectBuildTool(Path projectDirPath) {
        return QuarkusProjectHelper.detectExistingBuildTool(projectDirPath);
    }
}

