/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class ListenableWeakReference<T>
extends WeakReference<T> {
    private static final ReferenceQueue<Object> GLOBAL_QUEUE = new ReferenceQueue();
    private static Thread thread;
    private Runnable runOnDereference;

    public ListenableWeakReference(T referent) {
        this(referent, () -> {});
    }

    public ListenableWeakReference(T referent, Runnable runOnDereference) {
        super(referent, GLOBAL_QUEUE);
        this.runOnDereference = runOnDereference;
        ListenableWeakReference.ensureQueueStarted();
    }

    protected void onDereference() {
        this.runOnDereference.run();
    }

    private static synchronized void ensureQueueStarted() {
        if (thread == null) {
            thread = new Thread(ListenableWeakReference::clean, "Weak reference cleaner");
            thread.start();
        }
    }

    private static void clean() {
        boolean running = true;
        try {
            while (running) {
                Reference<Object> ref = GLOBAL_QUEUE.remove();
                if (!(ref instanceof ListenableWeakReference)) continue;
                ((ListenableWeakReference)ref).onDereference();
            }
        }
        catch (InterruptedException e) {
            running = false;
            BugReport.intercept(e).warn();
            Thread.currentThread().interrupt();
        }
    }
}

