/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd.util;

import com.amazonaws.ClientConfiguration;
import java.net.MalformedURLException;
import java.net.URL;

public class S3ProxyUtil {
    public static void populateS3ProxyProperties(ClientConfiguration clientConfig, String ec2URL, boolean verboseSet) {
        try {
            URL url = new URL(ec2URL);
            S3ProxyUtil.populateS3ProxyProperties(clientConfig, url.getProtocol().equalsIgnoreCase("https"), verboseSet);
        }
        catch (MalformedURLException e) {
            System.err.println("Malformed URL: '" + ec2URL + "'");
        }
    }

    public static void populateS3ProxyProperties(ClientConfiguration clientConfig, boolean useSsl, boolean verboseSet) {
        String proxyHost = null;
        String proxyPort = "8080";
        if (useSsl) {
            proxyHost = System.getProperty("https.proxyHost", proxyHost);
            proxyPort = System.getProperty("https.proxyPort", proxyPort);
        } else {
            proxyHost = System.getProperty("http.proxyHost", proxyHost);
            proxyPort = System.getProperty("http.proxyPort", proxyPort);
        }
        if (proxyHost != null) {
            if (verboseSet) {
                System.out.println("S3: Using proxy [" + proxyHost + ":" + proxyPort + "]");
            }
            clientConfig.setProxyHost(proxyHost);
            clientConfig.setProxyPort(Integer.parseInt(proxyPort));
            String proxyUser = System.getProperty("http.proxyUser", null);
            String proxyPass = System.getProperty("http.proxyPass", null);
            if (proxyUser != null) {
                if (verboseSet) {
                    System.out.println("S3: Using proxy credentials [" + proxyUser + "@" + proxyPass + "] for all realms");
                }
                clientConfig.setProxyUsername(proxyUser);
                clientConfig.setProxyPassword(proxyPass);
            }
            String proxyDomain = System.getProperty("http.proxyDomain");
            String proxyWorkstation = System.getProperty("http.proxyWorkstation");
            clientConfig.setProxyDomain(proxyDomain);
            clientConfig.setProxyWorkstation(proxyWorkstation);
        }
    }
}

