/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.columnsexist;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.columnsexist.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryColumnsExist
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String schemaname;
    private String tablename;
    private DatabaseMeta connection;
    public String[] arguments;

    public JobEntryColumnsExist(String n) {
        super(n, "");
        this.schemaname = null;
        this.tablename = null;
        this.connection = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.COLUMNS_EXIST);
    }

    public JobEntryColumnsExist() {
        this("");
    }

    public JobEntryColumnsExist(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryColumnsExist je = (JobEntryColumnsExist)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException(Messages.getString("JobEntryColumnsExist.Meta.UnableLoadXml"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryColumnsExist.Meta.UnableLoadRep", "" + id_jobentry), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "schemaname", this.schemaname);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "name", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryColumnsExist.Meta.UnableSaveRep", "" + id_job), (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block21: {
            log = LogWriter.getInstance();
            result = previousResult;
            result.setResult(false);
            result.setNrErrors(1L);
            nrexistcolums = 0;
            nrnotexistcolums = 0;
            if (Const.isEmpty((String)this.tablename)) {
                log.logError(this.toString(), Messages.getString("JobEntryColumnsExist.Error.TablenameEmpty"), new Object[0]);
                return result;
            }
            if (this.arguments == null) {
                log.logError(this.toString(), Messages.getString("JobEntryColumnsExist.Error.ColumnameEmpty"), new Object[0]);
                return result;
            }
            if (this.connection != null) {
                db = new Database(this.connection);
                try {
                    block20: {
                        realSchemaname = this.environmentSubstitute(this.schemaname);
                        realTablename = this.environmentSubstitute(this.tablename);
                        realTablename = Const.isEmpty((String)realSchemaname) == false ? db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename) : db.getDatabaseMeta().quoteField(realTablename);
                        db.connect();
                        if (db.checkTableExists(realTablename)) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobEntryColumnsExist.Log.TableExists", realTablename), new Object[0]);
                            }
                            for (i = 0; i < this.arguments.length && !parentJob.isStopped(); ++i) {
                                realColumnname = this.environmentSubstitute(this.arguments[i]);
                                realColumnname = db.getDatabaseMeta().quoteField(realColumnname);
                                if (db.checkColumnExists(realColumnname, realTablename)) {
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobEntryColumnsExist.Log.ColumnExists", realColumnname, realTablename), new Object[0]);
                                    }
                                    ++nrexistcolums;
                                    continue;
                                }
                                log.logError(this.toString(), Messages.getString("JobEntryColumnsExist.Log.ColumnNotExists", realColumnname, realTablename), new Object[0]);
                                ++nrnotexistcolums;
                            }
                            break block20;
                        }
                        log.logError(this.toString(), Messages.getString("JobEntryColumnsExist.Log.TableNotExists", realTablename), new Object[0]);
                    }
                    var15_15 = null;
                    ** if (db == null) goto lbl-1000
                }
                catch (Throwable var14_21) {
                    var15_17 = null;
                    if (db != null) {
                        try {
                            db.disconnect();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var14_21;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        db.disconnect();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                    catch (KettleDatabaseException dbe) {
                        log.logError(this.toString(), Messages.getString("JobEntryColumnsExist.Error.UnexpectedError", dbe.getMessage()), new Object[0]);
                        var15_16 = null;
                        if (db != null) {
                            try {
                                db.disconnect();
                            }
                            catch (Exception e) {}
                        }
                        break block21;
                    }
                }
            }
            log.logError(this.toString(), Messages.getString("JobEntryColumnsExist.Error.NoDbConnection"), new Object[0]);
        }
        result.setEntryNr((long)nrnotexistcolums);
        result.setNrLinesWritten((long)nrexistcolums);
        if (nrnotexistcolums == 0) {
            result.setResult(true);
        }
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "columnname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

