/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.IPv6Address;
import io.mola.galimatias.URLParser;
import io.mola.galimatias.URLParsingSettings;
import io.mola.galimatias.URLSearchParameters;
import io.mola.galimatias.URLUtils;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class URL
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String scheme;
    private final String schemeData;
    private final String username;
    private final String password;
    private final Host host;
    private final int port;
    private final String path;
    private final String query;
    private final String fragment;
    private final boolean isHierarchical;

    URL(String scheme, String schemeData, String username, String password, Host host, int port, Iterable<String> pathSegments, String query, String fragment, boolean isHierarchical) {
        this(scheme, schemeData, username, password, host, port, URL.pathSegmentsToString(pathSegments), query, fragment, isHierarchical);
    }

    URL(String scheme, String schemeData, String username, String password, Host host, int port, String path, String query, String fragment, boolean isHierarchical) {
        if (scheme == null) {
            throw new NullPointerException("scheme cannot be null");
        }
        this.scheme = scheme;
        String string = this.schemeData = schemeData == null ? "" : schemeData;
        if (isHierarchical) {
            this.username = username == null ? "" : username;
            this.password = password;
            this.host = host;
            this.port = port == URL.defaultPort(this.scheme) ? -1 : port;
            this.path = path;
        } else {
            this.username = "";
            this.password = null;
            this.host = null;
            this.port = -1;
            this.path = null;
        }
        this.query = query;
        this.fragment = fragment;
        this.isHierarchical = isHierarchical;
    }

    public String scheme() {
        return this.scheme;
    }

    public String schemeData() {
        return this.schemeData;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String userInfo() {
        if (this.password == null) {
            return this.username;
        }
        return String.format("%s:%s", this.username, this.password);
    }

    public Host host() {
        return this.host;
    }

    public String authority() {
        if (!this.isHierarchical) {
            return null;
        }
        if (this.host == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        String userInfo = this.userInfo();
        if (!userInfo.isEmpty()) {
            output.append(this.userInfo()).append('@');
        }
        output.append(this.host.toHostString());
        if (this.port != -1) {
            output.append(':').append(this.port);
        }
        return output.toString();
    }

    public int port() {
        return this.port == -1 ? this.defaultPort() : this.port;
    }

    private static int defaultPort(String scheme) {
        String defaultPort = URLUtils.getDefaultPortForScheme(scheme);
        if (defaultPort == null) {
            return -1;
        }
        return Integer.parseInt(defaultPort);
    }

    public int defaultPort() {
        return URL.defaultPort(this.scheme);
    }

    public String path() {
        return this.path;
    }

    public List<String> pathSegments() {
        if (!this.isHierarchical) {
            return null;
        }
        return URL.pathStringToSegments(this.path);
    }

    public String query() {
        return this.query;
    }

    public String queryParameter(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (this.query == null || this.query.isEmpty()) {
            return null;
        }
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = this.query.indexOf(38, start)) == -1 ? this.query.length() : nextAmpersand;
            int nextEquals = this.query.indexOf(61, start);
            if (nextEquals == -1 || nextEquals > end) {
                nextEquals = end;
            }
            int thisNameLength = nextEquals - start;
            int thisValueLength = end - nextEquals;
            if (thisNameLength == name.length() && this.query.regionMatches(start, name, 0, name.length())) {
                if (thisValueLength == 0) {
                    return "";
                }
                return this.query.substring(nextEquals + 1, end);
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return null;
    }

    public List<String> queryParameters(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (this.query == null || this.query.isEmpty()) {
            return null;
        }
        int start = 0;
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = this.query.indexOf(38, start)) == -1 ? this.query.length() : nextAmpersand;
            int nextEquals = this.query.indexOf(61, start);
            if (nextEquals == -1 || nextEquals > end) {
                nextEquals = end;
            }
            int thisNameLength = nextEquals - start;
            int thisValueLength = end - nextEquals;
            if (thisNameLength == name.length() && this.query.regionMatches(start, name, 0, name.length())) {
                if (thisValueLength == 0) {
                    result.add("");
                } else {
                    result.add(this.query.substring(nextEquals + 1, end));
                }
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return result;
    }

    public URLSearchParameters searchParameters() {
        return new URLSearchParameters(this.query);
    }

    public String fragment() {
        return this.fragment;
    }

    public String file() {
        if (this.path == null && this.query == null) {
            return "";
        }
        StringBuilder output = new StringBuilder((this.path != null ? this.path.length() : 0) + (this.query != null ? this.query.length() + 1 : 0));
        if (this.path != null) {
            output.append(this.path);
        }
        if (this.query != null) {
            output.append('?').append(this.query);
        }
        return output.toString();
    }

    public boolean isHierarchical() {
        return this.isHierarchical;
    }

    public boolean isOpaque() {
        return !this.isHierarchical;
    }

    private static String pathSegmentsToString(Iterable<String> segments) {
        if (segments == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        for (String segment : segments) {
            output.append('/').append(segment);
        }
        if (output.length() == 0) {
            return "/";
        }
        return output.toString();
    }

    private static List<String> pathStringToSegments(String path) {
        if (path == null) {
            return new ArrayList<String>();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] segments = path.split("/", -1);
        ArrayList<String> result = new ArrayList<String>(segments.length + 1);
        if (segments.length == 0) {
            result.add("");
            return result;
        }
        result.addAll(Arrays.asList(segments));
        return result;
    }

    public URL resolve(String input) throws GalimatiasParseException {
        return new URLParser(this, input).parse();
    }

    public String relativize(URL url) {
        String prefixPath;
        if (this.isOpaque() || url.isOpaque()) {
            return url.toString();
        }
        if (!this.scheme().equals(url.scheme())) {
            return url.toString();
        }
        if (this.authority() == null ^ url.authority() == null) {
            return url.toString();
        }
        if (this.authority() != null && !this.authority().equals(url.authority())) {
            return url.toString();
        }
        String string = prefixPath = this.path().endsWith("/") ? this.path : this.path() + "/";
        if (!url.path().startsWith(prefixPath) && !this.path().equals(url.path())) {
            return url.toString();
        }
        StringBuilder output = new StringBuilder();
        if (!this.path().equals(url.path())) {
            output.append(url.path().replaceFirst(prefixPath, ""));
        }
        if (url.query() != null) {
            output.append('?').append(url.query());
        }
        if (url.fragment() != null) {
            output.append('#').append(url.fragment());
        }
        return output.toString();
    }

    public static URL parse(String input) throws GalimatiasParseException {
        return new URLParser(input).parse();
    }

    public static URL parse(URL base, String input) throws GalimatiasParseException {
        return new URLParser(base, input).parse();
    }

    public static URL parse(URLParsingSettings settings, String input) throws GalimatiasParseException {
        return new URLParser(input).settings(settings).parse();
    }

    public static URL parse(URLParsingSettings settings, URL base, String input) throws GalimatiasParseException {
        return new URLParser(base, input).settings(settings).parse();
    }

    public static URL buildHierarchical(String scheme, String host) throws GalimatiasParseException {
        if (!URLUtils.isRelativeScheme(scheme)) {
            throw new GalimatiasParseException("Scheme is not relative: " + scheme);
        }
        return new URLParser(scheme + "://" + host).parse();
    }

    public static URL buildFile() throws GalimatiasParseException {
        return new URLParser("file://").parse();
    }

    public static URL buildOpaque(String scheme) throws GalimatiasParseException {
        if (URLUtils.isRelativeScheme(scheme)) {
            throw new GalimatiasParseException("Scheme is relative: " + scheme);
        }
        return new URLParser(scheme + ":").parse();
    }

    public URL withScheme(String newScheme) throws GalimatiasParseException {
        if (this.scheme.equalsIgnoreCase(newScheme)) {
            return this;
        }
        if (newScheme == null) {
            throw new NullPointerException("null scheme");
        }
        if (newScheme.isEmpty()) {
            throw new GalimatiasParseException("empty scheme");
        }
        if (URLUtils.isRelativeScheme(newScheme) == URLUtils.isRelativeScheme(this.scheme)) {
            return new URLParser(newScheme + ":", this, URLParser.ParseURLState.SCHEME_START).parse();
        }
        return new URLParser(this.toString().replaceFirst(this.scheme, newScheme)).parse();
    }

    public URL withUsername(String newUserName) throws GalimatiasParseException {
        if (!this.isHierarchical) {
            throw new GalimatiasParseException("Cannot set username on opaque URL");
        }
        String string = newUserName = newUserName == null ? "" : new URLParser(newUserName).parseUsername();
        if (this.username.equals(newUserName)) {
            return this;
        }
        return new URL(this.scheme, this.schemeData, newUserName, this.password, this.host, this.port, this.path, this.query, this.fragment, true);
    }

    public URL withPassword(String newPassword) throws GalimatiasParseException {
        if (!this.isHierarchical) {
            throw new GalimatiasParseException("Cannot set password on opaque URL");
        }
        if (this.password != null && this.password.equals(newPassword)) {
            return this;
        }
        newPassword = newPassword == null || newPassword.isEmpty() ? null : new URLParser(newPassword).parsePassword();
        return new URL(this.scheme, this.schemeData, this.username, newPassword, this.host, this.port, this.path, this.query, this.fragment, true);
    }

    public URL withHost(String newHost) throws GalimatiasParseException {
        if (!this.isHierarchical) {
            throw new GalimatiasParseException("Cannot set host on opaque URL");
        }
        return this.withHost(Host.parseHost(newHost));
    }

    public URL withHost(Host newHost) throws GalimatiasParseException {
        if (!this.isHierarchical) {
            throw new GalimatiasParseException("Cannot set host on opaque URL");
        }
        if (newHost == null) {
            throw new NullPointerException("null host");
        }
        if (this.host != null && this.host.equals(newHost)) {
            return this;
        }
        return new URL(this.scheme, this.schemeData, this.username, this.password, newHost, this.port, this.path, this.query, this.fragment, true);
    }

    public URL withPort(int newPort) throws GalimatiasParseException {
        if (!this.isHierarchical) {
            throw new GalimatiasParseException("Cannot set port on opaque URL");
        }
        if (newPort == this.port) {
            return this;
        }
        if (this.port == -1 && newPort == this.defaultPort()) {
            return this;
        }
        return new URL(this.scheme, this.schemeData, this.username, this.password, this.host, newPort, this.path, this.query, this.fragment, true);
    }

    public URL withPath(String newPath) throws GalimatiasParseException {
        if (!this.isHierarchical) {
            throw new GalimatiasParseException("Cannot set path on opaque URL");
        }
        return new URLParser(newPath, this, URLParser.ParseURLState.RELATIVE_PATH_START).parse();
    }

    public URL withQuery(String newQuery) throws GalimatiasParseException {
        if (this.query == newQuery) {
            return this;
        }
        if (this.query != null && this.query.equals(newQuery)) {
            return this;
        }
        if (newQuery == null) {
            return new URL(this.scheme, this.schemeData, this.username, this.password, this.host, this.port, this.path, null, this.fragment, true);
        }
        if (newQuery.isEmpty()) {
            return new URL(this.scheme, this.schemeData, this.username, this.password, this.host, this.port, this.path, newQuery, this.fragment, true);
        }
        String parseQuery = newQuery.charAt(0) == '?' ? newQuery.substring(1, newQuery.length()) : newQuery;
        return new URLParser(parseQuery, this, URLParser.ParseURLState.QUERY).parse();
    }

    public URL withFragment(String newFragment) throws GalimatiasParseException {
        if (this.fragment == newFragment) {
            return this;
        }
        if (this.fragment != null && this.fragment.equals(newFragment)) {
            return this;
        }
        if (newFragment == null) {
            return new URL(this.scheme, this.schemeData, this.username, this.password, this.host, this.port, this.path, this.query, null, true);
        }
        if (newFragment.isEmpty()) {
            return new URL(this.scheme, this.schemeData, this.username, this.password, this.host, this.port, this.path, this.query, newFragment, true);
        }
        String parseFragment = newFragment.charAt(0) == '#' ? newFragment.substring(1, newFragment.length()) : newFragment;
        return new URLParser(parseFragment, this, URLParser.ParseURLState.FRAGMENT).parse();
    }

    public URI toJavaURI() throws URISyntaxException {
        if (this.isHierarchical) {
            return new URI(this.scheme(), !"".equals(this.userInfo()) ? URLUtils.percentDecode(this.userInfo()) : null, this.host() != null ? this.host().toString() : null, this.port, this.path() != null ? URLUtils.percentDecode(this.path()) : null, this.query() != null ? URLUtils.percentDecode(this.query()) : null, this.fragment() != null ? URLUtils.percentDecode(this.fragment()) : null);
        }
        return new URI(this.scheme(), URLUtils.percentDecode(this.schemeData()) + (this.query() == null ? "" : "?" + URLUtils.percentDecode(this.query())), this.fragment() != null ? URLUtils.percentDecode(this.fragment()) : null);
    }

    public java.net.URL toJavaURL() throws MalformedURLException {
        return new java.net.URL(this.toString());
    }

    public static URL fromJavaURI(URI uri) {
        try {
            return new URLParser(uri.toString()).parse();
        }
        catch (GalimatiasParseException e) {
            throw new RuntimeException("BUG", e);
        }
    }

    public static URL fromJavaURL(java.net.URL url) {
        try {
            return new URLParser(url.toString()).parse();
        }
        catch (GalimatiasParseException e) {
            throw new RuntimeException("BUG", e);
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append(this.scheme).append(':');
        if (this.isHierarchical) {
            output.append("//");
            String userInfo = this.userInfo();
            if (!userInfo.isEmpty()) {
                output.append(userInfo).append('@');
            }
            if (this.host != null) {
                output.append(this.host.toHostString());
            }
            if (this.port != -1) {
                output.append(':').append(this.port);
            }
            if (this.path != null) {
                output.append(this.path);
            }
        } else {
            output.append(this.schemeData);
        }
        if (this.query != null) {
            output.append('?').append(this.query);
        }
        if (this.fragment != null) {
            output.append('#').append(this.fragment);
        }
        return output.toString();
    }

    public String toHumanString() {
        StringBuilder output = new StringBuilder();
        output.append(this.scheme).append(':');
        if (this.isHierarchical) {
            output.append("//");
            String userInfo = this.userInfo();
            if (!userInfo.isEmpty()) {
                output.append(URLUtils.percentDecode(userInfo)).append('@');
            }
            if (this.host != null) {
                if (this.host instanceof IPv6Address) {
                    output.append(this.host.toHostString());
                } else {
                    output.append(this.host.toHumanString());
                }
            }
            if (this.port != -1) {
                output.append(':').append(this.port);
            }
            if (this.path != null) {
                output.append(URLUtils.percentDecode(this.path));
            }
        } else {
            output.append(URLUtils.percentDecode(this.schemeData));
        }
        if (this.query != null) {
            output.append('?').append(URLUtils.percentDecode(this.query));
        }
        if (this.fragment != null) {
            output.append('#').append(URLUtils.percentDecode(this.fragment));
        }
        return output.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URL)) {
            return false;
        }
        URL other = (URL)obj;
        return this.isHierarchical == other.isHierarchical && (this.scheme == null ? other.scheme == null : this.scheme.equals(other.scheme)) && (this.schemeData == null ? other.schemeData == null : this.schemeData.equals(other.schemeData)) && (this.username == null ? other.username == null : this.username.equals(other.username)) && (this.password == null ? other.password == null : this.password.equals(other.password)) && (this.host == null ? other.host == null : this.host.equals(other.host)) && this.port == other.port && (this.path == null ? other.host == null : this.path.equals(other.path)) && (this.fragment == null ? other.fragment == null : this.fragment.equals(other.fragment)) && (this.query == null ? other.query == null : this.query.equals(other.query));
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.schemeData != null ? this.schemeData.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (this.port != -1 ? this.port : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() + 1 : 0);
        result = 31 * result + (this.fragment != null ? this.fragment.hashCode() + 1 : 0);
        result = 31 * result + (this.isHierarchical ? 1 : 0);
        return result;
    }
}

