/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.image.node.DelegationTokenImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.DelegationTokenData;

public final class DelegationTokenImage {
    public static final DelegationTokenImage EMPTY = new DelegationTokenImage(Collections.emptyMap());
    private final Map<String, DelegationTokenData> tokens;

    public DelegationTokenImage(Map<String, DelegationTokenData> tokens) {
        this.tokens = Collections.unmodifiableMap(tokens);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        if (options.metadataVersion().isDelegationTokenSupported()) {
            for (Map.Entry<String, DelegationTokenData> entry : this.tokens.entrySet()) {
                writer.write(0, entry.getValue().toRecord());
            }
        } else if (!this.tokens.isEmpty()) {
            ArrayList<String> tokenIds = new ArrayList<String>(this.tokens.keySet());
            StringBuffer delegationTokenImageString = new StringBuffer("DelegationTokenImage(");
            delegationTokenImageString.append(tokenIds.stream().collect(Collectors.joining(", ")));
            delegationTokenImageString.append(")");
            options.handleLoss(delegationTokenImageString.toString());
        }
    }

    public Map<String, DelegationTokenData> tokens() {
        return this.tokens;
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public int hashCode() {
        return this.tokens.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DelegationTokenImage.class)) {
            return false;
        }
        DelegationTokenImage other = (DelegationTokenImage)o;
        return this.tokens.equals(other.tokens);
    }

    public String toString() {
        return new DelegationTokenImageNode(this).stringify();
    }
}

