/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocCollection
extends ZkNodeProps
implements Iterable<Slice> {
    public static final String COLLECTIONS_ZKNODE = "/collections";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int znodeVersion;
    private final String name;
    private final String configName;
    private final Map<String, Slice> slices;
    private final Map<String, Slice> activeSlices;
    private final Slice[] activeSlicesArr;
    private final Map<String, List<Replica>> nodeNameReplicas;
    private final Map<String, List<Replica>> nodeNameLeaderReplicas;
    private final DocRouter router;
    private final String znode;
    private final Integer replicationFactor;
    private final Integer numNrtReplicas;
    private final Integer numTlogReplicas;
    private final Integer numPullReplicas;
    private final Boolean readOnly;
    private final Instant creationTime;
    private final Boolean perReplicaState;
    private final Map<String, Replica> replicaMap = new HashMap<String, Replica>();
    private AtomicReference<PerReplicaStates> perReplicaStatesRef;

    @Deprecated
    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router) {
        this(name, slices, props, router, Integer.MAX_VALUE, Instant.EPOCH, null);
    }

    @Deprecated
    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router, int zkVersion) {
        this(name, slices, props, router, zkVersion, Instant.EPOCH, null);
    }

    private DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router, int zkVersion, Instant creationTime, AtomicReference<PerReplicaStates> perReplicaStatesRef) {
        super(props);
        Boolean readOnly;
        this.znodeVersion = zkVersion == -1 ? Integer.MAX_VALUE : zkVersion;
        this.name = name;
        this.configName = (String)props.get("configName");
        this.slices = slices;
        this.activeSlices = new HashMap<String, Slice>();
        this.nodeNameLeaderReplicas = new HashMap<String, List<Replica>>();
        this.nodeNameReplicas = new HashMap<String, List<Replica>>();
        this.replicationFactor = (Integer)DocCollection.verifyProp(props, "replicationFactor");
        this.numNrtReplicas = (Integer)DocCollection.verifyProp(props, "nrtReplicas", 0);
        this.numTlogReplicas = (Integer)DocCollection.verifyProp(props, "tlogReplicas", 0);
        this.numPullReplicas = (Integer)DocCollection.verifyProp(props, "pullReplicas", 0);
        this.perReplicaState = (Boolean)DocCollection.verifyProp(props, "perReplicaState", Boolean.FALSE);
        if (this.perReplicaState.booleanValue()) {
            if (perReplicaStatesRef == null || perReplicaStatesRef.get() == null) {
                throw new RuntimeException("perReplicaState = true , but perReplicaStates param is not provided");
            }
            this.perReplicaStatesRef = perReplicaStatesRef;
            for (Slice s : this.slices.values()) {
                s.setPerReplicaStatesRef(this.perReplicaStatesRef);
            }
        }
        this.readOnly = (readOnly = (Boolean)DocCollection.verifyProp(props, "readOnly")) == null ? Boolean.FALSE : readOnly;
        this.creationTime = creationTime;
        for (Map.Entry<String, Slice> slice : slices.entrySet()) {
            if (slice.getValue().getState() == Slice.State.ACTIVE) {
                this.activeSlices.put(slice.getKey(), slice.getValue());
            }
            for (Replica replica : slice.getValue()) {
                this.addNodeNameReplica(replica);
                if (!this.perReplicaState.booleanValue()) continue;
                this.replicaMap.put(replica.getName(), replica);
            }
        }
        this.activeSlicesArr = this.activeSlices.values().toArray(new Slice[0]);
        this.router = router;
        this.znode = DocCollection.getCollectionPath(name);
        assert (name != null && slices != null);
    }

    public static DocCollection create(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router, int zkVersion, Instant creationTime, PrsSupplier prsSupplier) {
        PerReplicaStates perReplicaStates;
        boolean perReplicaState = (Boolean)DocCollection.verifyProp(props, "perReplicaState", Boolean.FALSE);
        if (perReplicaState) {
            if (prsSupplier == null) {
                throw new IllegalArgumentException("perReplicaState = true , but prsSupplier is not provided");
            }
            perReplicaStates = !DocCollection.hasAnyReplica(slices) ? PerReplicaStates.empty(name) : (PerReplicaStates)prsSupplier.get();
        } else {
            perReplicaStates = null;
        }
        return new DocCollection(name, slices, props, router, zkVersion, creationTime, perReplicaStates != null ? new AtomicReference<PerReplicaStates>(perReplicaStates) : null);
    }

    private static boolean hasAnyReplica(Map<String, Slice> slices) {
        for (Slice slice : slices.values()) {
            if (slice.getReplicasMap().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static String getCollectionPath(String coll) {
        return DocCollection.getCollectionPathRoot(coll) + "/state.json";
    }

    public static String getCollectionPathRoot(String coll) {
        return "/collections/" + coll;
    }

    public final DocCollection setPerReplicaStates(PerReplicaStates newPerReplicaStates) {
        if (this.perReplicaStatesRef != null) {
            log.debug("In-place update of PRS: {}", (Object)newPerReplicaStates);
            this.perReplicaStatesRef.set(newPerReplicaStates);
        }
        return this;
    }

    private void addNodeNameReplica(Replica replica) {
        List<Replica> replicas = this.nodeNameReplicas.get(replica.getNodeName());
        if (replicas == null) {
            replicas = new ArrayList<Replica>();
            this.nodeNameReplicas.put(replica.getNodeName(), replicas);
        }
        replicas.add(replica);
        if (replica.getStr("leader") != null) {
            List<Replica> leaderReplicas = this.nodeNameLeaderReplicas.get(replica.getNodeName());
            if (leaderReplicas == null) {
                leaderReplicas = new ArrayList<Replica>();
                this.nodeNameLeaderReplicas.put(replica.getNodeName(), leaderReplicas);
            }
            leaderReplicas.add(replica);
        }
    }

    public static Object verifyProp(Map<String, Object> props, String propName) {
        return DocCollection.verifyProp(props, propName, null);
    }

    private static Object verifyProp(Map<String, Object> props, String propName, Object def) {
        Object o = props.get(propName);
        if (o == null) {
            return def;
        }
        switch (propName) {
            case "replicationFactor": 
            case "nrtReplicas": 
            case "pullReplicas": 
            case "tlogReplicas": {
                return Integer.parseInt(o.toString());
            }
            case "perReplicaState": 
            case "readOnly": {
                return Boolean.parseBoolean(o.toString());
            }
        }
        return o;
    }

    public DocCollection copyWithSlices(Map<String, Slice> slices) {
        DocCollection result = new DocCollection(this.getName(), slices, this.propMap, this.router, this.znodeVersion, this.creationTime, this.perReplicaStatesRef);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigName() {
        assert (this.configName != null);
        return this.configName;
    }

    public Slice getSlice(String sliceName) {
        return this.slices.get(sliceName);
    }

    public void forEachReplica(BiConsumer<String, Replica> consumer) {
        this.slices.forEach((? super K shard, ? super V slice) -> slice.getReplicasMap().forEach((? super K s, ? super V replica) -> consumer.accept((String)shard, (Replica)replica)));
    }

    public Collection<Slice> getSlices() {
        return this.slices.values();
    }

    public Collection<Slice> getActiveSlices() {
        return this.activeSlices.values();
    }

    @Deprecated
    public Slice[] getActiveSlicesArr() {
        return this.activeSlicesArr;
    }

    public Map<String, Slice> getSlicesMap() {
        return this.slices;
    }

    public Map<String, Slice> getActiveSlicesMap() {
        return this.activeSlices;
    }

    public List<Replica> getReplicas(String nodeName) {
        return this.nodeNameReplicas.get(nodeName);
    }

    @Deprecated
    public List<Replica> getLeaderReplicas(String nodeName) {
        return this.nodeNameLeaderReplicas.get(nodeName);
    }

    public int getZNodeVersion() {
        return this.znodeVersion;
    }

    public int getChildNodesVersion() {
        return this.perReplicaStatesRef == null ? 0 : this.perReplicaStatesRef.get().cversion;
    }

    public boolean isModified(int dataVersion, int childVersion) {
        if (dataVersion > this.znodeVersion) {
            return true;
        }
        return childVersion > this.getChildNodesVersion();
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getZNode() {
        return this.znode;
    }

    public DocRouter getRouter() {
        return this.router;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String toString() {
        return "DocCollection(" + this.name + "/" + this.getZNode() + "/" + this.znodeVersion + " " + (this.perReplicaStatesRef == null ? "" : this.perReplicaStatesRef.get()) + ")=" + Utils.toJSONString(this);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.propMap.forEach(ew.getBiConsumer());
        ew.put((CharSequence)"shards", this.slices);
    }

    public Replica getReplica(String coreNodeName) {
        if (this.perReplicaState.booleanValue()) {
            return this.replicaMap.get(coreNodeName);
        }
        for (Slice slice : this.slices.values()) {
            Replica replica = slice.getReplica(coreNodeName);
            if (replica == null) continue;
            return replica;
        }
        return null;
    }

    public Replica getLeader(String sliceName) {
        Slice slice = this.getSlice(sliceName);
        if (slice == null) {
            return null;
        }
        return slice.getLeader();
    }

    public static boolean isFullyActive(Set<String> liveNodes, DocCollection collectionState, int expectedShards, int expectedReplicas) {
        Objects.requireNonNull(liveNodes);
        if (collectionState == null) {
            return false;
        }
        int activeShards = 0;
        for (Slice slice : collectionState) {
            int activeReplicas = 0;
            for (Replica replica : slice) {
                if (!replica.isActive(liveNodes)) {
                    return false;
                }
                ++activeReplicas;
            }
            if (activeReplicas != expectedReplicas) {
                return false;
            }
            ++activeShards;
        }
        return activeShards == expectedShards;
    }

    @Override
    public Iterator<Slice> iterator() {
        return this.slices.values().iterator();
    }

    @Deprecated
    public List<Replica> getReplicas() {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Slice slice : this) {
            replicas.addAll(slice.getReplicas());
        }
        return replicas;
    }

    @Deprecated
    public Replica getReplica(BiPredicate<String, Replica> predicate) {
        Replica[] result = new Replica[1];
        this.forEachReplica((s, replica) -> {
            if (result[0] != null) {
                return;
            }
            if (predicate.test((String)s, (Replica)replica)) {
                result[0] = replica;
            }
        });
        return result[0];
    }

    @Deprecated
    public List<Replica> getReplicas(EnumSet<Replica.Type> s) {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Slice slice : this) {
            replicas.addAll(slice.getReplicas(s));
        }
        return replicas;
    }

    public String getShardId(String nodeName, String coreName) {
        for (Slice slice : this) {
            for (Replica replica : slice) {
                if (!Objects.equals(replica.getNodeName(), nodeName) || !Objects.equals(replica.getCoreName(), coreName)) continue;
                return slice.getName();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof DocCollection)) {
            return false;
        }
        DocCollection other = (DocCollection)that;
        return super.equals(that) && Objects.equals(this.name, other.name) && this.znodeVersion == other.znodeVersion && this.getChildNodesVersion() == other.getChildNodesVersion();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.znodeVersion, this.getChildNodesVersion());
    }

    public Integer getNumNrtReplicas() {
        return this.numNrtReplicas;
    }

    public Integer getNumTlogReplicas() {
        return this.numTlogReplicas;
    }

    public Integer getNumPullReplicas() {
        return this.numPullReplicas;
    }

    public boolean isPerReplicaState() {
        return Boolean.TRUE.equals(this.perReplicaState);
    }

    public PerReplicaStates getPerReplicaStates() {
        return this.perReplicaStatesRef != null ? this.perReplicaStatesRef.get() : null;
    }

    public int getExpectedReplicaCount(Replica.Type type, int def) {
        Integer result = null;
        if (type == Replica.Type.NRT) {
            result = this.numNrtReplicas;
        }
        if (type == Replica.Type.PULL) {
            result = this.numPullReplicas;
        }
        if (type == Replica.Type.TLOG) {
            result = this.numTlogReplicas;
        }
        return result == null ? def : result;
    }

    public static interface PrsSupplier
    extends Supplier<PerReplicaStates> {
    }

    public static interface CollectionStateProps {
        public static final String NRT_REPLICAS = "nrtReplicas";
        public static final String PULL_REPLICAS = "pullReplicas";
        public static final String TLOG_REPLICAS = "tlogReplicas";
        public static final String REPLICATION_FACTOR = "replicationFactor";
        public static final String READ_ONLY = "readOnly";
        public static final String CONFIGNAME = "configName";
        public static final String DOC_ROUTER = "router";
        public static final String SHARDS = "shards";
        public static final String PER_REPLICA_STATE = "perReplicaState";
    }
}

